/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.android.org.kxml2.io.KXmlSerializer;
import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.EntryWriterSerializer;
import com.reandroid.apk.xmldecoder.XMLEntryDecoder;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.common.EntryStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class XMLEntryDecoderSerializer
extends XMLEntryDecoder<XmlSerializer>
implements Closeable {
    private final EntryWriterSerializer entryWriterSerializer;
    private Closeable mClosable;
    private boolean mStart;

    public XMLEntryDecoderSerializer(EntryStore entryStore, XmlSerializer serializer) {
        super(entryStore);
        this.entryWriterSerializer = new EntryWriterSerializer(serializer);
    }

    public XMLEntryDecoderSerializer(EntryStore entryStore) {
        this(entryStore, new KXmlSerializer());
    }

    public int decode(File resDirectory, SpecTypePair specTypePair) throws IOException {
        int count = specTypePair.hasDuplicateResConfig(true) ? this.decodeDuplicateConfigs(resDirectory, specTypePair) : this.decodeUniqueConfigs(resDirectory, specTypePair);
        return count;
    }

    private int decodeDuplicateConfigs(File resDirectory, SpecTypePair specTypePair) throws IOException {
        List<ResConfig> resConfigList = specTypePair.listResConfig();
        Collection<EntryGroup> entryGroupList = specTypePair.createEntryGroups(true).values();
        int total = 0;
        for (ResConfig resConfig : resConfigList) {
            TypeBlock typeBlock = resConfig.getParentInstance(TypeBlock.class);
            File outXml = this.toOutXmlFile(resDirectory, typeBlock);
            total += this.decode(outXml, resConfig, entryGroupList);
        }
        return total;
    }

    private int decodeUniqueConfigs(File resDirectory, SpecTypePair specTypePair) throws IOException {
        int total = 0;
        Iterator<TypeBlock> itr = specTypePair.iteratorNonEmpty();
        while (itr.hasNext()) {
            TypeBlock typeBlock = itr.next();
            File outXml = this.toOutXmlFile(resDirectory, typeBlock);
            total += this.decode(outXml, typeBlock);
        }
        return total;
    }

    public int decode(File outXmlFile, ResConfig resConfig, Collection<EntryGroup> entryGroupList) throws IOException {
        this.setOutput(outXmlFile);
        int count = this.decode(resConfig, entryGroupList);
        this.close();
        this.deleteIfZero(count, outXmlFile);
        return count;
    }

    public int decode(File outXmlFile, TypeBlock typeBlock) throws IOException {
        this.setOutput(outXmlFile);
        int count = super.decode(this.entryWriterSerializer, typeBlock);
        this.close();
        this.deleteIfZero(count, outXmlFile);
        return count;
    }

    public int decode(ResConfig resConfig, Collection<EntryGroup> entryGroupList) throws IOException {
        return super.decode(this.entryWriterSerializer, resConfig, entryGroupList);
    }

    public void setOutput(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.setOutput(new FileOutputStream(file));
    }

    public void setOutput(OutputStream outputStream) throws IOException {
        this.close();
        this.getXmlSerializer().setOutput(outputStream, StandardCharsets.UTF_8.name());
        this.mClosable = outputStream;
        this.start();
    }

    public void setOutput(Writer writer) throws IOException {
        this.close();
        this.getXmlSerializer().setOutput(writer);
        this.mClosable = writer;
        this.start();
    }

    private void start() throws IOException {
        if (!this.mStart) {
            XmlSerializer xmlSerializer = this.getXmlSerializer();
            xmlSerializer.startDocument("utf-8", null);
            XmlHelper.setIndent(xmlSerializer, true);
            xmlSerializer.startTag(null, "resources");
            this.mStart = true;
        }
    }

    private void end() throws IOException {
        if (this.mStart) {
            XmlSerializer xmlSerializer = this.getXmlSerializer();
            XmlHelper.setIndent(xmlSerializer, true);
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            this.mStart = false;
        }
    }

    private XmlSerializer getXmlSerializer() {
        return this.entryWriterSerializer.getXmlSerializer();
    }

    @Override
    public void close() throws IOException {
        Closeable closeable = this.mClosable;
        this.end();
        if (closeable != null) {
            closeable.close();
        }
        this.mClosable = null;
    }
}

