/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.xmldecoder.DecoderResTableEntry;
import com.reandroid.apk.xmldecoder.DecoderResTableEntryMap;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.common.EntryStore;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public class XMLEntryDecoder<OUTPUT> {
    private final Object mLock = new Object();
    private final DecoderResTableEntry<OUTPUT> decoderEntry;
    private final DecoderResTableEntryMap<OUTPUT> decoderEntryMap;
    private Predicate<Entry> mDecodedEntries;

    public XMLEntryDecoder(EntryStore entryStore) {
        this.decoderEntry = new DecoderResTableEntry(entryStore);
        this.decoderEntryMap = new DecoderResTableEntryMap(entryStore);
    }

    public void setDecodedEntries(Predicate<Entry> decodedEntries) {
        this.mDecodedEntries = decodedEntries;
    }

    private boolean shouldDecode(Entry entry) {
        if (entry == null || entry.isNull()) {
            return false;
        }
        if (this.mDecodedEntries != null) {
            return this.mDecodedEntries.test(entry);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OUTPUT decode(EntryWriter<OUTPUT> writer, Entry entry) throws IOException {
        if (!this.shouldDecode(entry)) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            TableEntry<?, ?> tableEntry = entry.getTableEntry();
            if (tableEntry instanceof ResTableMapEntry) {
                return this.decoderEntryMap.decode((ResTableMapEntry)tableEntry, writer);
            }
            return this.decoderEntry.decode((ResTableEntry)tableEntry, writer);
        }
    }

    public int decode(EntryWriter<OUTPUT> writer, Collection<Entry> entryList) throws IOException {
        int count = 0;
        for (Entry entry : entryList) {
            OUTPUT output = this.decode(writer, entry);
            if (output == null) continue;
            ++count;
        }
        return count;
    }

    public int decode(EntryWriter<OUTPUT> writer, ResConfig resConfig, Collection<EntryGroup> entryGroupList) throws IOException {
        int count = 0;
        for (EntryGroup entryGroup : entryGroupList) {
            OUTPUT output = this.decode(writer, entryGroup.getEntry(resConfig));
            if (output == null) continue;
            ++count;
        }
        return count;
    }

    public int decode(EntryWriter<OUTPUT> writer, TypeBlock typeBlock) throws IOException {
        Iterator iterator = typeBlock.getEntryArray().iterator(true);
        int count = 0;
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            OUTPUT output = this.decode(writer, entry);
            if (output == null) continue;
            ++count;
        }
        return count;
    }

    void deleteIfZero(int decodeCount, File file) {
        if (decodeCount > 0) {
            return;
        }
        file.delete();
        File dir = file.getParentFile();
        if (this.isEmptyDirectory(dir)) {
            dir.delete();
        }
    }

    private boolean isEmptyDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        return files == null || files.length == 0;
    }

    File toOutXmlFile(File resDirectory, TypeBlock typeBlock) {
        String path = this.toValuesXml(typeBlock);
        return new File(resDirectory, path);
    }

    String toValuesXml(TypeBlock typeBlock) {
        StringBuilder builder = new StringBuilder();
        char sepChar = File.separatorChar;
        builder.append("values");
        builder.append(typeBlock.getQualifiers());
        builder.append(sepChar);
        String type = typeBlock.getTypeName();
        builder.append(type);
        if (!type.endsWith("s")) {
            builder.append('s');
        }
        builder.append(".xml");
        return builder.toString();
    }
}

