/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.parser.XMLSpanParser;
import java.io.IOException;

public class XMLDecodeHelper {
    public static boolean writeTextContent(EntryWriter<?> writer, StringItem stringItem) throws IOException {
        if (stringItem == null) {
            return false;
        }
        if (!stringItem.hasStyle()) {
            String text = stringItem.get();
            text = ValueDecoder.escapeSpecialCharacter(text);
            text = ValueDecoder.quoteWhitespace(text);
            writer.text(text);
            return false;
        }
        String xml = stringItem.getXml();
        XMLElement element = XMLDecodeHelper.parseSpanSafe(xml);
        if (element != null) {
            XMLDecodeHelper.writeParsedSpannable(writer, element);
        } else {
            writer.text(xml);
        }
        return true;
    }

    public static void writeParsedSpannable(EntryWriter<?> writer, XMLElement spannableParent) throws IOException {
        for (XMLNode xmlNode : spannableParent.getChildNodes()) {
            if (xmlNode instanceof XMLText) {
                String text = ((XMLText)xmlNode).getText(true);
                writer.enableIndent(false);
                writer.text(ValueDecoder.escapeSpecialCharacter(text));
                continue;
            }
            if (!(xmlNode instanceof XMLElement)) continue;
            XMLDecodeHelper.writeElement(writer, (XMLElement)xmlNode);
        }
    }

    private static void writeElement(EntryWriter<?> writer, XMLElement element) throws IOException {
        writer.enableIndent(false);
        writer.startTag(element.getTagName());
        for (XMLAttribute xmlAttribute : element.listAttributes()) {
            writer.attribute(xmlAttribute.getName(), xmlAttribute.getValue());
        }
        for (XMLNode xmlNode : element.getChildNodes()) {
            if (xmlNode instanceof XMLText) {
                String text = ((XMLText)xmlNode).getText(true);
                writer.text(text);
                continue;
            }
            if (!(xmlNode instanceof XMLElement)) continue;
            XMLDecodeHelper.writeElement(writer, (XMLElement)xmlNode);
        }
        writer.endTag(element.getTagName());
    }

    private static XMLElement parseSpanSafe(String spanText) {
        if (spanText == null) {
            return null;
        }
        try {
            XMLSpanParser spanParser = new XMLSpanParser();
            return spanParser.parse(spanText);
        }
        catch (XMLException ignored) {
            return null;
        }
    }
}

