/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.android.org.kxml2.io.KXmlSerializer;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.xmldecoder.XMLNamespaceValidator;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlPullParser;
import com.reandroid.arsc.coder.Decoder;
import com.reandroid.xml.XmlParserToSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlDocumentSerializer
implements ResXmlPullParser.DocumentLoadedListener {
    private final Object mLock = new Object();
    private final ResXmlPullParser parser;
    private final XmlSerializer serializer;
    private final XmlParserToSerializer parserToSerializer;
    private boolean validateXmlNamespace;
    private String mCurrentPath;

    public ResXmlDocumentSerializer(ResXmlPullParser parser) {
        this.parser = parser;
        this.serializer = new KXmlSerializer();
        this.parserToSerializer = new XmlParserToSerializer(parser, this.serializer);
        this.parser.setDocumentLoadedListener(this);
    }

    public ResXmlDocumentSerializer(Decoder decoder) {
        this(new ResXmlPullParser(decoder));
    }

    public ResXmlDocumentSerializer(ApkModule apkModule) {
        this(ResXmlDocumentSerializer.createDecoder(apkModule));
    }

    public void write(InputSource inputSource, File file) throws IOException, XmlPullParserException {
        this.write(inputSource.openStream(), file);
    }

    public void write(InputSource inputSource, OutputStream outputStream) throws IOException, XmlPullParserException {
        this.write(inputSource.openStream(), outputStream);
        inputSource.disposeInputSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream inputStream, OutputStream outputStream) throws IOException, XmlPullParserException {
        Object object = this.mLock;
        synchronized (object) {
            this.parser.setInput(inputStream, null);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            this.serializer.setOutput(writer);
            try {
                this.parserToSerializer.write();
            }
            catch (Exception ex) {
                throw this.getError(ex);
            }
            writer.close();
            outputStream.close();
            this.mCurrentPath = null;
        }
    }

    public void write(InputStream inputStream, File file) throws IOException, XmlPullParserException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.mCurrentPath = String.valueOf(file);
        FileOutputStream outputStream = new FileOutputStream(file);
        this.write(inputStream, (OutputStream)outputStream);
    }

    public void write(ResXmlDocument xmlDocument, File file) throws IOException, XmlPullParserException {
        this.mCurrentPath = String.valueOf(file);
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.write(xmlDocument, (OutputStream)outputStream);
    }

    public void write(ResXmlDocument xmlDocument, OutputStream outputStream) throws IOException, XmlPullParserException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.write(xmlDocument, writer);
        writer.close();
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ResXmlDocument xmlDocument, Writer writer) throws IOException, XmlPullParserException {
        Object object = this.mLock;
        synchronized (object) {
            this.parser.setResXmlDocument(xmlDocument);
            this.serializer.setOutput(writer);
            this.parserToSerializer.write();
            writer.flush();
        }
    }

    public Decoder getDecoder() {
        return this.parser.getDecoder();
    }

    public void setValidateXmlNamespace(boolean validateXmlNamespace) {
        this.validateXmlNamespace = validateXmlNamespace;
    }

    @Override
    public ResXmlDocument onDocumentLoaded(ResXmlDocument resXmlDocument) {
        if (!this.validateXmlNamespace) {
            return resXmlDocument;
        }
        XMLNamespaceValidator.validateNamespaces(resXmlDocument);
        return resXmlDocument;
    }

    private IOException getError(Exception exception) {
        String path = this.mCurrentPath;
        if (exception instanceof IOException) {
            String msg = path + ":" + exception.getMessage();
            IOException ioException = new IOException(msg);
            ioException.setStackTrace(exception.getStackTrace());
            Throwable cause = ioException.getCause();
            if (cause != null) {
                ioException.initCause(cause);
            }
            return ioException;
        }
        String msg = path + ":" + exception.getClass() + ":" + exception.getMessage();
        IOException otherException = new IOException(msg);
        otherException.setStackTrace(exception.getStackTrace());
        Throwable cause = otherException.getCause();
        if (cause != null) {
            otherException.initCause(cause);
        }
        return otherException;
    }

    private static Decoder createDecoder(ApkModule apkModule) {
        Decoder decoder = Decoder.create(apkModule.getTableBlock());
        decoder.setApkFile(apkModule);
        return decoder;
    }
}

