/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import java.io.IOException;

public class EntryWriterElement
implements EntryWriter<XMLElement> {
    private XMLElement mCurrentElement;
    private XMLElement mResult;
    private boolean mEnableIndent;
    private static final String FEATURE_INDENT = "http://xmlpull.org/v1/doc/features.html#indent-output";

    public XMLElement getElement() {
        return this.mResult;
    }

    @Override
    public void setFeature(String name, Object value) {
        if (!FEATURE_INDENT.equals(name)) {
            return;
        }
        boolean state = false;
        if (value instanceof Boolean) {
            state = (Boolean)value;
        }
        this.mEnableIndent = state;
    }

    @Override
    public XMLElement startTag(String name) throws IOException {
        XMLElement xmlElement = new XMLElement(name);
        XMLElement current = this.mCurrentElement;
        if (current != null) {
            current.addChild(xmlElement);
        } else {
            this.mResult = null;
        }
        this.mCurrentElement = xmlElement;
        if (this.mEnableIndent) {
            xmlElement.setIndent(2);
            xmlElement.setIndentScale(1.0f);
        } else {
            xmlElement.setIndent(0);
            xmlElement.setIndentScale(0.0f);
        }
        return xmlElement;
    }

    @Override
    public XMLElement endTag(String name) throws IOException {
        XMLElement current = this.mCurrentElement;
        if (current == null) {
            throw new IOException("endTag called before startTag");
        }
        if (!name.equals(current.getTagName())) {
            throw new IOException("Mismatch endTag = " + name + ", expect = " + current.getTagName());
        }
        XMLElement parent = current.getParent();
        if (parent == null) {
            this.mResult = current;
        } else {
            current = parent;
        }
        this.mCurrentElement = parent;
        return current;
    }

    @Override
    public XMLElement attribute(String name, String value) {
        this.mCurrentElement.setAttribute(name, value);
        return this.mCurrentElement;
    }

    @Override
    public XMLElement text(String text) throws IOException {
        this.mCurrentElement.setTextContent(text, false);
        return this.mCurrentElement;
    }

    @Override
    public void comment(String comment) throws IOException {
        if (comment != null) {
            this.mCurrentElement.addComment(new XMLComment(comment));
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void enableIndent(boolean enable) {
        this.setFeature(FEATURE_INDENT, enable);
    }

    @Override
    public void writeTagIndent(int level) throws IOException {
        this.mCurrentElement.setIndent(level);
    }
}

