/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.apk.xmldecoder.XMLDecodeHelper;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import java.io.IOException;

abstract class DecoderTableEntry<INPUT extends TableEntry<?, ?>, OUTPUT> {
    private final EntryStore entryStore;
    static final int INDENT_ENTRY = 2;
    static final int INDENT_BAG = 4;

    public DecoderTableEntry(EntryStore entryStore) {
        this.entryStore = entryStore;
    }

    public EntryStore getEntryStore() {
        return this.entryStore;
    }

    public abstract OUTPUT decode(INPUT var1, EntryWriter<OUTPUT> var2) throws IOException;

    void writeText(EntryWriter<?> writer, PackageBlock packageBlock, ValueItem valueItem) throws IOException {
        if (valueItem.getValueType() == ValueType.STRING) {
            XMLDecodeHelper.writeTextContent(writer, valueItem.getDataAsPoolString());
        } else {
            String value = ValueDecoder.decodeEntryValue(this.getEntryStore(), packageBlock, valueItem.getValueType(), valueItem.getData());
            writer.text(value);
        }
    }

    void writeText(EntryWriter<?> writer, ResValueMap attributeValue) throws IOException {
        if (attributeValue.getValueType() == ValueType.STRING) {
            XMLDecodeHelper.writeTextContent(writer, attributeValue.getDataAsPoolString());
        } else {
            String value = ValueDecoder.decode(this.getEntryStore(), attributeValue.getPackageBlock().getId(), attributeValue);
            writer.text(value);
        }
    }
}

