/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.DecoderTableEntry;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import java.io.IOException;

public class DecoderResTableEntry<OUTPUT>
extends DecoderTableEntry<ResTableEntry, OUTPUT> {
    public DecoderResTableEntry(EntryStore entryStore) {
        super(entryStore);
    }

    @Override
    public OUTPUT decode(ResTableEntry tableEntry, EntryWriter<OUTPUT> writer) throws IOException {
        CommonType commonType;
        Entry entry = tableEntry.getParentEntry();
        String tag = XmlHelper.toXMLTagName(entry.getTypeName());
        writer.writeTagIndent(2);
        writer.startTag(tag);
        writer.attribute("name", entry.getName());
        ResValue value = (ResValue)tableEntry.getValue();
        ValueType valueType = value.getValueType();
        if (!this.isReference(valueType) && (commonType = CommonType.valueOf(tag)) != null && !commonType.contains(valueType)) {
            writer.attribute("type", valueType.getTypeName());
        }
        if (!this.isId(tag)) {
            this.writeText(writer, entry.getPackageBlock(), (ValueItem)tableEntry.getValue());
        }
        return writer.endTag(tag);
    }

    private boolean isReference(ValueType valueType) {
        return valueType == ValueType.ATTRIBUTE || valueType == ValueType.REFERENCE || valueType == ValueType.NULL;
    }

    private boolean isId(String tag) {
        return "id".equals(tag);
    }
}

