/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.BagDecoder;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.plurals.PluralsQuantity;
import com.reandroid.common.EntryStore;
import java.io.IOException;

class BagDecoderPlural<OUTPUT>
extends BagDecoder<OUTPUT> {
    public BagDecoderPlural(EntryStore entryStore) {
        super(entryStore);
    }

    @Override
    public OUTPUT decode(ResTableMapEntry mapEntry, EntryWriter<OUTPUT> writer) throws IOException {
        Entry entry = mapEntry.getParentEntry();
        String tag = XmlHelper.toXMLTagName(entry.getTypeName());
        writer.writeTagIndent(2);
        writer.startTag(tag);
        writer.attribute("name", entry.getName());
        ResValueMap[] resValueMaps = mapEntry.listResValueMap();
        PackageBlock packageBlock = entry.getPackageBlock();
        boolean hasBags = false;
        for (int i = 0; i < resValueMaps.length; ++i) {
            ResValueMap valueMap = resValueMaps[i];
            String childTag = "item";
            writer.writeTagIndent(4);
            writer.startTag(childTag);
            AttributeType quantity = valueMap.getAttributeType();
            if (quantity == null || !quantity.isPlural()) {
                throw new IOException("Unknown plural quantity: " + valueMap);
            }
            writer.attribute("quantity", quantity.getName());
            this.writeText(writer, packageBlock, valueMap);
            writer.endTag(childTag);
            hasBags = true;
        }
        if (hasBags) {
            writer.writeTagIndent(2);
        }
        return writer.endTag(tag);
    }

    @Override
    public boolean canDecode(ResTableMapEntry mapEntry) {
        return BagDecoderPlural.isResBagPluralsValue(mapEntry);
    }

    public static boolean isResBagPluralsValue(ResTableMapEntry valueItem) {
        int parentId = valueItem.getParentId();
        if (parentId != 0) {
            return false;
        }
        ResValueMap[] bagItems = valueItem.listResValueMap();
        if (bagItems == null || bagItems.length == 0) {
            return false;
        }
        for (ResValueMap item : bagItems) {
            int name = item.getName();
            int high = name >> 16 & 0xFFFF;
            if (high != 256) {
                return false;
            }
            int low = name & 0xFFFF;
            PluralsQuantity pq = PluralsQuantity.valueOf((short)low);
            if (pq != null) continue;
            return false;
        }
        return true;
    }
}

