/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.BagDecoder;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import java.io.IOException;

class BagDecoderCommon<OUTPUT>
extends BagDecoder<OUTPUT> {
    public BagDecoderCommon(EntryStore entryStore) {
        super(entryStore);
    }

    @Override
    public OUTPUT decode(ResTableMapEntry mapEntry, EntryWriter<OUTPUT> writer) throws IOException {
        Entry entry = mapEntry.getParentEntry();
        String tag = XmlHelper.toXMLTagName(entry.getTypeName());
        writer.writeTagIndent(2);
        writer.startTag(tag);
        writer.attribute("name", entry.getName());
        PackageBlock packageBlock = entry.getPackageBlock();
        int parentId = mapEntry.getParentId();
        String parent = parentId != 0 ? ValueDecoder.decodeEntryValue(this.getEntryStore(), packageBlock, ValueType.REFERENCE, parentId) : null;
        if (parent != null) {
            writer.attribute("parent", parent);
        }
        EntryStore entryStore = this.getEntryStore();
        ResValueMap[] resValueMaps = mapEntry.listResValueMap();
        boolean hasBags = false;
        for (int i = 0; i < resValueMaps.length; ++i) {
            ResValueMap valueMap = resValueMaps[i];
            String childTag = "item";
            writer.writeTagIndent(4);
            writer.startTag(childTag);
            String name = ValueDecoder.decodeAttributeName(entryStore, packageBlock, valueMap.getName());
            writer.attribute("name", name);
            this.writeText(writer, valueMap);
            writer.endTag(childTag);
            hasBags = true;
        }
        if (hasBags) {
            writer.writeTagIndent(2);
        }
        return writer.endTag(tag);
    }

    @Override
    public boolean canDecode(ResTableMapEntry mapEntry) {
        return mapEntry != null;
    }
}

