/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.BagDecoder;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.array.CompoundItemArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.common.EntryStore;
import java.io.IOException;

class BagDecoderAttr<OUTPUT>
extends BagDecoder<OUTPUT> {
    public BagDecoderAttr(EntryStore entryStore) {
        super(entryStore);
    }

    @Override
    public OUTPUT decode(ResTableMapEntry mapEntry, EntryWriter<OUTPUT> writer) throws IOException {
        Entry entry = mapEntry.getParentEntry();
        String tag = XmlHelper.toXMLTagName(entry.getTypeName());
        writer.writeTagIndent(2);
        writer.startTag(tag);
        writer.attribute("name", entry.getName());
        this.writeParentAttributes(writer, (CompoundItemArray)mapEntry.getValue());
        Object formatsMap = mapEntry.getByType(AttributeType.FORMATS);
        AttributeDataFormat bagType = AttributeDataFormat.typeOfBag(((ValueItem)formatsMap).getData());
        ResValueMap[] bagItems = mapEntry.listResValueMap();
        EntryStore entryStore = this.getEntryStore();
        PackageBlock packageBlock = entry.getPackageBlock();
        boolean hasBags = false;
        for (int i = 0; i < bagItems.length; ++i) {
            ResValueMap valueMap = bagItems[i];
            AttributeType attributeType = valueMap.getAttributeType();
            if (attributeType != null) continue;
            writer.writeTagIndent(4);
            writer.startTag(bagType.getName());
            String name = ValueDecoder.decodeAttributeName(entryStore, packageBlock, valueMap.getName());
            writer.attribute("name", name);
            int rawVal = valueMap.getData();
            String value = valueMap.getValueType() == ValueType.HEX ? HexUtil.toHex8(rawVal) : Integer.toString(rawVal);
            writer.text(value);
            writer.endTag(bagType.getName());
            hasBags = true;
        }
        if (hasBags) {
            writer.writeTagIndent(2);
        }
        return writer.endTag(tag);
    }

    private void writeParentAttributes(EntryWriter<OUTPUT> writer, CompoundItemArray<? extends ResValueMap> itemArray) throws IOException {
        for (ResValueMap valueMap : (ResValueMap[])itemArray.getChildes()) {
            String value;
            AttributeType type = valueMap.getAttributeType();
            if (type == null || (value = type == AttributeType.FORMATS ? AttributeDataFormat.toString(AttributeDataFormat.decodeValueTypes(valueMap.getData())) : Integer.toString(valueMap.getData())) == null) continue;
            writer.attribute(type.getName(), value);
        }
    }

    @Override
    public boolean canDecode(ResTableMapEntry mapEntry) {
        return AttributeBag.isAttribute(mapEntry);
    }
}

