/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmldecoder.BagDecoder;
import com.reandroid.apk.xmldecoder.EntryWriter;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import java.io.IOException;
import java.util.HashSet;

class BagDecoderArray<OUTPUT>
extends BagDecoder<OUTPUT> {
    public BagDecoderArray(EntryStore entryStore) {
        super(entryStore);
    }

    @Override
    public OUTPUT decode(ResTableMapEntry mapEntry, EntryWriter<OUTPUT> writer) throws IOException {
        Entry entry = mapEntry.getParentEntry();
        String tag = this.getTagName(mapEntry);
        writer.writeTagIndent(2);
        writer.startTag(tag);
        writer.attribute("name", entry.getName());
        PackageBlock packageBlock = entry.getPackageBlock();
        EntryStore entryStore = this.getEntryStore();
        ResValueMap[] resValueMaps = mapEntry.listResValueMap();
        boolean zero_name = BagDecoderArray.isZeroNameArray(resValueMaps);
        boolean hasBags = false;
        for (int i = 0; i < resValueMaps.length; ++i) {
            ResValueMap valueMap = resValueMaps[i];
            String childTag = "item";
            writer.writeTagIndent(4);
            writer.startTag(childTag);
            if (zero_name) {
                String name = ValueDecoder.decodeAttributeName(entryStore, packageBlock, valueMap.getName());
                writer.attribute("name", name);
            }
            this.writeText(writer, packageBlock, valueMap);
            writer.endTag(childTag);
            hasBags = true;
        }
        if (hasBags) {
            writer.writeTagIndent(2);
        }
        return writer.endTag(tag);
    }

    private String getTagName(ResTableMapEntry mapEntry) {
        ResValueMap[] resValueMaps = mapEntry.listResValueMap();
        HashSet<ValueType> valueTypes = new HashSet<ValueType>();
        for (int i = 0; i < resValueMaps.length; ++i) {
            valueTypes.add(resValueMaps[i].getValueType());
        }
        if (valueTypes.contains((Object)ValueType.STRING)) {
            return "string-array";
        }
        if (valueTypes.size() == 1 && valueTypes.contains((Object)ValueType.DEC)) {
            return "integer-array";
        }
        return XmlHelper.toXMLTagName(mapEntry.getParentEntry().getTypeName());
    }

    @Override
    public boolean canDecode(ResTableMapEntry mapEntry) {
        return BagDecoderArray.isArrayValue(mapEntry);
    }

    public static boolean isArrayValue(ResTableMapEntry mapEntry) {
        int parentId = mapEntry.getParentId();
        if (parentId != 0) {
            return false;
        }
        ResValueMap[] valueMapList = mapEntry.listResValueMap();
        if (valueMapList == null || valueMapList.length == 0) {
            return false;
        }
        if (BagDecoderArray.isIndexedArray(valueMapList)) {
            return true;
        }
        return BagDecoderArray.isZeroNameArray(valueMapList);
    }

    private static boolean isIndexedArray(ResValueMap[] resValueMapList) {
        int length = resValueMapList.length;
        for (int i = 0; i < length; ++i) {
            ResValueMap valueMap = resValueMapList[i];
            int name = valueMap.getName();
            int high = name >> 16 & 0xFFFF;
            if (high != 256 && high != 512) {
                return false;
            }
            int low = name & 0xFFFF;
            int id = low - 1;
            if (id == i) continue;
            return false;
        }
        return true;
    }

    private static boolean isZeroNameArray(ResValueMap[] resValueMapList) {
        int length = resValueMapList.length;
        for (int i = 0; i < length; ++i) {
            if (BagDecoderArray.isZeroName(resValueMapList[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isZeroName(ResValueMap resValueMap) {
        return resValueMap.getName() == 0;
    }
}

