/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.arsc.item.StringItem;
import com.reandroid.xml.XMLElement;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlHelper {
    public static final String RESOURCES_TAG = "resources";
    public static final String FEATURE_INDENT = "http://xmlpull.org/v1/doc/features.html#indent-output";

    public static Map<String, String> readAttributes(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (!XmlHelper.findElement(parser, elementName)) {
            return null;
        }
        return XmlHelper.mapAttributes(parser);
    }

    public static Map<String, String> mapAttributes(XmlPullParser parser) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            int index = name.indexOf(58);
            if (index > 0 && index < name.length() && !name.startsWith("xmlns:")) {
                name = name.substring(++index);
            }
            map.put(name, parser.getAttributeValue(i));
        }
        return map;
    }

    private static boolean findElement(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        int event;
        while ((event = parser.next()) != 1) {
            if (event != 2 || !elementName.equals(parser.getName())) continue;
            return true;
        }
        return false;
    }

    public static void setTextContent(XMLElement element, StringItem stringItem) {
        if (stringItem == null) {
            element.clearChildNodes();
            return;
        }
        if (!stringItem.hasStyle()) {
            element.setTextContent(stringItem.get());
        } else {
            element.setSpannableText(stringItem.getXml());
        }
    }

    public static String toXMLTagName(String typeName) {
        if (typeName.length() > 0 && typeName.charAt(0) == '^') {
            typeName = typeName.substring(1);
        }
        return typeName;
    }

    public static void closeSilent(Object obj) {
        if (!(obj instanceof Closeable)) {
            return;
        }
        Closeable closeable = (Closeable)obj;
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setIndent(XmlSerializer serializer, boolean state) {
        XmlHelper.setFeatureSafe(serializer, FEATURE_INDENT, state);
    }

    public static void setFeatureSafe(XmlSerializer serializer, String name, boolean state) {
        try {
            serializer.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

