/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.CrcOutputStream;
import com.reandroid.apk.JsonStringPoolBuilder;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SingleJsonTableInputSource
extends InputSource {
    private final InputSource inputSource;
    private TableBlock mCache;
    private APKLogger apkLogger;

    public SingleJsonTableInputSource(InputSource inputSource) {
        super("resources.arsc");
        this.inputSource = inputSource;
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getTableBlock().writeBytes(outputStream);
    }

    @Override
    public InputStream openStream() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return new ByteArrayInputStream(tableBlock.getBytes());
    }

    @Override
    public long getLength() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return tableBlock.countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        CrcOutputStream outputStream = new CrcOutputStream();
        this.write(outputStream);
        return outputStream.getCrcValue();
    }

    public TableBlock getTableBlock() throws IOException {
        if (this.mCache != null) {
            return this.mCache;
        }
        this.logMessage("Building resources table: " + this.inputSource.getAlias());
        TableBlock tableBlock = this.newInstance();
        InputStream inputStream = this.inputSource.openStream();
        try {
            JsonStringPoolBuilder poolBuilder = new JsonStringPoolBuilder();
            JSONObject jsonObject = new JSONObject(inputStream);
            poolBuilder.build(jsonObject);
            poolBuilder.apply(tableBlock);
            tableBlock.fromJson(jsonObject);
        }
        catch (JSONException ex) {
            throw new IOException(this.inputSource.getAlias(), ex);
        }
        this.mCache = tableBlock;
        return tableBlock;
    }

    TableBlock newInstance() {
        return new TableBlock();
    }

    public static SingleJsonTableInputSource fromFile(File rootDir, File jsonFile) {
        String path = ApkUtil.jsonToArchiveResourcePath(rootDir, jsonFile);
        FileInputSource fileInputSource = new FileInputSource(jsonFile, path);
        return new SingleJsonTableInputSource(fileInputSource);
    }

    void setApkLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    private void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

