/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.FileMagic;
import com.reandroid.apk.JsonXmlInputSource;
import com.reandroid.apk.xmlencoder.XMLEncodeSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.TableEntry;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ResFile {
    private final List<Entry> entryList;
    private final InputSource inputSource;
    private boolean mBinXml;
    private boolean mBinXmlChecked;
    private String mFileExtension;
    private boolean mFileExtensionChecked;
    private Entry mSelectedEntry;

    public ResFile(InputSource inputSource, List<Entry> entryList) {
        this.inputSource = inputSource;
        this.entryList = entryList;
    }

    public List<Entry> getEntryList() {
        return this.entryList;
    }

    public String validateTypeDirectoryName() {
        Entry entry = this.pickOne();
        if (entry == null) {
            return null;
        }
        String path = this.getFilePath();
        String root = "";
        int i = path.indexOf(47);
        if (i > 0) {
            root = path.substring(0, ++i);
            path = path.substring(i);
        }
        String name = path;
        i = path.lastIndexOf(47);
        if (i > 0) {
            name = path.substring(++i);
        }
        TypeBlock typeBlock = entry.getTypeBlock();
        String typeName = typeBlock.getTypeName() + typeBlock.getResConfig().getQualifiers();
        return root + typeName + "/" + name;
    }

    public Entry pickOne() {
        if (this.mSelectedEntry == null) {
            this.mSelectedEntry = this.selectOne();
        }
        return this.mSelectedEntry;
    }

    private Entry selectOne() {
        List<Entry> entryList = this.entryList;
        if (entryList.size() == 0) {
            return null;
        }
        for (Entry entry : entryList) {
            if (entry.isNull() || !entry.isDefault()) continue;
            return entry;
        }
        for (Entry entry : entryList) {
            if (entry.isNull()) continue;
            return entry;
        }
        for (Entry entry : entryList) {
            if (!entry.isDefault()) continue;
            return entry;
        }
        return entryList.get(0);
    }

    public String getFilePath() {
        return this.getInputSource().getAlias();
    }

    public void setFilePath(String filePath) {
        this.getInputSource().setAlias(filePath);
        for (Entry entry : this.entryList) {
            TableEntry<?, ?> tableEntry = entry.getTableEntry();
            if (!(tableEntry instanceof ResTableEntry)) continue;
            ResValue resValue = (ResValue)((ResTableEntry)tableEntry).getValue();
            resValue.setValueAsString(filePath);
        }
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public boolean isBinaryXml() {
        if (this.mBinXmlChecked) {
            return this.mBinXml;
        }
        this.mBinXmlChecked = true;
        InputSource inputSource = this.getInputSource();
        if (inputSource instanceof XMLEncodeSource || inputSource instanceof JsonXmlInputSource) {
            this.mBinXml = true;
        } else {
            try {
                this.mBinXml = ResXmlDocument.isResXmlBlock(inputSource.getBytes(8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.mBinXml;
    }

    public File buildOutFile(File dir) {
        String path = this.getFilePath();
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    public String buildPath() {
        return this.buildPath(null);
    }

    public String buildPath(String parent) {
        Entry entry = this.pickOne();
        StringBuilder builder = new StringBuilder();
        if (parent != null) {
            builder.append(parent);
            if (!parent.endsWith("/")) {
                builder.append('/');
            }
        }
        TypeBlock typeBlock = entry.getTypeBlock();
        builder.append(typeBlock.getTypeName());
        builder.append(typeBlock.getQualifiers());
        builder.append('/');
        builder.append(entry.getName());
        String ext = this.getFileExtension();
        if (ext != null) {
            builder.append(ext);
        }
        return builder.toString();
    }

    private String getFileExtension() {
        if (!this.mFileExtensionChecked) {
            this.mFileExtensionChecked = true;
            this.mFileExtension = this.readFileExtension();
        }
        return this.mFileExtension;
    }

    private String readFileExtension() {
        if (this.isBinaryXml()) {
            return ".xml";
        }
        String path = this.getFilePath();
        int i = path.lastIndexOf(46);
        if (i > 0) {
            return path.substring(i);
        }
        try {
            String magicExt = FileMagic.getExtensionFromMagic(this.getInputSource());
            if (magicExt != null) {
                return magicExt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return this.getFilePath();
    }
}

