/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.identifiers.Identifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PathSanitizer {
    private final Collection<? extends InputSource> sourceList;
    private final boolean sanitizeResourceFiles;
    private Collection<ResFile> resFileList;
    private APKLogger apkLogger;
    private final Set<String> mSanitizedPaths;
    private boolean mCaseInsensitive;
    private int mUniqueName;
    private static final int MAX_NAME_LENGTH = 75;
    private static final int MAX_PATH_LENGTH = 100;

    public PathSanitizer(Collection<? extends InputSource> sourceList, boolean sanitizeResourceFiles) {
        this.sourceList = sourceList;
        this.mSanitizedPaths = new HashSet<String>();
        this.sanitizeResourceFiles = sanitizeResourceFiles;
        this.mCaseInsensitive = Identifier.CASE_INSENSITIVE_FS;
    }

    public PathSanitizer(Collection<? extends InputSource> sourceList) {
        this(sourceList, false);
    }

    public void sanitize() {
        this.mSanitizedPaths.clear();
        this.logMessage("Sanitizing paths ...");
        this.sanitizeCaseInsensitiveOs();
        this.sanitizeResFiles();
        for (InputSource inputSource : this.sourceList) {
            this.sanitize(inputSource, 1, false);
        }
    }

    public void setResourceFileList(Collection<ResFile> resFileList) {
        this.resFileList = resFileList;
    }

    public boolean isCaseInsensitive() {
        return this.mCaseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.mCaseInsensitive = caseInsensitive;
    }

    private void sanitizeCaseInsensitiveOs() {
        if (!Identifier.CASE_INSENSITIVE_FS) {
            return;
        }
        this.logMessage("[WIN/MAC] Checking duplicate case insensitive paths ...");
        this.mUniqueName = 0;
        HashMap<String, InputSource> uniqueMap = new HashMap<String, InputSource>();
        for (InputSource inputSource : this.sourceList) {
            String path = inputSource.getAlias().toLowerCase();
            InputSource exist = (InputSource)uniqueMap.get(path);
            if (exist == null) {
                uniqueMap.put(path, inputSource);
                continue;
            }
            this.sanitizeCaseInsensitiveOs(inputSource);
            this.sanitizeCaseInsensitiveOs(exist);
            uniqueMap.remove(path);
        }
    }

    private void sanitizeCaseInsensitiveOs(InputSource inputSource) {
        String path = inputSource.getAlias();
        ++this.mUniqueName;
        String uniqueName = PathSanitizer.createUniqueName(this.mUniqueName + path);
        int i = path.lastIndexOf(47);
        String alias = i > 0 ? path.substring(0, i) + "/" + uniqueName : uniqueName;
        inputSource.setAlias(alias);
        String msg = "'" + path + "' -> '" + alias + "'";
        if (this.mUniqueName < 10) {
            this.logMessage("Case sensitive path renamed: " + msg);
        } else {
            this.logVerbose(msg);
        }
    }

    private void sanitizeResFiles() {
        Collection<ResFile> resFileList = this.resFileList;
        if (resFileList == null) {
            return;
        }
        boolean sanitizeRes = this.sanitizeResourceFiles;
        Set<String> sanitizedPaths = this.mSanitizedPaths;
        if (sanitizeRes) {
            this.logMessage("Sanitizing resource files ...");
        }
        for (ResFile resFile : resFileList) {
            if (sanitizeRes) {
                this.sanitize(resFile);
                continue;
            }
            sanitizedPaths.add(resFile.getFilePath());
        }
    }

    private void sanitize(ResFile resFile) {
        InputSource inputSource = resFile.getInputSource();
        String replace = this.sanitize(inputSource, 3, true);
        if (replace == null) {
            return;
        }
        resFile.setFilePath(replace);
    }

    private String sanitize(InputSource inputSource, int depth, boolean fixedDepth) {
        String name = inputSource.getName();
        if (this.mSanitizedPaths.contains(name)) {
            return null;
        }
        this.mSanitizedPaths.add(name);
        String alias = inputSource.getAlias();
        if (this.shouldIgnore(alias)) {
            return null;
        }
        String replace = this.sanitize(alias, depth, fixedDepth);
        if (alias.equals(replace)) {
            return null;
        }
        inputSource.setAlias(replace);
        if (alias.length() > 20) {
            alias = ".. " + alias.substring(alias.length() - 20);
        }
        this.logVerbose("'" + alias + "' -> '" + replace + "'");
        return replace;
    }

    private String sanitize(String name, int depth, boolean fixedDepth) {
        StringBuilder builder = new StringBuilder();
        String[] nameSplit = name.split("/");
        boolean pathIsLong = name.length() >= 100;
        int length = nameSplit.length;
        for (int i = 0; i < length; ++i) {
            String split = nameSplit[i];
            boolean good = PathSanitizer.isGoodSimpleName(split);
            if (!good || pathIsLong && i >= depth) {
                split = PathSanitizer.createUniqueName(name);
                PathSanitizer.appendPathName(builder, split);
                break;
            }
            if (fixedDepth && i >= depth - 1) {
                if (i < length - 1) {
                    split = PathSanitizer.createUniqueName(name);
                }
                PathSanitizer.appendPathName(builder, split);
                break;
            }
            PathSanitizer.appendPathName(builder, split);
        }
        return builder.toString();
    }

    private boolean shouldIgnore(String path) {
        return path.startsWith("lib/") && path.endsWith(".so");
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private String getLogTag() {
        return "[SANITIZE]: ";
    }

    void logMessage(String msg) {
        APKLogger logger = this.apkLogger;
        if (logger != null) {
            logger.logMessage(this.getLogTag() + msg);
        }
    }

    void logVerbose(String msg) {
        APKLogger logger = this.apkLogger;
        if (logger != null) {
            logger.logVerbose(this.getLogTag() + msg);
        }
    }

    private static void appendPathName(StringBuilder builder, String name) {
        if (builder.length() > 0) {
            builder.append('/');
        }
        builder.append(name);
    }

    private static String createUniqueName(String name) {
        int hash = name.hashCode();
        return "alias_" + HexUtil.toHexNoPrefix8(hash);
    }

    private static boolean isGoodSimpleName(String name) {
        if (name == null) {
            return false;
        }
        String alias = PathSanitizer.sanitizeSimpleName(name);
        return name.equals(alias);
    }

    public static String sanitizeSimpleName(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = name.toCharArray();
        boolean skipNext = true;
        int length = 0;
        int lengthMax = 75;
        for (int i = 0; i < chars.length && length < lengthMax; ++i) {
            char ch = chars[i];
            if (PathSanitizer.isGoodFileNameSymbol(ch)) {
                if (!skipNext) {
                    builder.append(ch);
                    ++length;
                }
                skipNext = true;
                continue;
            }
            if (!PathSanitizer.isGoodFileNameChar(ch)) {
                skipNext = true;
                continue;
            }
            builder.append(ch);
            ++length;
            skipNext = false;
        }
        if (length == 0) {
            return null;
        }
        return builder.toString();
    }

    private static boolean isGoodFileNameSymbol(char ch) {
        return ch == '.' || ch == '+' || ch == '-' || ch == '#';
    }

    private static boolean isGoodFileNameChar(char ch) {
        return ch == '_' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static PathSanitizer create(ApkModule apkModule) {
        PathSanitizer pathSanitizer = new PathSanitizer(apkModule.getApkArchive().listInputSources());
        pathSanitizer.setApkLogger(apkModule.getApkLogger());
        pathSanitizer.setResourceFileList(apkModule.listResFiles());
        return pathSanitizer;
    }
}

