/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipArchive;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathMap
implements JSONConvert<JSONArray> {
    private final Object mLock = new Object();
    private final Map<String, String> mNameAliasMap = new HashMap<String, String>();
    private final Map<String, String> mAliasNameMap = new HashMap<String, String>();
    public static final String NAME_name = "name";
    public static final String NAME_alias = "alias";
    public static final String JSON_FILE = "path-map.json";

    public void restore(ApkModule apkModule) {
        this.restoreResFile(apkModule.listResFiles());
        this.restore(apkModule.getApkArchive().listInputSources());
    }

    public List<String> restoreResFile(Collection<ResFile> files) {
        ArrayList<String> results = new ArrayList<String>();
        if (files == null) {
            return results;
        }
        for (ResFile resFile : files) {
            String alias = this.restoreResFile(resFile);
            if (alias == null) continue;
            results.add(alias);
        }
        return results;
    }

    public String restoreResFile(ResFile resFile) {
        InputSource inputSource = resFile.getInputSource();
        String alias = this.restore(inputSource);
        if (alias == null) {
            return null;
        }
        resFile.setFilePath(alias);
        return alias;
    }

    public List<String> restore(Collection<InputSource> sources) {
        ArrayList<String> results = new ArrayList<String>();
        if (sources == null) {
            return results;
        }
        for (InputSource inputSource : sources) {
            String alias = this.restore(inputSource);
            if (alias == null) continue;
            results.add(alias);
        }
        return results;
    }

    public String restore(InputSource inputSource) {
        if (inputSource == null) {
            return null;
        }
        String name = inputSource.getName();
        String alias = this.getName(name);
        if (alias == null) {
            name = inputSource.getAlias();
            alias = this.getName(name);
        }
        if (alias == null || alias.equals(inputSource.getAlias())) {
            return null;
        }
        inputSource.setAlias(alias);
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlias(String name) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNameAliasMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(String alias) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAliasNameMap.get(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNameAliasMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNameAliasMap.clear();
            this.mAliasNameMap.clear();
        }
    }

    public void add(ZipArchive archive) {
        if (archive == null) {
            return;
        }
        this.add(archive.listInputSources());
    }

    public void add(Collection<? extends InputSource> sources) {
        if (sources == null) {
            return;
        }
        for (InputSource inputSource : sources) {
            this.add(inputSource);
        }
    }

    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        this.add(inputSource.getName(), inputSource.getAlias());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String alias) {
        if (name == null || alias == null) {
            return;
        }
        if (name.equals(alias)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mNameAliasMap.remove(name);
            this.mNameAliasMap.put(name, alias);
            this.mAliasNameMap.remove(alias);
            this.mAliasNameMap.put(alias, name);
        }
    }

    private void add(JSONObject json) {
        if (json == null) {
            return;
        }
        this.add(json.optString(NAME_name), json.optString(NAME_alias));
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        Map<String, String> nameMap = this.mNameAliasMap;
        List<String> nameList = PathMap.toSortedList(nameMap.keySet());
        for (String name : nameList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(NAME_name, name);
            jsonObject.put(NAME_alias, nameMap.get(name));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json == null) {
            return;
        }
        int length = json.length();
        for (int i = 0; i < length; ++i) {
            this.add(json.optJSONObject(i));
        }
    }

    public String toString() {
        return "PathMap size=" + this.size();
    }

    private static List<String> toSortedList(Collection<String> stringCollection) {
        ArrayList<String> results = stringCollection instanceof List ? (ArrayList<String>)stringCollection : new ArrayList<String>(stringCollection);
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        results.sort(cmp);
        return results;
    }
}

