/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.APKArchive;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.value.CompoundEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FrameworkOptimizer {
    private final ApkModule frameworkApk;
    private APKLogger apkLogger;
    private boolean mOptimizing;

    public FrameworkOptimizer(ApkModule frameworkApk) {
        this.frameworkApk = frameworkApk;
        this.apkLogger = frameworkApk.getApkLogger();
    }

    public void optimize() {
        if (this.mOptimizing) {
            return;
        }
        this.mOptimizing = true;
        if (!this.frameworkApk.hasTableBlock()) {
            this.logMessage("Don't have: resources.arsc");
            this.mOptimizing = false;
            return;
        }
        FrameworkTable frameworkTable = this.getFrameworkTable();
        AndroidManifestBlock manifestBlock = null;
        if (this.frameworkApk.hasAndroidManifestBlock()) {
            manifestBlock = this.frameworkApk.getAndroidManifestBlock();
        }
        this.optimizeTable(frameworkTable, manifestBlock);
        UncompressedFiles uncompressedFiles = this.frameworkApk.getUncompressedFiles();
        uncompressedFiles.clearExtensions();
        uncompressedFiles.clearPaths();
        this.clearFiles(this.frameworkApk.getApkArchive());
        this.logMessage("Optimized");
    }

    private void clearFiles(APKArchive archive) {
        int count = archive.entriesCount();
        if (count == 2) {
            return;
        }
        this.logMessage("Removing files from: " + count);
        InputSource tableSource = archive.getInputSource("resources.arsc");
        InputSource manifestSource = archive.getInputSource("AndroidManifest.xml");
        archive.clear();
        if (tableSource != null) {
            tableSource.setMethod(8);
        }
        if (manifestSource != null) {
            manifestSource.setMethod(8);
        }
        archive.add(tableSource);
        archive.add(manifestSource);
        this.logMessage("Removed files: " + (count -= archive.entriesCount()));
    }

    private void optimizeTable(FrameworkTable table, AndroidManifestBlock manifestBlock) {
        if (table.isOptimized()) {
            return;
        }
        this.logMessage("Optimizing ...");
        int prev = table.countBytes();
        int version = 0;
        String name = "framework";
        if (manifestBlock != null) {
            Integer code = manifestBlock.getVersionCode();
            if (code != null) {
                version = code;
            }
            name = manifestBlock.getPackageName();
            this.compressManifest(manifestBlock);
            this.backupManifestValue(manifestBlock, table);
        }
        this.logMessage("Optimizing table ...");
        table.optimize(name, version);
        long diff = prev - table.countBytes();
        long percent = diff * 100L / (long)prev;
        this.logMessage("Table size reduced by: " + percent + " %");
        this.mOptimizing = false;
    }

    private FrameworkTable getFrameworkTable() {
        TableBlock tableBlock = this.frameworkApk.getTableBlock();
        if (tableBlock instanceof FrameworkTable) {
            return (FrameworkTable)tableBlock;
        }
        FrameworkTable frameworkTable = this.toFramework(tableBlock);
        this.frameworkApk.setTableBlock(frameworkTable);
        return frameworkTable;
    }

    private FrameworkTable toFramework(TableBlock tableBlock) {
        this.logMessage("Converting to framework ...");
        BlockReader reader = new BlockReader(tableBlock.getBytes());
        FrameworkTable frameworkTable = new FrameworkTable();
        try {
            frameworkTable.readBytes(reader);
        }
        catch (IOException exception) {
            this.logError("Error re-loading framework: ", exception);
        }
        return frameworkTable;
    }

    private void compressManifest(AndroidManifestBlock manifestBlock) {
        this.logMessage("Compressing manifest ...");
        int prev = manifestBlock.countBytes();
        ResXmlElement manifest = manifestBlock.getResXmlElement();
        List<ResXmlNode> removeList = this.getManifestElementToRemove(manifest);
        for (ResXmlNode resXmlNode : removeList) {
            manifest.removeNode(resXmlNode);
        }
        ResXmlElement application = manifestBlock.getApplicationElement();
        if (application != null) {
            removeList = application.listXmlNodes();
            for (ResXmlNode node : removeList) {
                application.removeNode(node);
            }
        }
        ResXmlStringPool resXmlStringPool = manifestBlock.getStringPool();
        resXmlStringPool.removeUnusedStrings();
        manifestBlock.refresh();
        long diff = prev - manifestBlock.countBytes();
        long percent = diff * 100L / (long)prev;
        this.logMessage("Manifest size reduced by: " + percent + " %");
    }

    private List<ResXmlNode> getManifestElementToRemove(ResXmlElement manifest) {
        ArrayList<ResXmlNode> results = new ArrayList<ResXmlNode>();
        for (ResXmlNode node : manifest.listXmlNodes()) {
            ResXmlElement element;
            if (!(node instanceof ResXmlElement) || "application".equals((element = (ResXmlElement)node).getTag())) continue;
            results.add(element);
        }
        return results;
    }

    private void backupManifestValue(AndroidManifestBlock manifestBlock, TableBlock tableBlock) {
        ResXmlAttribute attribute;
        this.logMessage("Backup manifest values ...");
        ResXmlElement application = manifestBlock.getApplicationElement();
        ResXmlAttribute iconAttribute = null;
        int iconReference = 0;
        if (application != null && (attribute = application.searchAttributeByResourceId(0x1010002)) != null && attribute.getValueType() == ValueType.REFERENCE) {
            iconAttribute = attribute;
            iconReference = attribute.getData();
        }
        ResXmlElement element = manifestBlock.getResXmlElement();
        this.backupAttributeValues(tableBlock, element);
        if (iconAttribute != null) {
            iconAttribute.setTypeAndData(ValueType.REFERENCE, iconReference);
        }
    }

    private void backupAttributeValues(TableBlock tableBlock, ResXmlElement element) {
        if (element == null) {
            return;
        }
        for (ResXmlAttribute attribute : element.listAttributes()) {
            this.backupAttributeValues(tableBlock, attribute);
        }
        for (ResXmlElement child : element.listElements()) {
            this.backupAttributeValues(tableBlock, child);
        }
    }

    private void backupAttributeValues(TableBlock tableBlock, ResXmlAttribute attribute) {
        if (attribute == null) {
            return;
        }
        ValueType valueType = attribute.getValueType();
        if (valueType != ValueType.REFERENCE && valueType != ValueType.ATTRIBUTE) {
            return;
        }
        int reference = attribute.getData();
        Entry entry = this.getEntryWithValue(tableBlock, reference);
        if (entry == null || this.isReferenceEntry(entry) || entry.isComplex()) {
            return;
        }
        ResTableEntry resTableEntry = (ResTableEntry)entry.getTableEntry();
        ResValue resValue = (ResValue)resTableEntry.getValue();
        valueType = resValue.getValueType();
        if (valueType == ValueType.STRING) {
            String value = resValue.getValueAsString();
            attribute.setValueAsString(value);
        } else {
            int data = resValue.getData();
            attribute.setTypeAndData(valueType, data);
        }
    }

    private Entry getEntryWithValue(TableBlock tableBlock, int resourceId) {
        HashSet<Integer> circularReference = new HashSet<Integer>();
        return this.getEntryWithValue(tableBlock, resourceId, circularReference);
    }

    private Entry getEntryWithValue(TableBlock tableBlock, int resourceId, Set<Integer> circularReference) {
        if (circularReference.contains(resourceId)) {
            return null;
        }
        circularReference.add(resourceId);
        EntryGroup entryGroup = tableBlock.getEntryGroup(resourceId);
        Entry entry = entryGroup.pickOne();
        if (entry == null) {
            return null;
        }
        if (this.isReferenceEntry(entry)) {
            return this.getEntryWithValue(tableBlock, ((ResValue)entry.getTableEntry().getValue()).getData(), circularReference);
        }
        if (!entry.isNull()) {
            return entry;
        }
        Iterator itr = entryGroup.iterator(true);
        while (itr.hasNext()) {
            entry = (Entry)itr.next();
            if (this.isReferenceEntry(entry) || entry.isNull()) continue;
            return entry;
        }
        return null;
    }

    private boolean isReferenceEntry(Entry entry) {
        if (entry == null || entry.isNull()) {
            return false;
        }
        TableEntry<?, ?> tableEntry = entry.getTableEntry();
        if (tableEntry instanceof CompoundEntry) {
            return false;
        }
        if (!(tableEntry instanceof ResTableEntry)) {
            return false;
        }
        ResTableEntry resTableEntry = (ResTableEntry)tableEntry;
        ResValue resValue = (ResValue)resTableEntry.getValue();
        ValueType valueType = resValue.getValueType();
        return valueType == ValueType.REFERENCE || valueType == ValueType.ATTRIBUTE;
    }

    APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

