/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.BlockInputSource;
import com.reandroid.apk.FrameworkOptimizer;
import com.reandroid.archive.APKArchive;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.InputSourceUtil;
import com.reandroid.archive2.Archive;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.value.ValueType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public class FrameworkApk
extends ApkModule {
    private final Object mLock = new Object();
    private int versionCode;
    private String versionName;
    private String packageName;
    private boolean mOptimizing;
    private boolean mDestroyed;

    public FrameworkApk(String moduleName, APKArchive apkArchive) {
        super(moduleName, apkArchive);
        super.setLoadDefaultFramework(false);
    }

    public FrameworkApk(APKArchive apkArchive) {
        this("framework", apkArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.versionCode = -1;
            this.versionName = "-1";
            this.packageName = "destroyed";
            super.destroy();
            this.mDestroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDestroyed) {
                return false;
            }
            if (this.hasTableBlock()) {
                this.versionCode = 0;
                this.versionName = null;
                this.packageName = null;
                this.mDestroyed = false;
                return false;
            }
            return true;
        }
    }

    public int getVersionCode() {
        if (this.versionCode == 0) {
            this.initValues();
        }
        return this.versionCode;
    }

    public String getVersionName() {
        if (this.versionName == null) {
            this.initValues();
        }
        return this.versionName;
    }

    @Override
    public String getPackageName() {
        if (this.packageName == null) {
            this.initValues();
        }
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        super.setPackageName(packageName);
        this.packageName = null;
    }

    private void initValues() {
        if (this.hasAndroidManifestBlock()) {
            AndroidManifestBlock manifest = this.getAndroidManifestBlock();
            Integer code = manifest.getVersionCode();
            if (code != null) {
                this.versionCode = code;
            }
            if (this.versionName == null) {
                this.versionName = manifest.getVersionName();
            }
            if (this.packageName == null) {
                this.packageName = manifest.getPackageName();
            }
        }
        if (this.hasTableBlock()) {
            PackageBlock packageBlock;
            int version;
            FrameworkTable table = this.getTableBlock();
            if (table.isOptimized() && this.versionCode == 0 && (version = table.getVersionCode()) != 0) {
                this.versionCode = version;
                if (this.versionName == null) {
                    this.versionName = String.valueOf(version);
                }
            }
            if (this.packageName == null && (packageBlock = table.pickOne()) != null) {
                this.packageName = packageBlock.getName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManifest(AndroidManifestBlock manifestBlock) {
        Object object = this.mLock;
        synchronized (object) {
            super.setManifest(manifestBlock);
            this.versionCode = 0;
            this.versionName = null;
            this.packageName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableBlock(TableBlock tableBlock) {
        Object object = this.mLock;
        synchronized (object) {
            super.setTableBlock(tableBlock);
            this.versionCode = 0;
            this.versionName = null;
            this.packageName = null;
        }
    }

    @Override
    public FrameworkTable getTableBlock() {
        return (FrameworkTable)super.getTableBlock();
    }

    @Override
    FrameworkTable loadTableBlock() throws IOException {
        APKArchive archive = this.getApkArchive();
        InputSource inputSource = archive.getInputSource("resources.arsc");
        if (inputSource == null) {
            throw new IOException("Entry not found: resources.arsc");
        }
        InputStream inputStream = inputSource.openStream();
        FrameworkTable frameworkTable = FrameworkTable.load(inputStream);
        frameworkTable.setApkFile(this);
        BlockInputSource<FrameworkTable> blockInputSource = new BlockInputSource<FrameworkTable>(inputSource.getName(), frameworkTable);
        blockInputSource.setMethod(inputSource.getMethod());
        blockInputSource.setSort(inputSource.getSort());
        archive.add(blockInputSource);
        return frameworkTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOptimizing) {
                return;
            }
            if (!this.hasTableBlock()) {
                this.mOptimizing = false;
                return;
            }
            FrameworkTable frameworkTable = this.getTableBlock();
            if (frameworkTable.isOptimized()) {
                this.mOptimizing = false;
                this.initValues();
                return;
            }
            FrameworkOptimizer optimizer = new FrameworkOptimizer(this);
            optimizer.optimize();
            this.mOptimizing = false;
            this.initValues();
        }
    }

    public String getName() {
        if (this.isDestroyed()) {
            return "destroyed";
        }
        String pkg = this.getPackageName();
        if (pkg == null) {
            return "";
        }
        return pkg + "-" + this.getVersionCode();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameworkApk other = (FrameworkApk)obj;
        return this.getName().equals(other.getName());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static FrameworkApk loadApkFile(File apkFile) throws IOException {
        Archive archive = new Archive(apkFile);
        APKArchive apkArchive = new APKArchive(archive.mapEntrySource());
        FrameworkApk frameworkApk = new FrameworkApk(apkArchive);
        frameworkApk.setCloseable(archive);
        return frameworkApk;
    }

    public static FrameworkApk loadApkFile(File apkFile, String moduleName) throws IOException {
        Archive archive = new Archive(apkFile);
        APKArchive apkArchive = new APKArchive(archive.mapEntrySource());
        FrameworkApk frameworkApk = new FrameworkApk(moduleName, apkArchive);
        frameworkApk.setCloseable(archive);
        return frameworkApk;
    }

    public static boolean isFramework(ApkModule apkModule) {
        if (!apkModule.hasAndroidManifestBlock()) {
            return false;
        }
        return FrameworkApk.isFramework(apkModule.getAndroidManifestBlock());
    }

    public static boolean isFramework(AndroidManifestBlock manifestBlock) {
        ResXmlElement root = manifestBlock.getManifestElement();
        ResXmlAttribute attribute = root.getStartElement().searchAttributeByName("coreApp");
        if (attribute == null || attribute.getValueType() != ValueType.BOOLEAN) {
            return false;
        }
        return attribute.getValueAsBoolean();
    }

    public static FrameworkApk loadApkBuffer(InputStream inputStream) throws IOException {
        return FrameworkApk.loadApkBuffer("framework", inputStream);
    }

    public static FrameworkApk loadApkBuffer(String moduleName, InputStream inputStream) throws IOException {
        APKArchive archive = new APKArchive();
        FrameworkApk frameworkApk = new FrameworkApk(moduleName, archive);
        Map<String, ByteInputSource> inputSourceMap = InputSourceUtil.mapInputStreamAsBuffer(inputStream);
        ByteInputSource source = inputSourceMap.get("resources.arsc");
        FrameworkTable tableBlock = new FrameworkTable();
        if (source != null) {
            tableBlock.readBytes(source.openStream());
        }
        frameworkApk.setTableBlock(tableBlock);
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        source = inputSourceMap.get("AndroidManifest.xml");
        if (source != null) {
            manifestBlock.readBytes(source.openStream());
        }
        frameworkApk.setManifest(manifestBlock);
        archive.addAll(inputSourceMap.values());
        frameworkApk.initValues();
        return frameworkApk;
    }

    public static void optimize(File in, File out, APKLogger apkLogger) throws IOException {
        FrameworkApk frameworkApk = FrameworkApk.loadApkFile(in);
        frameworkApk.setAPKLogger(apkLogger);
        frameworkApk.optimize();
        frameworkApk.writeApk(out);
    }
}

