/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.archive.InputSource;
import java.io.IOException;
import java.io.InputStream;

public class FileMagic {
    private static final int MAGIC_MAX_LENGTH = 16;
    private static final byte[] MAGIC_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MAGIC_JPG = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70};
    private static final byte[] MAGIC_WEBP = new byte[]{82, 73, 70, 70, -1, -1, -1, 0, 87, 69, 66, 80, 86, 80, 56};
    private static final byte[] MAGIC_TTF = new byte[]{0, 1, 0, 0, 0, -1, -1, -1};

    public static String getExtensionFromMagic(InputSource inputSource) throws IOException {
        byte[] magic = FileMagic.readFileMagic(inputSource);
        if (magic == null) {
            return null;
        }
        if (FileMagic.isPng(magic)) {
            return ".png";
        }
        if (FileMagic.isJpeg(magic)) {
            return ".jpg";
        }
        if (FileMagic.isWebp(magic)) {
            return ".webp";
        }
        if (FileMagic.isTtf(magic)) {
            return ".ttf";
        }
        return null;
    }

    private static boolean isJpeg(byte[] magic) {
        return FileMagic.compareMagic(MAGIC_JPG, magic);
    }

    private static boolean isPng(byte[] magic) {
        return FileMagic.compareMagic(MAGIC_PNG, magic);
    }

    private static boolean isWebp(byte[] magic) {
        return FileMagic.compareMagic(MAGIC_WEBP, magic);
    }

    private static boolean isTtf(byte[] magic) {
        return FileMagic.compareMagic(MAGIC_TTF, magic);
    }

    private static boolean compareMagic(byte[] magic, byte[] readMagic) {
        if (magic == null || readMagic == null) {
            return false;
        }
        int max = magic.length;
        if (max > readMagic.length) {
            max = readMagic.length;
        }
        if (max == 0) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            byte m = magic[i];
            if (m == -1 || m == readMagic[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] readFileMagic(InputSource inputSource) throws IOException {
        InputStream inputStream = inputSource.openStream();
        byte[] magic = new byte[16];
        int count = inputStream.read(magic, 0, magic.length);
        inputStream.close();
        if (count < magic.length) {
            return null;
        }
        return magic;
    }
}

