/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.apk.DexEncoder;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DexFileRawEncoder
implements DexEncoder {
    private APKLogger apkLogger;

    @Override
    public List<InputSource> buildDexFiles(ApkModuleEncoder encoder, File mainDirectory) throws IOException {
        File dexDir = new File(mainDirectory, "dex");
        List<File> dexFileList = DexFileInputSource.listDexFiles(dexDir);
        ArrayList<InputSource> results = new ArrayList<InputSource>(dexFileList.size());
        if (dexFileList.size() == 0) {
            this.logMessage("WARN: No dex files found on: " + dexDir);
            return results;
        }
        for (File file : dexFileList) {
            String name = file.getName();
            FileInputSource fileInputSource = new FileInputSource(file, name);
            fileInputSource.setMethod(0);
            DexFileInputSource inputSource = new DexFileInputSource(name, fileInputSource);
            inputSource.setMethod(0);
            results.add(inputSource);
            this.logVerbose(name);
        }
        return results;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    APKLogger getApkLogger() {
        return this.apkLogger;
    }

    void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    void logError(String msg, Throwable tr) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger == null || msg == null && tr == null) {
            return;
        }
        apkLogger.logError(msg, tr);
    }

    void logVerbose(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logVerbose(msg);
        }
    }
}

