/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.RenamedInputSource;
import com.reandroid.archive.InputSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DexFileInputSource
extends RenamedInputSource<InputSource>
implements Comparable<DexFileInputSource> {
    public static final String DEX_DIRECTORY_NAME = "dex";

    public DexFileInputSource(String name, InputSource inputSource) {
        super(name, inputSource);
    }

    public int getDexNumber() {
        return DexFileInputSource.getDexNumber(this.getAlias());
    }

    @Override
    public int compareTo(DexFileInputSource source) {
        return Integer.compare(this.getDexNumber(), source.getDexNumber());
    }

    public static void sort(List<DexFileInputSource> sourceList) {
        sourceList.sort(new Comparator<DexFileInputSource>(){

            @Override
            public int compare(DexFileInputSource s1, DexFileInputSource s2) {
                return s1.compareTo(s2);
            }
        });
    }

    public static void sortDexFiles(List<File> fileList) {
        fileList.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                int i2;
                int i1 = DexFileInputSource.getDexNumber(file1.getName());
                if (i1 == (i2 = DexFileInputSource.getDexNumber(file2.getName()))) {
                    return 0;
                }
                if (i1 < 0 || i1 < i2) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static List<File> listDexFiles(File dir) {
        ArrayList<File> results = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return results;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isFile() || !DexFileInputSource.isDexName(file.getName())) continue;
            results.add(file);
        }
        DexFileInputSource.sortDexFiles(results);
        return results;
    }

    public static boolean isDexName(String name) {
        return DexFileInputSource.getDexNumber(name) >= 0;
    }

    static String getDexName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return "classes" + i + ".dex";
    }

    static int getDexNumber(String name) {
        if (name.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        String ext = ".dex";
        if (!name.startsWith(prefix) || !name.endsWith(ext)) {
            return -1;
        }
        String num = name.substring(prefix.length(), name.length() - ext.length());
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

