/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.CrcOutputStream;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.chunk.Chunk;
import java.io.IOException;
import java.io.OutputStream;

public class BlockInputSource<T extends Chunk<?>>
extends ByteInputSource {
    private final T mBlock;

    public BlockInputSource(String name, T block) {
        super(new byte[0], name);
        this.mBlock = block;
    }

    public T getBlock() {
        ((BlockContainer)this.mBlock).refresh();
        return this.mBlock;
    }

    @Override
    public long getLength() throws IOException {
        T block = this.getBlock();
        return ((Block)block).countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        T block = this.getBlock();
        CrcOutputStream outputStream = new CrcOutputStream();
        ((Block)block).writeBytes(outputStream);
        return outputStream.getCrcValue();
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return ((Block)this.getBlock()).writeBytes(outputStream);
    }

    @Override
    public byte[] getBytes() {
        return ((BlockContainer)this.getBlock()).getBytes();
    }
}

