/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.archive.InputSource;
import com.reandroid.arsc.util.StringsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApkUtil {
    public static final String JSON_FILE_EXTENSION = ".json";
    public static final String RES_JSON_NAME = "res-json";
    public static final String ROOT_NAME = "root";
    public static final String VALUES_DIRECTORY_NAME = "values";
    public static final String DEF_MODULE_NAME = "base";
    public static final String NAME_value_type = "value_type";
    public static final String NAME_data = "data";
    public static final String RES_DIR_NAME = "res";
    public static final String FILE_NAME_PUBLIC_XML = "public.xml";
    public static final String TAG_STRING_ARRAY = "string-array";
    public static final String TAG_INTEGER_ARRAY = "integer-array";
    public static final String SIGNATURE_FILE_NAME = "signatures.sig";
    public static final String SIGNATURE_DIR_NAME = "signatures";
    private static final int MAX_FILE_NAME_LENGTH = 50;

    public static String sanitizeForFileName(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = name.toCharArray();
        boolean skipNext = true;
        int length = 0;
        int lengthMax = 50;
        for (int i = 0; i < chars.length && length < lengthMax; ++i) {
            char ch = chars[i];
            if (ApkUtil.isGoodFileNameSymbol(ch)) {
                if (!skipNext) {
                    builder.append(ch);
                    ++length;
                }
                skipNext = true;
                continue;
            }
            if (!ApkUtil.isGoodFileNameChar(ch)) {
                skipNext = true;
                continue;
            }
            builder.append(ch);
            ++length;
            skipNext = false;
        }
        if (length == 0) {
            return null;
        }
        return builder.toString();
    }

    private static boolean isGoodFileNameSymbol(char ch) {
        return ch == '.' || ch == '+' || ch == '-' || ch == '_' || ch == '#';
    }

    private static boolean isGoodFileNameChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static int parseHex(String hex) {
        long l = Long.decode(hex);
        return (int)l;
    }

    public static String replaceRootDir(String path, String dirName) {
        int i = path.indexOf(47) + 1;
        path = path.substring(i);
        if (dirName != null && dirName.length() > 0) {
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            path = dirName + path;
        }
        return path;
    }

    public static String jsonToArchiveResourcePath(File dir, File jsonFile) {
        int i2;
        String tmp;
        String ext;
        String path = ApkUtil.toArchivePath(dir, jsonFile);
        if (path.endsWith(ext = JSON_FILE_EXTENSION) && (tmp = path.substring(0, i2 = path.length() - ext.length())).indexOf(46) > 0) {
            path = tmp;
        }
        return path;
    }

    public static String toArchivePath(File dir, File file) {
        String dirPath = dir.getAbsolutePath() + File.separator;
        String path = file.getAbsolutePath().substring(dirPath.length());
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    public static List<File> recursiveFiles(File dir, String ext) {
        ArrayList<File> results = new ArrayList<File>();
        if (dir.isFile()) {
            if (ApkUtil.hasExtension(dir, ext)) {
                results.add(dir);
            }
            return results;
        }
        if (!dir.isDirectory()) {
            return results;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (file.isFile()) {
                if (!ApkUtil.hasExtension(file, ext)) continue;
                results.add(file);
                continue;
            }
            results.addAll(ApkUtil.recursiveFiles(file, ext));
        }
        return results;
    }

    public static List<File> recursiveFiles(File dir) {
        return ApkUtil.recursiveFiles(dir, null);
    }

    public static List<File> listDirectories(File dir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            results.add(file);
        }
        return results;
    }

    public static List<File> listPackageDirectories(File resourcesDirectory) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = resourcesDirectory.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            if (!ApkUtil.isPackageDirectory(dir)) continue;
            results.add(dir);
        }
        StringsUtil.toStringSort(results);
        return results;
    }

    public static List<File> listPublicXmlFiles(File resourcesDirectory) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = resourcesDirectory.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            List<File> resDirList = ApkUtil.listDirectories(dir);
            for (File resDir : resDirList) {
                File file = ApkUtil.getPublicXmlFile(resDir);
                if (file == null) continue;
                results.add(file);
            }
        }
        StringsUtil.toStringSort(results);
        return results;
    }

    private static File getPublicXmlFile(File resDir) {
        if (!resDir.isDirectory()) {
            return null;
        }
        File valuesDir = new File(resDir, VALUES_DIRECTORY_NAME);
        if (!valuesDir.isDirectory()) {
            return null;
        }
        File file = new File(valuesDir, FILE_NAME_PUBLIC_XML);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static List<File> listValuesDirectory(File resDir) {
        return ApkUtil.listValuesDirectory(resDir, true);
    }

    public static List<File> listValuesDirectory(File resDir, boolean includeVariants) {
        ArrayList<File> results = new ArrayList<File>();
        if (!resDir.isDirectory()) {
            return results;
        }
        File[] files = resDir.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            if (!dir.isDirectory() || !ApkUtil.isValuesDirectoryName(dir.getName(), includeVariants)) continue;
            results.add(dir);
        }
        StringsUtil.toStringSort(results);
        return results;
    }

    public static boolean isValuesDirectoryName(String name, boolean checkVariant) {
        if (VALUES_DIRECTORY_NAME.equals(name)) {
            return true;
        }
        if (!checkVariant) {
            return false;
        }
        return name.startsWith("values-");
    }

    private static boolean isPackageDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        return new File(dir, "package.json").isFile();
    }

    public static List<File> listFiles(File dir, String ext) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isFile() || !ApkUtil.hasExtension(file, ext)) continue;
            results.add(file);
        }
        return results;
    }

    private static boolean hasExtension(File file, String ext) {
        if (ext == null) {
            return true;
        }
        String name = file.getName().toLowerCase();
        ext = ext.toLowerCase();
        return name.endsWith(ext);
    }

    public static String toModuleName(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static Map<String, InputSource> toAliasMap(Collection<InputSource> sourceList) {
        HashMap<String, InputSource> results = new HashMap<String, InputSource>();
        for (InputSource inputSource : sourceList) {
            results.put(inputSource.getAlias(), inputSource);
        }
        return results;
    }
}

