/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.XMLEncodeSource;
import com.reandroid.apk.xmlencoder.XMLTableBlockEncoder;
import com.reandroid.archive.FileInputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.value.Entry;
import com.reandroid.xml.source.XMLFileSource;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ApkModuleXmlEncoder
extends ApkModuleEncoder {
    private final XMLTableBlockEncoder tableBlockEncoder;
    private EncodeMaterials mEncodeMaterials;

    public ApkModuleXmlEncoder() {
        this.tableBlockEncoder = new XMLTableBlockEncoder();
    }

    public ApkModuleXmlEncoder(ApkModule module, TableBlock tableBlock) {
        this.tableBlockEncoder = new XMLTableBlockEncoder(module, tableBlock);
    }

    @Override
    public void buildResources(File mainDirectory) throws IOException {
        this.encodeManifestBinary(mainDirectory);
        this.buildTableBlock(mainDirectory);
        this.encodeManifestXml(mainDirectory);
        this.scanResFilesDirectory(mainDirectory);
    }

    @Override
    public ApkModule getApkModule() {
        return this.tableBlockEncoder.getApkModule();
    }

    private void buildTableBlock(File mainDirectory) throws IOException {
        XMLTableBlockEncoder tableBlockEncoder = this.tableBlockEncoder;
        tableBlockEncoder.setEncodeMaterials(this.getEncodeMaterials());
        tableBlockEncoder.scanMainDirectory(mainDirectory);
    }

    private void encodeManifestBinary(File mainDirectory) {
        File file = new File(mainDirectory, "AndroidManifest.xml.bin");
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Encode binary manifest: " + file.getName());
        FileInputSource inputSource = new FileInputSource(file, "AndroidManifest.xml.bin");
        this.getApkModule().add(inputSource);
    }

    private void encodeManifestXml(File mainDirectory) {
        if (mainDirectory == null) {
            return;
        }
        File file = new File(mainDirectory, "AndroidManifest.xml");
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Encode manifest: " + file.getName());
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        TableBlock tableBlock = this.getApkModule().getTableBlock();
        PackageBlock packageBlock = encodeMaterials.pickMainPackageBlock(tableBlock);
        if (packageBlock != null) {
            encodeMaterials.setCurrentPackage(packageBlock);
        }
        XMLFileSource xmlSource = new XMLFileSource("AndroidManifest.xml", file);
        XMLEncodeSource xmlEncodeSource = new XMLEncodeSource(encodeMaterials, xmlSource);
        this.getApkModule().add(xmlEncodeSource);
    }

    private void scanResFilesDirectory(File mainDirectory) {
        File resFilesDirectory = new File(mainDirectory, "res-files");
        if (!resFilesDirectory.isDirectory()) {
            return;
        }
        this.logMessage("Searching files: " + resFilesDirectory.getName());
        List<File> fileList = ApkUtil.recursiveFiles(resFilesDirectory);
        for (File file : fileList) {
            this.encodeResFile(resFilesDirectory, file);
        }
    }

    private void encodeResFile(File resFilesDirectory, File file) {
        String path = ApkUtil.toArchivePath(resFilesDirectory, file);
        this.logVerbose(path);
        Entry entry = this.getEntry(path);
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        if (file.getName().endsWith(".xml")) {
            XMLFileSource xmlSource = new XMLFileSource(path, file);
            XMLEncodeSource xmlEncodeSource = new XMLEncodeSource(encodeMaterials, xmlSource);
            xmlEncodeSource.setEntry(entry);
            this.getApkModule().add(xmlEncodeSource);
        } else {
            FileInputSource inputSource = new FileInputSource(file, path);
            this.getApkModule().add(inputSource);
        }
    }

    private Entry getEntry(String path) {
        List<Entry> entryList = this.getApkModule().listReferencedEntries(path);
        if (entryList.size() > 0) {
            return entryList.get(0);
        }
        return null;
    }

    public EncodeMaterials getEncodeMaterials() {
        EncodeMaterials materials = this.mEncodeMaterials;
        if (materials == null) {
            materials = new EncodeMaterials();
            materials.setAPKLogger(this.getApkLogger());
            this.mEncodeMaterials = materials;
        }
        return materials;
    }

    public void setEncodeMaterials(EncodeMaterials encodeMaterials) {
        this.mEncodeMaterials = encodeMaterials;
    }

    @Override
    public void setApkLogger(APKLogger apkLogger) {
        super.setApkLogger(apkLogger);
        this.tableBlockEncoder.setApkLogger(apkLogger);
    }
}

