/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.xmldecoder.ResXmlDocumentSerializer;
import com.reandroid.apk.xmldecoder.XMLEntryDecoderSerializer;
import com.reandroid.apk.xmldecoder.XMLNamespaceValidator;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParserException;

public class ApkModuleXmlDecoder
extends ApkModuleDecoder
implements Predicate<Entry> {
    private final Map<Integer, Set<ResConfig>> decodedEntries = new HashMap<Integer, Set<ResConfig>>();
    private ResXmlDocumentSerializer documentSerializer;
    private XMLEntryDecoderSerializer entrySerializer;
    private boolean keepResPath;

    public ApkModuleXmlDecoder(ApkModule apkModule) {
        super(apkModule);
    }

    public void setKeepResPath(boolean keepResPath) {
        this.keepResPath = keepResPath;
    }

    public boolean keepResPath() {
        return this.keepResPath;
    }

    @Override
    void initialize() {
        super.initialize();
        this.validateResourceNames();
    }

    @Override
    public void decodeResourceTable(File mainDirectory) throws IOException {
        TableBlock tableBlock = this.getApkModule().getTableBlock();
        this.decodeTableBlock(mainDirectory, tableBlock);
        this.decodeResFiles(mainDirectory);
        this.decodeValues(mainDirectory, tableBlock);
    }

    private void decodeTableBlock(File mainDirectory, TableBlock tableBlock) throws IOException {
        try {
            this.decodePackageInfo(mainDirectory, tableBlock);
            this.decodePublicXml(mainDirectory, tableBlock);
            this.addDecodedPath("resources.arsc");
        }
        catch (IOException exception) {
            this.logOrThrow("Error decoding resource table", exception);
        }
    }

    private void decodePackageInfo(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.decodePackageInfo(mainDirectory, packageBlock);
        }
    }

    private void decodePackageInfo(File mainDirectory, PackageBlock packageBlock) throws IOException {
        File packageDirectory = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        File packageJsonFile = new File(packageDirectory, "package.json");
        JSONObject jsonObject = packageBlock.toJson(false);
        jsonObject.write(packageJsonFile);
    }

    private void decodeResFiles(File mainDirectory) throws IOException {
        if (this.keepResPath()) {
            this.logMessage("Res files: res-files");
        } else {
            this.logMessage("Res files: resources");
        }
        List<ResFile> resFileList = this.getApkModule().listResFiles();
        for (ResFile resFile : resFileList) {
            this.decodeResFile(mainDirectory, resFile);
        }
    }

    private void decodeResFile(File mainDirectory, ResFile resFile) throws IOException {
        if (resFile.isBinaryXml()) {
            try {
                this.decodeResXml(mainDirectory, resFile);
            }
            catch (Exception ex) {
                this.logOrThrow("Failed to decode: " + resFile.getFilePath(), ex);
            }
            return;
        }
        String path = resFile.getFilePath();
        if (path.endsWith(".xml")) {
            this.logMessage("Ignore non bin xml: " + path);
            return;
        }
        this.decodeResRaw(mainDirectory, resFile);
    }

    private void decodeResRaw(File mainDirectory, ResFile resFile) throws IOException {
        Entry entry = resFile.pickOne();
        PackageBlock packageBlock = entry.getPackageBlock();
        File file = this.toDecodeResFile(mainDirectory, resFile, packageBlock);
        InputSource inputSource = resFile.getInputSource();
        this.logVerbose(inputSource.getAlias());
        inputSource.write(file);
        if (!this.keepResPath()) {
            this.addDecodedEntry(entry);
        }
        this.addDecodedPath(inputSource.getAlias());
    }

    private void decodeResXml(File mainDirectory, ResFile resFile) throws IOException {
        Entry entry = resFile.pickOne();
        PackageBlock packageBlock = entry.getPackageBlock();
        File file = this.toDecodeResFile(mainDirectory, resFile, packageBlock);
        InputSource inputSource = resFile.getInputSource();
        this.logVerbose(inputSource.getAlias());
        this.serializeXml(packageBlock.getId(), resFile.getInputSource(), file);
        if (!this.keepResPath()) {
            this.addDecodedEntry(entry);
        }
        this.addDecodedPath(inputSource.getAlias());
    }

    private File toDecodeResFile(File mainDirectory, ResFile resFile, PackageBlock packageBlock) {
        File dir;
        String path;
        if (this.keepResPath()) {
            path = resFile.getInputSource().getAlias();
            dir = new File(mainDirectory, "res-files");
        } else {
            path = resFile.buildPath("res");
            dir = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
            resFile.setFilePath(path);
        }
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    private ResXmlDocumentSerializer getDocumentSerializer() {
        if (this.documentSerializer == null) {
            this.documentSerializer = new ResXmlDocumentSerializer(this.getApkModule());
            this.documentSerializer.setValidateXmlNamespace(true);
        }
        return this.documentSerializer;
    }

    private void decodePublicXml(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.decodePublicXml(mainDirectory, packageBlock);
        }
        if (tableBlock.countPackages() == 0) {
            this.decodeEmptyTable(mainDirectory);
        }
    }

    private void decodePublicXml(File mainDirectory, PackageBlock packageBlock) throws IOException {
        File packageDirectory = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        this.logMessage("public.xml: " + packageBlock.getName() + " -> " + packageDirectory.getName());
        File file = new File(packageDirectory, "res");
        file = new File(file, "values");
        file = new File(file, "public.xml");
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.load(packageBlock);
        packageIdentifier.writePublicXml(file);
    }

    private void decodeEmptyTable(File mainDirectory) throws IOException {
        this.logMessage("Decoding empty table ...");
        String pkgName = this.getApkModule().getPackageName();
        if (pkgName == null) {
            return;
        }
        File packageDirectory = new File(mainDirectory, "resources");
        packageDirectory = new File(packageDirectory, "package_1");
        this.logMessage("Empty public.xml: " + packageDirectory.getName());
        File file = new File(packageDirectory, "res");
        file = new File(file, "values");
        file = new File(file, "public.xml");
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.writePublicXml(file);
    }

    @Override
    public void decodeAndroidManifest(File mainDirectory) throws IOException {
        if (this.containsDecodedPath("AndroidManifest.xml")) {
            return;
        }
        if (!this.getApkModule().hasAndroidManifestBlock()) {
            this.logMessage("Don't have: AndroidManifest.xml");
            return;
        }
        if (this.isExcluded("AndroidManifest.xml")) {
            this.decodeAndroidManifestBin(mainDirectory);
        } else {
            this.decodeAndroidManifestXml(mainDirectory);
        }
    }

    private void decodeAndroidManifestXml(File mainDirectory) throws IOException {
        AndroidManifestBlock manifestBlock = this.getApkModule().getAndroidManifestBlock();
        File file = new File(mainDirectory, "AndroidManifest.xml");
        this.logMessage("Decoding: " + file.getName());
        int currentPackageId = manifestBlock.guessCurrentPackageId();
        this.serializeXml(currentPackageId, manifestBlock, file);
        this.addDecodedPath("AndroidManifest.xml");
    }

    private void decodeAndroidManifestBin(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "AndroidManifest.xml.bin");
        this.logMessage("Decode manifest binary: " + file.getName());
        ApkModule apkModule = this.getApkModule();
        InputSource inputSource = apkModule.getManifestOriginalSource();
        if (inputSource == null) {
            inputSource = apkModule.getInputSource("AndroidManifest.xml");
        }
        inputSource.write(file);
        this.addDecodedPath("AndroidManifest.xml");
    }

    private void serializeXml(int currentPackageId, ResXmlDocument document, File outFile) throws IOException {
        XMLNamespaceValidator.validateNamespaces(document);
        ResXmlDocumentSerializer serializer = this.getDocumentSerializer();
        if (currentPackageId != 0) {
            serializer.getDecoder().setCurrentPackageId(currentPackageId);
        }
        try {
            serializer.write(document, outFile);
        }
        catch (XmlPullParserException ex) {
            throw new IOException("Error: " + outFile.getName(), ex);
        }
    }

    private void serializeXml(int currentPackageId, InputSource inputSource, File outFile) throws IOException {
        ResXmlDocumentSerializer serializer = this.getDocumentSerializer();
        if (currentPackageId != 0) {
            serializer.getDecoder().setCurrentPackageId(currentPackageId);
        }
        try {
            serializer.write(inputSource, outFile);
        }
        catch (XmlPullParserException ex) {
            throw new IOException("Error: " + outFile.getName(), ex);
        }
    }

    private void addDecodedEntry(Entry entry) {
        if (entry.isNull()) {
            return;
        }
        int resourceId = entry.getResourceId();
        Set<ResConfig> resConfigSet = this.decodedEntries.get(resourceId);
        if (resConfigSet == null) {
            resConfigSet = new HashSet<ResConfig>();
            this.decodedEntries.put(resourceId, resConfigSet);
        }
        resConfigSet.add(entry.getResConfig());
    }

    private boolean containsDecodedEntry(Entry entry) {
        Set<ResConfig> resConfigSet = this.decodedEntries.get(entry.getResourceId());
        if (resConfigSet == null) {
            return false;
        }
        return resConfigSet.contains(entry.getResConfig());
    }

    private void decodeValues(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.decodeValues(mainDirectory, packageBlock);
        }
    }

    private void decodeValues(File mainDirectory, PackageBlock packageBlock) throws IOException {
        File packageDir = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        this.logVerbose("Values: " + packageDir.getName());
        packageBlock.sortTypes();
        File resDir = new File(packageDir, "res");
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            this.decodeValues(resDir, specTypePair);
        }
    }

    private void decodeValues(File resDir, SpecTypePair specTypePair) throws IOException {
        this.getEntrySerializer().decode(resDir, specTypePair);
    }

    private XMLEntryDecoderSerializer getEntrySerializer() {
        if (this.entrySerializer == null) {
            this.entrySerializer = new XMLEntryDecoderSerializer(this.getApkModule().getTableBlock());
            this.entrySerializer.setDecodedEntries(this);
        }
        return this.entrySerializer;
    }

    @Override
    public boolean test(Entry entry) {
        return !this.containsDecodedEntry(entry);
    }
}

