/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.PowerManager;

public class WakeLockManager {
    private PowerManager.WakeLock wakeLock;
    private WifiManager.WifiLock wifiLock;

    public void acquire(Context context, boolean keepScreenOn, boolean keepWifiOn) {
        try {
            PowerManager powerManager;
            if (!(this.wakeLock != null && this.wakeLock.isHeld() || (powerManager = (PowerManager)context.getSystemService("power")) == null)) {
                int flags = 1;
                if (keepScreenOn) {
                    flags = 805306394;
                }
                this.wakeLock = powerManager.newWakeLock(flags, "App:IncomingCall");
                this.wakeLock.setReferenceCounted(false);
                this.wakeLock.acquire();
            }
        }
        catch (Exception powerManager) {
            // empty catch block
        }
        try {
            WifiManager wifiManager;
            if (keepWifiOn && (this.wifiLock == null || !this.wifiLock.isHeld()) && (wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi")) != null) {
                this.wifiLock = wifiManager.createWifiLock(3, "p:WifiLock");
                this.wifiLock.setReferenceCounted(false);
                this.wifiLock.acquire();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        try {
            if (this.wakeLock != null && this.wakeLock.isHeld()) {
                this.wakeLock.release();
                this.wakeLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.wifiLock != null && this.wifiLock.isHeld()) {
                this.wifiLock.release();
                this.wifiLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

