/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;

public class SettingsManager {
    private static final String TAG = "SettingsManager";
    private Context context;

    public SettingsManager(Context context) {
        this.context = context;
    }

    private boolean hasWriteSettingsPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.System.canWrite((Context)this.context);
        }
        return false;
    }

    public void setVibrationMode(boolean enabled) {
        Vibrator vibrator = (Vibrator)this.context.getSystemService("vibrator");
        if (vibrator != null && vibrator.hasVibrator()) {
            if (enabled) {
                vibrator.vibrate(1000L);
            } else {
                vibrator.cancel();
            }
        }
    }

    public boolean isVibrationEnabled() {
        Vibrator vibrator = (Vibrator)this.context.getSystemService("vibrator");
        return vibrator != null && vibrator.hasVibrator();
    }

    public void setDataRoamingEnabled(boolean enabled) {
        if (this.hasWriteSettingsPermission()) {
            try {
                Settings.Global.putInt((ContentResolver)this.context.getContentResolver(), (String)"data_roaming", (int)(enabled ? 1 : 0));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Unable to set data roaming: " + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"Write settings permission not granted.");
        }
    }

    public boolean isDataRoamingEnabled() {
        try {
            return Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"data_roaming") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)("Data roaming setting not found: " + e.getMessage()));
            return false;
        }
    }

    public void setScreenTimeout(int timeoutMillis) {
        if (this.hasWriteSettingsPermission()) {
            try {
                Settings.System.putInt((ContentResolver)this.context.getContentResolver(), (String)"screen_off_timeout", (int)timeoutMillis);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Unable to set screen timeout: " + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"Write settings permission not granted.");
        }
    }

    public int getScreenTimeout() {
        try {
            return Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"screen_off_timeout");
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)("Screen timeout setting not found: " + e.getMessage()));
            return -1;
        }
    }

    public void setScreenBrightness(int brightnessLevel) {
        if (this.hasWriteSettingsPermission()) {
            if (brightnessLevel < 0) {
                brightnessLevel = 0;
            }
            if (brightnessLevel > 255) {
                brightnessLevel = 255;
            }
            try {
                Settings.System.putInt((ContentResolver)this.context.getContentResolver(), (String)"screen_brightness", (int)brightnessLevel);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Unable to set screen brightness: " + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"Write settings permission not granted.");
        }
    }

    public int getScreenBrightness() {
        try {
            return Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)("Screen brightness setting not found: " + e.getMessage()));
            return -1;
        }
    }
}

