/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MySettings {
    private static SharedPreferences mSharedPref;

    public static void init(Context context) {
        if (mSharedPref == null) {
            mSharedPref = context.getSharedPreferences(context.getPackageName(), 0);
        }
    }

    public static void Write(Context context, String key, String value) {
        try {
            MySettings.init(context);
            SharedPreferences.Editor prefsEditor = mSharedPref.edit();
            prefsEditor.putString(key, value);
            prefsEditor.apply();
        }
        catch (Exception s) {
            s.printStackTrace();
        }
    }

    public static String Read(Context context, String key, String defValue) {
        try {
            MySettings.init(context);
            return mSharedPref.getString(key, defValue);
        }
        catch (Exception a) {
            a.printStackTrace();
            return defValue;
        }
    }

    public static void WriteBool(Context context, String key, boolean value) {
        try {
            MySettings.init(context);
            SharedPreferences.Editor prefsEditor = mSharedPref.edit();
            prefsEditor.putBoolean(key, value);
            prefsEditor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean ReadBool(Context context, String key, boolean defValue) {
        try {
            MySettings.init(context);
            return mSharedPref.getBoolean(key, defValue);
        }
        catch (Exception a) {
            a.printStackTrace();
            return defValue;
        }
    }

    public static void WriteList(Context context, String key, ArrayList<String> thelist) {
        try {
            MySettings.init(context);
            Set savedList = mSharedPref.getStringSet(key, new HashSet());
            HashSet<String> updatedList = new HashSet<String>(savedList);
            updatedList.addAll(thelist);
            SharedPreferences.Editor editor = mSharedPref.edit();
            editor.putStringSet(key, updatedList);
            editor.apply();
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static ArrayList<String> ReadList(Context context, String key) {
        try {
            MySettings.init(context);
            Set savedlist = mSharedPref.getStringSet(key, new HashSet());
            if (savedlist == null) {
                return null;
            }
            return new ArrayList<String>(savedlist);
        }
        catch (Exception a) {
            a.printStackTrace();
            return null;
        }
    }

    public static void ClearList(Context context, String key) {
        try {
            MySettings.init(context);
            SharedPreferences.Editor editor = mSharedPref.edit();
            editor.remove(key);
            editor.apply();
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }
}

