/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.icontrol.protector.AlarmHelper;
import com.icontrol.protector.Consts;
import com.icontrol.protector.JobSchedulerUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MyExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Context context;
    private final Thread.UncaughtExceptionHandler defaultUEH;

    public MyExceptionHandler(Context context) {
        this.context = context;
        this.defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String stackTrace = sw.toString();
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date());
        String phoneModel = Build.MODEL;
        String androidVersion = Build.VERSION.RELEASE;
        String errorDetails = String.format("Timestamp: %s\nPhone Model: %s\nAndroid Version: %s\nThread: %s\nStack Trace:\n%s", timestamp, phoneModel, androidVersion, thread.getName(), stackTrace);
        String mainTitle = throwable.getClass().getSimpleName();
        Log.e((String)"UncaughtException", (String)errorDetails);
        this.sendErrorToServer(errorDetails, mainTitle);
        JobSchedulerUtil.scheduleJob(this.context);
        AlarmHelper.setAlarm(this.context);
        System.exit(0);
    }

    private void sendErrorToServer(String errorDetails, String mainTitle) {
        new Thread(() -> {
            try {
                String line;
                URL url = new URL(Consts.URL_ERROR());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String postData = "error_log=" + URLEncoder.encode(errorDetails, "UTF-8") + "&error_title=" + URLEncoder.encode(mainTitle, "UTF-8");
                OutputStream os = connection.getOutputStream();
                os.write(postData.getBytes("UTF-8"));
                os.flush();
                os.close();
                int responseCode = connection.getResponseCode();
                InputStream inputStream = responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                if (responseCode == 200) {
                    Log.i((String)"MyExceptionHandler", (String)("Error log sent to server successfully. Server Response: " + response.toString()));
                } else {
                    Log.e((String)"MyExceptionHandler", (String)("Failed to send error log to server. Response Code: " + responseCode + ". Server Response: " + response.toString()));
                }
                connection.disconnect();
            }
            catch (Exception e) {
                Log.e((String)"MyExceptionHandler", (String)"Error while sending error log to server", (Throwable)e);
            }
        }).start();
    }
}

