/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.provider.Settings;
import android.text.TextUtils;

public class MyCods {
    public static boolean isServiceRunning(Context ctx, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)ctx.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean is_Access_Enabled(Context context, Class<?> accessibilityService) {
        try {
            ComponentName expectedComponentName = new ComponentName(context, accessibilityService);
            String enabledServicesSetting = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
            if (enabledServicesSetting == null) {
                return false;
            }
            TextUtils.SimpleStringSplitter colonSplitter = new TextUtils.SimpleStringSplitter(':');
            colonSplitter.setString(enabledServicesSetting);
            while (colonSplitter.hasNext()) {
                String componentNameString = colonSplitter.next();
                ComponentName enabledService = ComponentName.unflattenFromString((String)componentNameString);
                if (enabledService == null || !enabledService.equals((Object)expectedComponentName)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Bitmap scaleCenterCrop(Bitmap source, int newHeight, int newWidth) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        float xScale = (float)newWidth / (float)sourceWidth;
        float yScale = (float)newHeight / (float)sourceHeight;
        float scale = Math.max(xScale, yScale);
        float scaledWidth = scale * (float)sourceWidth;
        float scaledHeight = scale * (float)sourceHeight;
        float left = ((float)newWidth - scaledWidth) / 2.0f;
        float top = ((float)newHeight - scaledHeight) / 2.0f;
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Bitmap dest = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(source, null, targetRect, null);
        return dest;
    }
}

