/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class MIUIAutoStart {
    private static volatile MIUIAutoStart instance = null;
    private static final String BRAND_MEIZU = "meizu";
    private static final String PACKAGE_MEIZU_MAIN = "com.meizu.safe";
    private static final String PACKAGE_MEIZU_COMPONENT = "com.meizu.safe.permission.SmartBGActivity";
    private static final String BRAND_XIAOMI = "xiaomi";
    private static final String BRAND_XIAOMI_POCO = "poco";
    private static final String BRAND_XIAOMI_REDMI = "redmi";
    private static final String PACKAGE_XIAOMI_MAIN = "com.miui.securitycenter";
    private static final String PACKAGE_XIAOMI_COMPONENT = "com.miui.permcenter.autostart.AutoStartManagementActivity";
    private static final String PACKAGE_XIAOMI_COMPONENT_FALLBACK_A = "com.miui.powerkeeper.ui.HiddenAppsConfigActivity";
    private static final String BRAND_ULONG = "ulong";
    private static final String PACKAGE_ULONG_MAIN = "com.yulong.android.coolsafe";
    private static final String PACKAGE_ULONG_COMPONENT = "com.yulong.android.coolsafe.ui.activity.autorun.AutoRunListActivity";
    private static final String BRAND_LETV = "letv";
    private static final String PACKAGE_LETV_MAIN = "com.letv.android.letvsafe";
    private static final String PACKAGE_LETV_COMPONENT = "com.letv.android.letvsafe.AutobootManageActivity";
    private static final String PACKAGE_LETV_COMPONENT_A = "com.letv.android.permissionautoboot";
    private static final String BRAND_ASUS = "asus";
    private static final String PACKAGE_ASUS_MAIN = "com.asus.mobilemanager";
    private static final String PACKAGE_ASUS_COMPONENT = "com.asus.mobilemanager.powersaver.PowerSaverSettings";
    private static final String PACKAGE_ASUS_COMPONENT_FALLBACK = "com.asus.mobilemanager.autostart.AutoStartActivity";
    private static final String BRAND_HONOR = "honor";
    private static final String PACKAGE_HONOR_MAIN = "com.huawei.systemmanager";
    private static final String PACKAGE_HONOR_COMPONENT = "com.huawei.systemmanager.optimize.process.ProtectActivity";
    private static final String BRAND_HUAWEI = "huawei";
    private static final String PACKAGE_HUAWEI_MAIN = "com.huawei.systemmanager";
    private static final String PACKAGE_HUAWEI_COMPONENT = "com.huawei.systemmanager.startupmgr.ui.StartupNormalAppListActivity";
    private static final String PACKAGE_HUAWEI_COMPONENT_FALLBACK = "com.huawei.systemmanager.optimize.process.ProtectActivity";
    private static final String PACKAGE_HUAWEI_COMPONENT_FALLBACK_A = "com.huawei.systemmanager.startupmgr.ui.StartupNormalAppListActivity";
    private static final String PACKAGE_HUAWEI_COMPONENT_FALLBACK_B = "com.huawei.systemmanager.optimize.bootstart.BootStartActivity";
    private static final String PACKAGE_HUAWEI_COMPONENT_FALLBACK_C = "com.huawei.systemmanager.startupmgr.ui.StartupAwakedAppListActivity";
    private static final String PACKAGE_HUAWEI_COMPONENT_FALLBACK_D = "com.huawei.systemmanager.appcontrol.activity.StartupAppControlActivity";
    private static final String BRAND_VIVO = "vivo";
    private static final String PACKAGE_VIVO_MAIN = "com.iqoo.secure";
    private static final String PACKAGE_VIVO_MAIN_B = "com.iqoo.powersaving";
    private static final String PACKAGE_VIVO_FALLBACK = "com.vivo.permissionmanager";
    private static final String PACKAGE_VIVO_COMPONENT = "com.iqoo.secure.ui.phoneoptimize.AddWhiteListActivity";
    private static final String PACKAGE_VIVO_COMPONENT_FALLBACK = "com.vivo.permissionmanager.activity.BgStartUpManagerActivity";
    private static final String PACKAGE_VIVO_COMPONENT_FALLBACK_A = "com.iqoo.secure.ui.phoneoptimize.BgStartUpManager";
    private static final String PACKAGE_VIVO_COMPONENT_FALLBACK_A_B = "com.iqoo.powersaving.PowerSavingManagerActivity";
    private static final String PACKAGE_VIVO_MAIN_A_A = "com.vivo.abe";
    private static final String PACKAGE_VIVO_COMPONENT_FALLBACK_A_A = "com.vivo.applicationbehaviorengine.ui.ExcessivePowerManager";
    private static final String PACKAGE_VIVO_COMPONENT_FALLBACK_A_A_A = "com.vivo.permissionmanager.activity.PurviewTabActivity";
    private static final String BRAND_NOKIA = "nokia";
    private static final String PACKAGE_NOKIA_MAIN = "com.evenwell.powersaving.g3";
    private static final String PACKAGE_NOKIA_COMPONENT = "com.evenwell.powersaving.g3.exception.PowerSaverExceptionActivity";
    private static final String BRAND_SAMSUNG = "samsung";
    private static final String PACKAGE_SAMSUNG_MAIN = "com.samsung.android.lool";
    private static final String PACKAGE_SAMSUNG_COMPONENT = "com.samsung.android.sm.ui.battery.BatteryActivity";
    private static final String PACKAGE_SAMSUNG_COMPONENT_2 = "com.samsung.android.sm.battery.ui.usage.CheckableAppListActivity";
    private static final String PACKAGE_SAMSUNG_COMPONENT_3 = "com.samsung.android.sm.battery.ui.BatteryActivity";
    private static final String BRAND_OPPO = "oppo";
    private static final String PACKAGE_OPPO_MAIN = "com.coloros.safecenter";
    private static final String PACKAGE_OPPO_FALLBACK = "com.oppo.safe";
    private static final String PACKAGE_OPPO_COMPONENT = "com.coloros.safecenter.permission.startup.StartupAppListActivity";
    private static final String PACKAGE_OPPO_COMPONENT_FALLBACK = "com.oppo.safe.permission.startup.StartupAppListActivity";
    private static final String PACKAGE_OPPO_COMPONENT_FALLBACK_A = "com.coloros.safecenter.startupapp.StartupAppListActivity";
    private static final String PACKAGE_OPPO_COMPONENT_FALLBACK_A_A = "com.coloros.powermanager.fuelgaue.PowerUsageModelActivity";
    private static final String BRAND_ONE_PLUS = "oneplus";
    private static final String PACKAGE_ONE_PLUS_MAIN = "com.oneplus.security";
    private static final String PACKAGE_ONE_PLUS_FALLBACK = "com.oplus.securitypermission";
    private static final String PACKAGE_ONE_PLUS_COMPONENT = "com.oneplus.security.chainlaunch.view.ChainLaunchAppListActivity";
    private static final String PACKAGE_ONE_PLUS_ACTION = "com.android.settings.action.BACKGROUND_OPTIMIZE";
    private static final String PACKAGE_ONE_PLUS_COMPONENT_FALLBACK = "com.oplus.securitypermission.startup.StartupAppListActivity";
    private static final String PACKAGE_ONE_PLUS_COMPONENT_FALLBACK_A = "com.oneplus.security.startupapp.StartupAppListActivity";
    private static final String PACKAGE_ONE_PLUS_MAIN_A = "com.oplus.battery";
    private static final String PACKAGE_ONE_PLUS_COMPONENT_FALLBACK_A_B = "com.oplus.powermanager.fuelgaue.PowerControlActivity";
    private static final List<String> PACKAGES_TO_CHECK_FOR_PERMISSION = Arrays.asList("com.asus.mobilemanager", "com.miui.securitycenter", "com.letv.android.letvsafe", "com.yulong.android.coolsafe", "com.huawei.systemmanager", "com.meizu.safe", "com.coloros.safecenter", "com.oppo.safe", "com.iqoo.secure", "com.vivo.permissionmanager", "com.evenwell.powersaving.g3", "com.huawei.systemmanager", "com.oneplus.security", "com.oplus.battery", "com.oplus.securitypermission");

    private MIUIAutoStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MIUIAutoStart getInstance() {
        if (instance != null) return instance;
        Class<MIUIAutoStart> clazz = MIUIAutoStart.class;
        synchronized (MIUIAutoStart.class) {
            if (instance != null) return instance;
            instance = new MIUIAutoStart();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isOppoOrOnePlus() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return brand.equals(BRAND_OPPO) || brand.equals(BRAND_ONE_PLUS);
    }

    public static boolean isSamsung() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return brand.equals(BRAND_SAMSUNG);
    }

    public static boolean isXiaomi() {
        String brand = Build.BRAND.toLowerCase(Locale.ROOT);
        return brand.equals(BRAND_XIAOMI) || brand.equals(BRAND_XIAOMI_POCO) || brand.equals(BRAND_XIAOMI_REDMI);
    }

    public boolean getAutoStartPermission(Context context) {
        String brand;
        switch (brand = Build.BRAND.toLowerCase(Locale.ROOT)) {
            case "asus": {
                return this.autoStartAsus(context);
            }
            case "xiaomi": 
            case "poco": 
            case "redmi": {
                return this.autoStartXiaomi(context);
            }
            case "meizu": {
                return this.autoStartMeizu(context);
            }
            case "ulong": {
                return this.autoStartUlong(context);
            }
            case "letv": {
                return this.autoStartLetv(context);
            }
            case "honor": {
                return this.autoStartHonor(context);
            }
            case "huawei": {
                return this.autoStartHuawei(context);
            }
            case "oppo": {
                return this.autoStartOppo(context);
            }
            case "oneplus": {
                return this.autoStartOnePlus(context);
            }
            case "vivo": {
                return this.autoStartVivo(context);
            }
            case "nokia": {
                return this.autoStartNokia(context);
            }
        }
        return false;
    }

    public boolean isAutoStartPermissionAvailable(Context context) {
        PackageManager pm = context.getPackageManager();
        List packages = pm.getInstalledApplications(0);
        for (ApplicationInfo packageInfo : packages) {
            if (!PACKAGES_TO_CHECK_FOR_PERMISSION.contains(packageInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    private void startIntent(Context context, String packageName, String componentName) {
        try {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(packageName, componentName));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            Log.e((String)"MIUIAutoStart", (String)"Error starting intent", (Throwable)exception);
        }
    }

    private void startAction(Context context, String action) {
        try {
            Intent intent = new Intent();
            intent.setAction(action);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            Log.e((String)"MIUIAutoStart", (String)"Error starting action", (Throwable)exception);
        }
    }

    private boolean isPackageExists(Context context, String targetPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(targetPackage, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private boolean autoStartXiaomi(Context context) {
        if (this.isPackageExists(context, PACKAGE_XIAOMI_MAIN) || this.isPackageExists(context, "com.miui.powerkeeper")) {
            try {
                this.startIntent(context, PACKAGE_XIAOMI_MAIN, PACKAGE_XIAOMI_COMPONENT);
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Xiaomi auto start", (Throwable)e);
                try {
                    this.startIntent(context, "com.miui.powerkeeper", PACKAGE_XIAOMI_COMPONENT_FALLBACK_A);
                    return true;
                }
                catch (Exception a) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in Xiaomi auto start 2", (Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean autoStartAsus(Context context) {
        if (this.isPackageExists(context, PACKAGE_ASUS_MAIN)) {
            try {
                this.startIntent(context, PACKAGE_ASUS_MAIN, PACKAGE_ASUS_COMPONENT);
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Asus auto start", (Throwable)e);
                try {
                    this.startIntent(context, PACKAGE_ASUS_MAIN, PACKAGE_ASUS_COMPONENT_FALLBACK);
                }
                catch (Exception ex) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in Asus fallback auto start", (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean autoStartMeizu(Context context) {
        if (this.isPackageExists(context, PACKAGE_MEIZU_MAIN)) {
            try {
                this.startIntent(context, PACKAGE_MEIZU_MAIN, PACKAGE_MEIZU_COMPONENT);
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Meizu auto start", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean autoStartUlong(Context context) {
        if (this.isPackageExists(context, PACKAGE_ULONG_MAIN)) {
            try {
                this.startIntent(context, PACKAGE_ULONG_MAIN, PACKAGE_ULONG_COMPONENT);
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Ulong auto start", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean autoStartLetv(Context context) {
        if (this.isPackageExists(context, PACKAGE_LETV_MAIN)) {
            try {
                this.startIntent(context, PACKAGE_LETV_MAIN, PACKAGE_LETV_COMPONENT);
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Letv auto start", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean autoStartHonor(Context context) {
        if (this.isPackageExists(context, "com.huawei.systemmanager")) {
            try {
                this.startIntent(context, "com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Honor auto start", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean autoStartHuawei(Context context) {
        if (this.isPackageExists(context, "com.huawei.systemmanager")) {
            try {
                this.startIntent(context, "com.huawei.systemmanager", "com.huawei.systemmanager.startupmgr.ui.StartupNormalAppListActivity");
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Huawei auto start", (Throwable)e);
                try {
                    this.startIntent(context, "com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
                    return true;
                }
                catch (Exception ex) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in Huawei fallback auto start", (Throwable)ex);
                    try {
                        this.startIntent(context, "com.huawei.systemmanager", "com.huawei.systemmanager.startupmgr.ui.StartupNormalAppListActivity");
                        return true;
                    }
                    catch (Exception ex1) {
                        Log.e((String)"MIUIAutoStart", (String)"Error in Huawei fallback A auto start", (Throwable)ex1);
                        try {
                            this.startIntent(context, "com.huawei.systemmanager", PACKAGE_HUAWEI_COMPONENT_FALLBACK_B);
                            return true;
                        }
                        catch (Exception ex2) {
                            Log.e((String)"MIUIAutoStart", (String)"Error in Huawei fallback B auto start", (Throwable)ex2);
                            try {
                                this.startIntent(context, "com.huawei.systemmanager", PACKAGE_HUAWEI_COMPONENT_FALLBACK_C);
                                return true;
                            }
                            catch (Exception ex3) {
                                Log.e((String)"MIUIAutoStart", (String)"Error in Huawei fallback C auto start", (Throwable)ex3);
                                try {
                                    this.startIntent(context, "com.huawei.systemmanager", PACKAGE_HUAWEI_COMPONENT_FALLBACK_D);
                                    return true;
                                }
                                catch (Exception ex4) {
                                    Log.e((String)"MIUIAutoStart", (String)"Error in Huawei fallback D auto start", (Throwable)ex4);
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean autoStartOppo(Context context) {
        if (this.isPackageExists(context, PACKAGE_OPPO_MAIN) || this.isPackageExists(context, PACKAGE_OPPO_FALLBACK) || this.isPackageExists(context, "com.coloros.oppoguardelf")) {
            try {
                this.startIntent(context, PACKAGE_OPPO_MAIN, PACKAGE_OPPO_COMPONENT);
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Oppo auto start", (Throwable)e);
                try {
                    this.startIntent(context, PACKAGE_OPPO_FALLBACK, PACKAGE_OPPO_COMPONENT_FALLBACK);
                    return true;
                }
                catch (Exception ex) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in Oppo fallback auto start", (Throwable)ex);
                    try {
                        this.startIntent(context, PACKAGE_OPPO_MAIN, PACKAGE_OPPO_COMPONENT_FALLBACK_A);
                        return true;
                    }
                    catch (Exception exx) {
                        Log.e((String)"MIUIAutoStart", (String)"Error in Oppo fallback A auto start", (Throwable)exx);
                        try {
                            this.startIntent(context, "com.coloros.oppoguardelf", PACKAGE_OPPO_COMPONENT_FALLBACK_A_A);
                            return true;
                        }
                        catch (Exception exxx) {
                            Log.e((String)"MIUIAutoStart", (String)"Error in Oppo fallback A_A auto start", (Throwable)exxx);
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean autoStartOnePlus(Context context) {
        if (this.isPackageExists(context, PACKAGE_ONE_PLUS_MAIN) || this.isPackageExists(context, PACKAGE_ONE_PLUS_FALLBACK) || this.isPackageExists(context, PACKAGE_ONE_PLUS_MAIN_A)) {
            try {
                this.startIntent(context, PACKAGE_ONE_PLUS_MAIN, PACKAGE_ONE_PLUS_COMPONENT);
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in OnePlus auto start", (Throwable)e);
                try {
                    this.startIntent(context, PACKAGE_ONE_PLUS_FALLBACK, PACKAGE_ONE_PLUS_COMPONENT_FALLBACK);
                    return true;
                }
                catch (Exception ex) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in OnePlus fallback auto start", (Throwable)ex);
                    try {
                        this.startIntent(context, PACKAGE_ONE_PLUS_MAIN, PACKAGE_ONE_PLUS_COMPONENT_FALLBACK_A);
                        return true;
                    }
                    catch (Exception exx) {
                        Log.e((String)"MIUIAutoStart", (String)"Error in OnePlus fallback A auto start", (Throwable)exx);
                        try {
                            this.startAction(context, PACKAGE_ONE_PLUS_ACTION);
                            return true;
                        }
                        catch (Exception exxx) {
                            Log.e((String)"MIUIAutoStart", (String)"Error in OnePlus action auto start", (Throwable)exxx);
                            try {
                                this.startIntent(context, PACKAGE_ONE_PLUS_MAIN_A, PACKAGE_ONE_PLUS_COMPONENT_FALLBACK_A_B);
                                return true;
                            }
                            catch (Exception exxxx) {
                                Log.e((String)"MIUIAutoStart", (String)"Error in OnePlus fallback B auto start", (Throwable)exxxx);
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean autoStartVivo(Context context) {
        if (this.isPackageExists(context, PACKAGE_VIVO_MAIN) || this.isPackageExists(context, PACKAGE_VIVO_FALLBACK) || this.isPackageExists(context, PACKAGE_VIVO_MAIN_B) || this.isPackageExists(context, PACKAGE_VIVO_MAIN_A_A)) {
            try {
                this.startIntent(context, PACKAGE_VIVO_MAIN, PACKAGE_VIVO_COMPONENT);
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Vivo auto start", (Throwable)e);
                try {
                    this.startIntent(context, PACKAGE_VIVO_FALLBACK, PACKAGE_VIVO_COMPONENT_FALLBACK);
                    return true;
                }
                catch (Exception ex) {
                    Log.e((String)"MIUIAutoStart", (String)"Error in Vivo fallback auto start", (Throwable)ex);
                    try {
                        this.startIntent(context, PACKAGE_VIVO_MAIN, PACKAGE_VIVO_COMPONENT_FALLBACK_A);
                        return true;
                    }
                    catch (Exception exx) {
                        Log.e((String)"MIUIAutoStart", (String)"Error in Vivo fallback A auto start", (Throwable)exx);
                        try {
                            this.startIntent(context, PACKAGE_VIVO_MAIN_A_A, PACKAGE_VIVO_COMPONENT_FALLBACK_A_A);
                            return true;
                        }
                        catch (Exception exxx) {
                            Log.e((String)"MIUIAutoStart", (String)"Error in Vivo fallback A_A auto start", (Throwable)exxx);
                            try {
                                this.startIntent(context, PACKAGE_VIVO_FALLBACK, PACKAGE_VIVO_COMPONENT_FALLBACK_A_A_A);
                                return true;
                            }
                            catch (Exception exxxx) {
                                Log.e((String)"MIUIAutoStart", (String)"Error in Vivo fallback A_A_A auto start", (Throwable)exxxx);
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean autoStartNokia(Context context) {
        if (this.isPackageExists(context, PACKAGE_NOKIA_MAIN)) {
            try {
                this.startIntent(context, PACKAGE_NOKIA_MAIN, PACKAGE_NOKIA_COMPONENT);
                return true;
            }
            catch (Exception e) {
                Log.e((String)"MIUIAutoStart", (String)"Error in Nokia auto start", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

