/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import com.icontrol.protector.MyJobService;
import com.icontrol.protector.MyLoger;

public class JobSchedulerUtil {
    private static final int JOB_ID = 100;

    public static void scheduleJob(Context context) {
        try {
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            ComponentName componentName = new ComponentName(context, MyJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(100, componentName);
            builder.setRequiredNetworkType(1);
            builder.setPersisted(true);
            builder.setPeriodic(900000L);
            builder.setRequiresDeviceIdle(false);
            builder.setRequiresCharging(false);
            int result = jobScheduler.schedule(builder.build());
            if (result == 1) {
                MyLoger.Debug("Successfully scheduled", " job: " + result);
            } else {
                MyLoger.Error("Scheduled FAILURE", " job: " + result);
            }
        }
        catch (Exception e) {
            MyLoger.Error("scheduleJob", e.getMessage());
        }
    }

    public static void cancelJob(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.cancel(100);
    }
}

