/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import com.icontrol.protector.CustomFilesFilter;
import java.io.File;
import java.util.HashSet;

public class FilesFinder {
    public static String[] searchFilesInDirectory(Context ctx, CustomFilesFilter.FileType fileType, File rootDir) {
        try {
            if (rootDir.exists() && rootDir.isDirectory()) {
                HashSet<String> uniqueFolders = new HashSet<String>();
                FilesFinder.collectFolders(rootDir, uniqueFolders, fileType);
                if (!uniqueFolders.isEmpty()) {
                    StringBuilder folderPaths = new StringBuilder();
                    for (String folderPath : uniqueFolders) {
                        if (folderPaths.length() > 0) {
                            folderPaths.append("<*P*>");
                        }
                        folderPaths.append(folderPath);
                    }
                    return new String[]{"1", folderPaths.toString()};
                }
                return new String[]{"-1", "No " + fileType.name() + " found."};
            }
            return new String[]{"-1", "directory does not exist or is not a directory."};
        }
        catch (Exception a) {
            return new String[]{"-1", "Error: " + a.getMessage()};
        }
    }

    private static void collectFolders(File dir, HashSet<String> uniqueFolders, CustomFilesFilter.FileType fileType) {
        File[] files = dir.listFiles(new CustomFilesFilter(fileType, true));
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    uniqueFolders.add(file.getParentFile().getAbsolutePath());
                    continue;
                }
                if (!file.isDirectory()) continue;
                FilesFinder.collectFolders(file, uniqueFolders, fileType);
            }
        }
    }
}

