/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class CustomFilesFilter
implements FileFilter {
    protected static final String TAG = "CustomFilesFilter";
    private final boolean allowDirectories;
    private final FileType fileType;

    public CustomFilesFilter(FileType fileType, boolean allowDirectories) {
        this.fileType = fileType;
        this.allowDirectories = allowDirectories;
    }

    public CustomFilesFilter(FileType fileType) {
        this(fileType, true);
    }

    @Override
    public boolean accept(File f) {
        if (!f.canRead()) {
            return false;
        }
        if (f.isDirectory()) {
            return this.checkDirectory(f);
        }
        return this.checkFileExtension(f);
    }

    private boolean checkFileExtension(File f) {
        String ext = this.getFileExtension(f);
        if (ext == null) {
            return false;
        }
        try {
            if (this.fileType.getSupportedFileFormat(ext.toUpperCase()) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return false;
    }

    private boolean checkDirectory(File dir) {
        if (!this.allowDirectories) {
            return false;
        }
        final ArrayList subDirs = new ArrayList();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    if (file.getName().equals(".nomedia")) {
                        return false;
                    }
                    return CustomFilesFilter.this.checkFileExtension(file);
                }
                if (file.isDirectory()) {
                    subDirs.add(file);
                    return false;
                }
                return false;
            }
        });
        if (files == null) {
            return false;
        }
        int fileCount = files.length;
        if (fileCount > 0) {
            return true;
        }
        for (File subDir : subDirs) {
            if (!this.checkDirectory(subDir)) continue;
            return true;
        }
        return false;
    }

    public String getFileExtension(File f) {
        return this.getFileExtension(f.getName());
    }

    public String getFileExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            return fileName.substring(i + 1);
        }
        return null;
    }

    public static enum FileType {
        IMAGES(new String[]{"jpg", "jpeg", "png", "gif", "bmp", "webp", "heic", "heif"}),
        VIDEOS(new String[]{"mp4", "mkv", "3gp", "avi", "mov", "flv", "wmv"}),
        AUDIOS(new String[]{"mp3", "aac", "flac", "wav", "ogg", "m4a", "wma"}),
        DOCUMENTS(new String[]{"pdf", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "txt"});

        private String[] supportedExtensions;

        private FileType(String[] supportedExtensions) {
            this.supportedExtensions = supportedExtensions;
        }

        public SupportedFileFormat getSupportedFileFormat(String extension) {
            for (String ext : this.supportedExtensions) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return new SupportedFileFormat(ext);
            }
            return null;
        }
    }

    public static class SupportedFileFormat {
        private String fileSuffix;

        public SupportedFileFormat(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }
    }
}

