/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.icontrol.protector.LiveChat;
import com.icontrol.protector.R;
import org.json.JSONObject;

public class ChatActivity
extends Activity {
    private EditText messageEditText;
    private TextView chattitle;
    private LinearLayout chatLayout;
    private ScrollView scrollView2;
    private SharedPreferences sharedPreferences;
    private static final String CHAT_PREFS = "chat_prefs";
    private static final String CHAT_KEY = "chat_key";
    public boolean isChatActivityOpen = false;
    private static ChatActivity instance;

    public static ChatActivity getInstance() {
        return instance;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_chat);
        instance = this;
        this.messageEditText = (EditText)this.findViewById(R.id.messageEditText);
        this.chattitle = (TextView)this.findViewById(R.id.chattitle);
        this.scrollView2 = (ScrollView)this.findViewById(R.id.scrollView2);
        this.chatLayout = (LinearLayout)this.findViewById(R.id.chatLayout);
        Button sendButton = (Button)this.findViewById(R.id.sendButton);
        Intent mydata = this.getIntent();
        if (mydata != null && mydata.hasExtra("title")) {
            this.chattitle.setText((CharSequence)mydata.getStringExtra("title"));
        }
        sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String message = ChatActivity.this.messageEditText.getText().toString().trim();
                if (!message.isEmpty()) {
                    ChatActivity.this.appendToChat("You", message);
                    ChatActivity.this.messageEditText.setText((CharSequence)"");
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", (Object)"chat");
                        jsonObject.put("data", (Object)message);
                        String jsonData = jsonObject.toString();
                        LiveChat.instance(ChatActivity.this.getApplicationContext()).Livemessage(ChatActivity.this.getApplicationContext(), jsonData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void appendToChat(final String sender, final String message) {
        if (this.isChatActivityOpen) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LinearLayout messageLayout = new LinearLayout((Context)ChatActivity.this);
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.gravity = sender.equals("You") ? 0x800005 : 0x800003;
                    messageLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    messageLayout.setPadding(7, 7, 7, 7);
                    TextView messageTextView = new TextView((Context)ChatActivity.this);
                    messageTextView.setText((CharSequence)message);
                    messageTextView.setTextColor(-1);
                    messageTextView.setPadding(16, 8, 16, 8);
                    GradientDrawable drawable2 = new GradientDrawable();
                    drawable2.setShape(0);
                    if (sender.equals("You")) {
                        drawable2.setColor(Color.parseColor((String)"#2979FF"));
                    } else {
                        drawable2.setColor(Color.parseColor((String)"#4CAF50"));
                    }
                    drawable2.setCornerRadius(16.0f);
                    messageTextView.setBackground((Drawable)drawable2);
                    messageLayout.addView((View)messageTextView);
                    LinearLayout chatLayout = (LinearLayout)ChatActivity.this.findViewById(R.id.chatLayout);
                    chatLayout.addView((View)messageLayout);
                    ChatActivity.this.scrollView2.post(new Runnable(){

                        @Override
                        public void run() {
                            ChatActivity.this.scrollView2.fullScroll(130);
                        }
                    });
                }
            });
        }
    }

    protected void onStart() {
        super.onStart();
        this.isChatActivityOpen = true;
    }

    protected void onStop() {
        super.onStop();
        this.isChatActivityOpen = false;
    }
}

