/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.icontrol.protector.EngineWorker;
import com.icontrol.protector.MyCods;
import com.icontrol.protector.WorkServices;

public class Backworker
extends Worker {
    private PowerManager.WakeLock wakeLock;

    public Backworker(Context context, WorkerParameters workerParams) {
        super(context, workerParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenableWorker.Result doWork() {
        try {
            if (this.isStopped()) {
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            this.acquireWakeLock();
            Context mcontext = this.getApplicationContext();
            try {
                Intent workint = new Intent(this.getApplicationContext(), EngineWorker.class);
                if (!MyCods.isServiceRunning(this.getApplicationContext(), EngineWorker.class)) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        mcontext.startForegroundService(workint);
                    } else {
                        mcontext.startService(workint);
                    }
                }
                if (!MyCods.isServiceRunning(this.getApplicationContext(), WorkServices.class)) {
                    Intent workint2 = new Intent(this.getApplicationContext(), WorkServices.class);
                    if (Build.VERSION.SDK_INT >= 26) {
                        mcontext.startForegroundService(workint2);
                    } else {
                        mcontext.startService(workint2);
                    }
                } else {
                    try {
                        Intent intent = new Intent(this.getApplicationContext(), WorkServices.class);
                        intent.setAction("HB");
                        mcontext.startService(intent);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ListenableWorker.Result result = ListenableWorker.Result.success();
            return result;
        }
        finally {
            this.releaseWakeLock();
        }
    }

    public void onStopped() {
        super.onStopped();
        Log.w((String)"MyWorker", (String)"Worker was stopped!");
    }

    private void acquireWakeLock() {
        PowerManager powerManager = (PowerManager)this.getApplicationContext().getSystemService("power");
        if (powerManager != null) {
            this.wakeLock = powerManager.newWakeLock(0x20000001, this.getApplicationContext().getPackageName() + ":wrk");
            this.wakeLock.acquire(60000L);
        }
    }

    private void releaseWakeLock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }
}

